/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.toastymop.combatlog;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

public class CombatConfig {
    public static Config CONFIG;
    static File file;
    protected static final Logger log;

    public static Config load() {
        if (!file.getName().endsWith(".json5")) {
            throw new RuntimeException("Failed to read config");
        }
        Config cfg = null;
        if (file.exists()) {
            Config config;
            block22: {
                JsonReader reader = JsonReader.json5((Path)file.toPath());
                try {
                    cfg = new Config();
                    reader.beginObject();
                    block17: while (reader.hasNext()) {
                        String nextName;
                        switch (nextName = reader.nextName()) {
                            case "combatTime": {
                                Config.combatTime = reader.nextInt();
                                continue block17;
                            }
                            case "allDamage": {
                                Config.allDamage = reader.nextBoolean();
                                continue block17;
                            }
                            case "deathMessage": {
                                Config.deathMessage = reader.nextString();
                                continue block17;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    config = cfg;
                    if (reader == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error("Failed to parse config", (Throwable)e);
                    }
                }
                reader.close();
            }
            return config;
        }
        if (cfg == null) {
            cfg = new Config();
        }
        CombatConfig.save(file, cfg);
        return cfg;
    }

    public static void save(File file, Config cfg) {
        try (JsonWriter writer = JsonWriter.json5((Path)file.toPath());){
            writer.beginObject();
            writer.comment("The amount of time in seconds a player should be in combat").name("combatTime").value((Number)Config.combatTime);
            writer.comment("Weather a player should be put in combat from just other players or all damage(true is all damage false is just players)").name("allDamage").value(Config.allDamage);
            writer.comment("The death message that shows when a player disconnects while in combat, note that not having a space at the beginning will attach the message to the players name").name("deathMessage").value(Config.deathMessage);
            writer.endObject();
        }
        catch (IOException e) {
            log.error("Failed to save config", (Throwable)e);
        }
    }

    static {
        file = new File("./config/combatlog-common.json5");
        log = LogManager.getLogger((String)"CombatLog");
    }

    public static class Config {
        public static Integer combatTime = 30;
        public static boolean allDamage = false;
        public static String deathMessage = " has died of cowardice";
    }
}

