/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ageingspawners.config;

import com.mrbysco.ageingspawners.AgeingSpawners;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SpawnerConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        AgeingSpawners.LOGGER.debug("Loaded Ageing Spawners' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        AgeingSpawners.LOGGER.warn("Ageing Spawners' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.EnumValue<EnumAgeingMode> spawnerMode;
        public final ForgeConfigSpec.BooleanValue playerPlacedOnly;
        public final ForgeConfigSpec.IntValue whitelistMaxSpawnCount;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ForgeConfigSpec.IntValue blacklistMaxSpawnCount;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.spawnerMode = builder.comment("Decides whether the spawner is on blacklist, whitelist-only or player_placed mode [Default: WHITELIST]").defineEnum("spawnerMode", (Enum)EnumAgeingMode.WHITELIST);
            this.playerPlacedOnly = builder.comment("Decides whether only player placed spawners age [Default: false]").define("playerPlacedOnly", false);
            builder.pop();
            builder.comment("Whitelist settings").push("Whitelist");
            this.whitelistMaxSpawnCount = builder.comment("Decides default spawnCount of spawns a spawner can have in WHITELIST mode unless specified [Default: 20]").defineInRange("whitelistMaxSpawnCount", 20, 1, Integer.MAX_VALUE);
            this.whitelist = builder.comment(new String[]{"Decides which mobs age a spawner (requires spawnerMode to be set to WHITELIST)", "[syntax: 'modid:entity;times' or 'modid:entity' ]", "[example: 'minecraft:pig;5' ]"}).defineListAllowEmpty(Collections.singletonList("whitelist"), () -> Collections.singletonList(""), o -> o instanceof String);
            builder.pop();
            builder.comment("Blacklist settings").push("Blacklist");
            this.blacklistMaxSpawnCount = builder.comment("Decides the spawnCount of spawns a spawner can have in BLACKLIST mode [Default: 20]").defineInRange("blacklistMaxSpawnCount", 20, 1, Integer.MAX_VALUE);
            this.blacklist = builder.comment("Decides which mobs don't age a spawner (requires spawnerMode to be set to BLACKLIST) \n[syntax: 'modid:entity']").defineListAllowEmpty(Collections.singletonList("blacklist"), () -> Collections.singletonList(""), o -> o instanceof String);
            builder.pop();
        }
    }

    public static enum EnumAgeingMode {
        BLACKLIST,
        WHITELIST;

    }
}

