/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ageingspawners.handler;

import com.mrbysco.ageingspawners.AgeingSpawners;
import com.mrbysco.ageingspawners.config.SpawnerConfig;
import com.mrbysco.ageingspawners.util.AgeingHelper;
import com.mrbysco.ageingspawners.util.AgeingWorldData;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class AgeHandler {
    @SubscribeEvent
    public void SpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        ServerLevel serverLevel;
        if (!event.getLevel().m_5776_() && event.getSpawner() != null && (serverLevel = event.getLevel().m_6018_()).m_46469_().m_46207_(AgeingSpawners.AGE_SPAWNERS_RULE)) {
            AgeHandler.handleSpawner((Level)serverLevel, event.getSpawner(), (Entity)event.getEntity());
        }
    }

    public static void handleSpawner(Level level, BaseSpawner spawner, Entity entity) {
        ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        switch ((SpawnerConfig.EnumAgeingMode)((Object)SpawnerConfig.COMMON.spawnerMode.get())) {
            case BLACKLIST: {
                AgeHandler.handleBlacklist(level, spawner, registryName);
                break;
            }
            case WHITELIST: {
                AgeHandler.handleWhitelist(level, spawner, registryName);
            }
        }
    }

    private static void handleBlacklist(Level level, BaseSpawner spawner, ResourceLocation registryName) {
        if (!AgeingHelper.blacklistContains(registryName)) {
            AgeHandler.ageTheSpawner(level, spawner, (Integer)SpawnerConfig.COMMON.blacklistMaxSpawnCount.get());
        } else if (spawner.getSpawnerBlockEntity() != null) {
            BlockPos pos = spawner.getSpawnerBlockEntity().m_58899_();
            ResourceLocation dimensionLocation = level.m_46472_().m_135782_();
            AgeingWorldData worldData = AgeingWorldData.get(level);
            Map<BlockPos, AgeingWorldData.SpawnerInfo> locationMap = worldData.getMapFromWorld(dimensionLocation);
            locationMap.remove(pos);
            worldData.setMapForWorld(dimensionLocation, locationMap);
            worldData.m_77762_();
        }
    }

    private static void handleWhitelist(Level level, BaseSpawner spawner, ResourceLocation registryName) {
        if (AgeingHelper.whitelistContains(registryName)) {
            int maxSpawnCount = AgeingHelper.getMaxSpawnCount(registryName);
            AgeHandler.ageTheSpawner(level, spawner, maxSpawnCount);
        } else if (spawner.getSpawnerBlockEntity() != null) {
            BlockPos pos = spawner.getSpawnerBlockEntity().m_58899_();
            ResourceLocation dimensionLocation = level.m_46472_().m_135782_();
            AgeingWorldData worldData = AgeingWorldData.get(level);
            Map<BlockPos, AgeingWorldData.SpawnerInfo> locationMap = worldData.getMapFromWorld(dimensionLocation);
            locationMap.remove(pos);
            worldData.setMapForWorld(dimensionLocation, locationMap);
            worldData.m_77762_();
        }
    }

    private static void ageTheSpawner(Level level, BaseSpawner spawner, int maxCount) {
        if (spawner.getSpawnerBlockEntity() != null) {
            BlockPos pos = spawner.getSpawnerBlockEntity().m_58899_();
            ResourceLocation dimensionLocation = level.m_46472_().m_135782_();
            AgeingWorldData worldData = AgeingWorldData.get(level);
            Map<BlockPos, AgeingWorldData.SpawnerInfo> locationMap = worldData.getMapFromWorld(dimensionLocation);
            if (level.m_7702_(pos) != null && level.m_7702_(pos) instanceof SpawnerBlockEntity) {
                AgeingWorldData.SpawnerInfo info = locationMap.getOrDefault(pos, new AgeingWorldData.SpawnerInfo(0, false));
                boolean playerPlaced = info.playerPlaced();
                boolean flag = (Boolean)SpawnerConfig.COMMON.playerPlacedOnly.get();
                if (!flag || flag && playerPlaced) {
                    int spawnCount = info.spawnCount();
                    if (++spawnCount >= maxCount) {
                        level.m_7471_(pos, false);
                        locationMap.remove(pos);
                    } else {
                        locationMap.put(pos, new AgeingWorldData.SpawnerInfo(spawnCount, playerPlaced));
                    }
                    worldData.setMapForWorld(dimensionLocation, locationMap);
                    worldData.m_77762_();
                }
            }
        }
    }

    @SubscribeEvent
    public void placeEvent(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor;
        if (!event.getLevel().m_5776_() && (levelAccessor = event.getLevel()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)levelAccessor;
            if (event.getPlacedBlock().m_60713_(Blocks.f_50085_) && event.getEntity() instanceof Player) {
                BlockPos pos = event.getPos();
                ServerLevel serverLevel = serverLevelAccessor.m_6018_();
                ResourceLocation dimensionLocation = serverLevel.m_46472_().m_135782_();
                AgeingWorldData worldData = AgeingWorldData.get((Level)serverLevel);
                Map<BlockPos, AgeingWorldData.SpawnerInfo> locationMap = worldData.getMapFromWorld(dimensionLocation);
                AgeingWorldData.SpawnerInfo info = locationMap.getOrDefault(pos, new AgeingWorldData.SpawnerInfo(0, true));
                locationMap.put(pos, info);
                worldData.setMapForWorld(dimensionLocation, locationMap);
                worldData.m_77762_();
            }
        }
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor;
        if (!event.getLevel().m_5776_() && (levelAccessor = event.getLevel()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)levelAccessor;
            BlockPos pos = event.getPos();
            ServerLevel serverLevel = serverLevelAccessor.m_6018_();
            ResourceLocation dimensionLocation = serverLevel.m_46472_().m_135782_();
            AgeingWorldData worldData = AgeingWorldData.get((Level)serverLevel);
            Map<BlockPos, AgeingWorldData.SpawnerInfo> locationMap = worldData.getMapFromWorld(dimensionLocation);
            locationMap.remove(pos);
            worldData.setMapForWorld(dimensionLocation, locationMap);
            worldData.m_77762_();
        }
    }
}

