/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ageingspawners.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class AgeingWorldData
extends SavedData {
    private static final String DATA_NAME = "ageingspawners_world_data";
    private final Map<ResourceLocation, Map<BlockPos, SpawnerInfo>> worldSpawnerMap = new HashMap<ResourceLocation, Map<BlockPos, SpawnerInfo>>();

    public AgeingWorldData(Map<ResourceLocation, Map<BlockPos, SpawnerInfo>> map) {
        if (!map.isEmpty()) {
            this.worldSpawnerMap.clear();
            this.worldSpawnerMap.putAll(map);
        }
    }

    public AgeingWorldData() {
        this(new HashMap<ResourceLocation, Map<BlockPos, SpawnerInfo>>());
    }

    public static AgeingWorldData load(CompoundTag compound) {
        HashMap<ResourceLocation, Map<BlockPos, SpawnerInfo>> map = new HashMap<ResourceLocation, Map<BlockPos, SpawnerInfo>>();
        for (String nbtName : compound.m_128431_()) {
            Tag nbt;
            ListTag dimensionNBTList = new ListTag();
            if (compound.m_128435_(nbtName) == 9 && (nbt = compound.m_128423_(nbtName)) instanceof ListTag) {
                ListTag listNBT = (ListTag)nbt;
                if (!listNBT.isEmpty() && listNBT.m_7264_() != 10) continue;
                dimensionNBTList = listNBT;
            }
            if (dimensionNBTList.isEmpty()) continue;
            HashMap<BlockPos, SpawnerInfo> posMap = new HashMap<BlockPos, SpawnerInfo>();
            for (int i = 0; i < dimensionNBTList.size(); ++i) {
                CompoundTag tag = dimensionNBTList.m_128728_(i);
                if (!tag.m_128441_("BlockPos") || !tag.m_128441_("Amount")) continue;
                BlockPos blockPos = BlockPos.m_122022_((long)tag.m_128454_("BlockPos"));
                int amount = tag.m_128451_("Amount");
                boolean playerPlaced = tag.m_128471_("PlayerPlaced");
                posMap.put(blockPos, new SpawnerInfo(amount, playerPlaced));
            }
            map.put(new ResourceLocation(nbtName), posMap);
        }
        return new AgeingWorldData(map);
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        for (Map.Entry<ResourceLocation, Map<BlockPos, SpawnerInfo>> dimensionEntry : this.worldSpawnerMap.entrySet()) {
            ResourceLocation dimensionLocation = dimensionEntry.getKey();
            Map<BlockPos, SpawnerInfo> savedPositions = dimensionEntry.getValue();
            ListTag dimensionStorage = new ListTag();
            for (Map.Entry<BlockPos, SpawnerInfo> entry : savedPositions.entrySet()) {
                SpawnerInfo info = entry.getValue();
                CompoundTag positionTag = new CompoundTag();
                positionTag.m_128356_("BlockPos", entry.getKey().m_121878_());
                positionTag.m_128405_("Amount", info.spawnCount().intValue());
                positionTag.m_128379_("PlayerPlaced", info.playerPlaced());
                dimensionStorage.add((Object)positionTag);
            }
            compound.m_128365_(dimensionLocation.toString(), (Tag)dimensionStorage);
        }
        return compound;
    }

    public Map<BlockPos, SpawnerInfo> getMapFromWorld(ResourceLocation dimensionLocation) {
        return this.worldSpawnerMap.getOrDefault(dimensionLocation, new HashMap());
    }

    public void setMapForWorld(ResourceLocation dimensionLocation, Map<BlockPos, SpawnerInfo> spawnerInfoList) {
        this.worldSpawnerMap.put(dimensionLocation, spawnerInfoList);
    }

    public static AgeingWorldData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = level.m_7654_().m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (AgeingWorldData)storage.m_164861_(AgeingWorldData::load, AgeingWorldData::new, DATA_NAME);
    }

    public record SpawnerInfo(Integer spawnCount, boolean playerPlaced) {
    }
}

