/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBlocks;
import dev.orderedchaos.projectvibrantjourneys.util.LevelUtils;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class IcicleFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int MAX_LENGTH = 4;

    public IcicleFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random;
        BlockPos origin;
        WorldGenLevel level = context.m_159774_();
        int height = this.checkVerticalSpace((LevelAccessor)level, origin = context.m_159777_(), (random = context.m_225041_()).m_188503_(4) + 1);
        if (height == 0) {
            return false;
        }
        this.growIcicle((LevelAccessor)level, origin, Direction.DOWN, height);
        return true;
    }

    private int checkVerticalSpace(LevelAccessor level, BlockPos pos, int height) {
        int temp;
        Direction dir = Direction.DOWN;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (temp = 0; temp < height && level.m_46859_((BlockPos)mutable); ++temp) {
            mutable.m_122173_(dir);
        }
        return Math.min(temp, 4);
    }

    private void buildBaseToTipColumn(Direction dir, int height, Consumer<BlockState> consumer) {
        if (height >= 3) {
            consumer.accept(this.createIcicle(dir, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                consumer.accept(this.createIcicle(dir, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            consumer.accept(this.createIcicle(dir, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            consumer.accept(this.createIcicle(dir, DripstoneThickness.TIP));
        }
    }

    private void growIcicle(LevelAccessor level, BlockPos pos, Direction dir, int height) {
        if (level.m_8055_(pos.m_121945_(dir.m_122424_())).m_60838_((BlockGetter)level, pos.m_121945_(dir.m_122424_()))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
            this.buildBaseToTipColumn(dir, height, state -> {
                LevelUtils.setBlock(level, (BlockPos)blockpos$mutableblockpos, state, 2);
                blockpos$mutableblockpos.m_122173_(dir);
            });
        }
    }

    private BlockState createIcicle(Direction dir, DripstoneThickness thickness) {
        return (BlockState)((BlockState)((Block)PVJBlocks.ICICLE.get()).m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)dir)).m_61124_((Property)PointedDripstoneBlock.f_154010_, (Comparable)thickness);
    }
}

