/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.util;

import dev.orderedchaos.projectvibrantjourneys.core.ProjectVibrantJourneys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class LevelUtils {
    public static boolean setBlock(LevelAccessor level, BlockPos position, BlockState blockState, int parameter) {
        if (!LevelUtils.isValid(level, position, blockState)) {
            return false;
        }
        return level.m_7731_(position, blockState, parameter);
    }

    public static boolean setBlockAndUpdate(LevelAccessor level, BlockPos position, BlockState blockState) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_46597_(position, blockState);
        }
        return false;
    }

    private static boolean isValid(LevelAccessor level, BlockPos position, BlockState blockState) {
        boolean respectsCutoff = LevelUtils.respectsCutoff(level, position, blockState);
        if (!respectsCutoff) {
            ProjectVibrantJourneys.LOGGER.debug("Skipped placing feature (" + blockState.m_60734_().m_7705_() + ") [respectsCutoff: " + respectsCutoff + "]");
        }
        return respectsCutoff;
    }

    private static boolean respectsCutoff(LevelAccessor level, BlockPos position, BlockState blockState) {
        if (level instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)level;
            int x = SectionPos.m_123171_((int)position.m_123341_());
            int z = SectionPos.m_123171_((int)position.m_123343_());
            ChunkPos chunkpos = region.m_143488_();
            int xResult = Math.abs(chunkpos.f_45578_ - x);
            int zResult = Math.abs(chunkpos.f_45579_ - z);
            return xResult <= region.f_143481_ && zResult <= region.f_143481_;
        }
        return false;
    }
}

