/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Difficulty;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.smileycorp.atlas.api.util.TextUtils;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.capability.ZombifyPlayer;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.common.event.SpawnZombiePlayerEvent;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.config.ZombiePlayersConfig;
import net.smileycorp.hordes.infection.HordesInfection;

@Mod.EventBusSubscriber(modid="hordes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEventHandler {
    @SubscribeEvent
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (HordesLogger.hasErrors()) {
            event.getEntity().m_213846_((Component)TextUtils.translatableComponent((String)"message.hordes.DataError", null, (Object[])new Object[]{HordesLogger.getFiletext()}));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player) || entity instanceof FakePlayer || entity.m_9236_().f_46443_ || entity.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        if (entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && ((Boolean)InfectionConfig.infectionSpawnsZombiePlayers.get()).booleanValue() && ((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue() || ((Boolean)ZombiePlayersConfig.zombieGraves.get()).booleanValue()) {
            LazyOptional optional = entity.getCapability(HordesCapabilities.ZOMBIFY_PLAYER, null);
            if (!optional.isPresent()) {
                return;
            }
            ((ZombifyPlayer)optional.orElseGet(null)).createZombie((Player)entity);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onDrop(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof Player) || event.getEntity() instanceof FakePlayer || event.getEntity().m_9236_().f_46443_ || event.getEntity().m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && ((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue() || ((Boolean)ZombiePlayersConfig.zombieGraves.get()).booleanValue()) {
            LazyOptional optional = player.getCapability(HordesCapabilities.ZOMBIFY_PLAYER, null);
            if (!optional.isPresent()) {
                return;
            }
            ZombifyPlayer cap = (ZombifyPlayer)optional.orElseGet(null);
            PlayerZombie zombie = cap.getZombie();
            if (zombie == null) {
                return;
            }
            if (((Boolean)ZombiePlayersConfig.zombiePlayersStoreItems.get()).booleanValue()) {
                Collection drops = event.getDrops();
                zombie.storeDrops(drops);
                drops.clear();
                event.setCanceled(true);
            }
            zombie.asEntity().m_21530_();
            player.m_9236_().m_7967_(zombie.asEntity());
            cap.clearZombie();
            player.m_21195_((MobEffect)HordesInfection.INFECTED.get());
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player & !(entity instanceof FakePlayer)) {
            event.addCapability(Constants.loc("Zombify"), (ICapabilityProvider)new ZombifyPlayer.Provider());
        }
    }

    @SubscribeEvent
    public void entityConvert(LivingConversionEvent.Post event) {
        LivingEntity before = event.getEntity();
        if (before.m_9236_().f_46443_) {
            return;
        }
        LivingEntity after = event.getOutcome();
        if (before instanceof AbstractHorse && after instanceof AbstractHorse) {
            SimpleContainer beforeInv = ((AbstractHorse)before).f_30520_;
            SimpleContainer afterInv = ((AbstractHorse)after).f_30520_;
            for (int i = 0; i < Math.min(beforeInv.m_6643_(), afterInv.m_6643_()); ++i) {
                afterInv.m_6836_(i, beforeInv.m_8020_(i).m_41777_());
            }
        }
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HordesEntities.ZOMBIE_PLAYER.get(), Zombie.m_34328_().m_22265_());
        event.put((EntityType)HordesEntities.DROWNED_PLAYER.get(), Drowned.m_34328_().m_22265_());
        event.put((EntityType)HordesEntities.HUSK_PLAYER.get(), Husk.m_34328_().m_22265_());
    }

    @SubscribeEvent(receiveCanceled=true)
    public void spawnZombiePlayer(SpawnZombiePlayerEvent event) {
        Player player = event.getEntity();
        if (player.m_5842_() && ((Boolean)ZombiePlayersConfig.drownedPlayers.get()).booleanValue()) {
            event.setEntityType((EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.DROWNED_PLAYER.get()));
            return;
        }
        if (player.m_9236_().m_204166_(player.m_20183_()).m_203656_(HordesEntities.HUSK_PLAYER_SPAWN_BIOMES) && ((Boolean)ZombiePlayersConfig.huskPlayers.get()).booleanValue()) {
            event.setEntityType((EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.HUSK_PLAYER.get()));
        }
    }
}

