/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.entities;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.TextUtils;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.config.ZombiePlayersConfig;

public class ZombiePlayer
extends Zombie
implements PlayerZombie<ZombiePlayer> {
    protected static final EntityDataAccessor<Optional<UUID>> PLAYER = SynchedEntityData.m_135353_(ZombiePlayer.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> SHOW_CAPE = SynchedEntityData.m_135353_(ZombiePlayer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected NonNullList<ItemStack> playerItems = NonNullList.m_122779_();
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;

    public ZombiePlayer(EntityType<? extends ZombiePlayer> type, Level level) {
        super(type, level);
    }

    public ZombiePlayer(Level level) {
        this((EntityType<? extends ZombiePlayer>)((EntityType)HordesEntities.ZOMBIE_PLAYER.get()), level);
    }

    public ZombiePlayer(Player player) {
        this(player.m_9236_());
        this.setPlayer(player);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLAYER, Optional.empty());
        this.f_19804_.m_135372_(SHOW_CAPE, (Object)true);
    }

    @Override
    public void setPlayer(Player player) {
        if (player == null) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = slot.m_20743_() == EquipmentSlot.Type.ARMOR ? (ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_()) : (slot == EquipmentSlot.MAINHAND ? player.m_21205_() : player.m_21206_());
            this.m_8061_(slot, stack);
        }
        this.setPlayer(player.m_36316_());
    }

    @Override
    public void setPlayer(String username) {
        Optional optional = ServerLifecycleHooks.getCurrentServer().m_129927_().m_10996_(username);
        if (optional.isPresent()) {
            this.setPlayer((GameProfile)optional.get());
        }
    }

    @Override
    public void setPlayer(UUID uuid) {
        Optional optional = ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(uuid);
        if (optional.isPresent()) {
            this.setPlayer((GameProfile)optional.get());
        }
    }

    @Override
    public void setPlayer(GameProfile profile) {
        if (profile == null) {
            return;
        }
        if (profile.getName() != null) {
            this.m_6593_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(profile.getName())));
        }
        this.f_19804_.m_135381_(PLAYER, Optional.of(profile.getId()));
    }

    @Override
    public Optional<UUID> getPlayerUUID() {
        return (Optional)this.f_19804_.m_135370_(PLAYER);
    }

    @Override
    public void storeDrops(Collection<ItemEntity> list) {
        this.playerItems.clear();
        for (ItemEntity item : list) {
            ItemStack stack = item.m_32055_();
            item.m_142687_(Entity.RemovalReason.DISCARDED);
            if (stack == null) continue;
            this.playerItems.add((Object)stack.m_41777_());
        }
    }

    @Override
    public void setInventory(NonNullList<ItemStack> list) {
        this.playerItems.clear();
        this.playerItems.addAll(list);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.playerItems;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        for (ItemStack stack : this.playerItems) {
            if (stack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)stack)) continue;
            this.m_5552_(stack, 0.0f);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED) {
            this.m_7472_(null, 0, false);
        }
        super.m_142687_(reason);
    }

    protected void m_7595_() {
        if (((Boolean)ZombiePlayersConfig.drownedPlayers.get()).booleanValue()) {
            Zombie drowned = (Zombie)this.m_21406_((EntityType)HordesEntities.DROWNED_PLAYER.get(), true);
            if (drowned != null) {
                drowned.m_34339_(drowned.m_9236_().m_6436_(drowned.m_20183_()).m_19057_());
                drowned.m_34336_(drowned.m_7586_() && this.m_34330_());
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)drowned);
                if (drowned instanceof PlayerZombie) {
                    ((PlayerZombie)drowned).copyFrom(this);
                }
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_5898_(null, 1040, this.m_20183_(), 0);
            }
        }
    }

    public boolean m_5884_() {
        return (Boolean)ZombiePlayersConfig.zombiePlayersBurn.get();
    }

    public boolean m_5825_() {
        return (Boolean)ZombiePlayersConfig.zombiePlayersFireImmune.get();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        Optional optional = (Optional)this.f_19804_.m_135370_(PLAYER);
        if (optional.isPresent()) {
            compound.m_128362_("player", (UUID)optional.get());
        }
        ContainerHelper.m_18973_((CompoundTag)compound, this.playerItems);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("player")) {
            this.f_19804_.m_135381_(PLAYER, Optional.of(compound.m_128342_("player")));
        }
        NonNullList read = NonNullList.m_122780_((int)compound.m_128437_("Items", 10).size(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)read);
        this.playerItems = read;
    }

    public MutableComponent getDisplayName() {
        MutableComponent textcomponentstring = PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)TextUtils.translatableComponent((String)"entity.hordes.ZombiePlayer.chat", (String)"Zombie Player", (Object[])new Object[]{this.m_7770_()}));
        textcomponentstring.m_7383_().m_131144_(this.m_20190_());
        textcomponentstring.m_7383_().m_131138_(this.m_20078_());
        return textcomponentstring;
    }

    @Override
    public void copyFrom(PlayerZombie entity) {
        Optional<UUID> optional = entity.getPlayerUUID();
        if (optional.isPresent()) {
            this.setPlayer(optional.get());
        }
        this.setInventory(entity.getInventory());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = ((Mob)entity).m_6844_(slot);
            this.m_8061_(slot, stack);
        }
        this.f_19804_.m_135381_(SHOW_CAPE, (Object)entity.displayCape());
    }

    public void m_8119_() {
        super.m_8119_();
        this.moveCloak(this);
    }

    public void m_6043_() {
        if (this.playerItems.isEmpty() | (Boolean)ZombiePlayersConfig.zombiePlayersDespawnPeaceful.get() == false) {
            super.m_6043_();
        }
    }

    @Override
    public void setDisplayCape(boolean display) {
        this.f_19804_.m_135381_(SHOW_CAPE, (Object)display);
    }

    @Override
    public boolean displayCape() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_CAPE);
    }

    @Override
    public double getXCloakO() {
        return this.xCloakO;
    }

    @Override
    public double getYCloakO() {
        return this.yCloakO;
    }

    @Override
    public double getZCloakO() {
        return this.zCloakO;
    }

    @Override
    public double getXCloak() {
        return this.xCloak;
    }

    @Override
    public double getYCloak() {
        return this.yCloak;
    }

    @Override
    public double getZCloak() {
        return this.zCloak;
    }

    @Override
    public void setXCloakO(double value) {
        this.xCloakO = value;
    }

    @Override
    public void setYCloakO(double value) {
        this.yCloakO = value;
    }

    @Override
    public void setZCloakO(double value) {
        this.zCloakO = value;
    }

    @Override
    public void setXCloak(double value) {
        this.xCloak = value;
    }

    @Override
    public void setYCloak(double value) {
        this.yCloak = value;
    }

    @Override
    public void setZCloak(double value) {
        this.zCloak = value;
    }
}

