/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.TextUtils;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeEventClient;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import net.smileycorp.hordes.hordeevent.data.HordeScriptLoader;
import net.smileycorp.hordes.hordeevent.data.HordeTableLoader;

public class HordeEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Mob) {
            event.addCapability(Constants.loc("HordeSpawn"), (ICapabilityProvider)new HordeSpawn.Provider());
        }
        if (entity instanceof Player && entity.m_9236_().f_46443_) {
            event.addCapability(Constants.loc("HordeEventClient"), (ICapabilityProvider)new HordeEventClient.Provider());
        }
    }

    @SubscribeEvent
    public void addResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)HordeTableLoader.INSTANCE);
        event.addListener((PreparableReloadListener)HordeScriptLoader.INSTANCE);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        HordeSavedData data;
        if (event.phase != TickEvent.Phase.START || ((Boolean)HordeEventConfig.hordesCommandOnly.get()).booleanValue()) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerLevel level = server.m_129783_();
        if (((Boolean)HordeEventConfig.pauseEventServer.get()).booleanValue() && level.m_6907_().isEmpty()) {
            return;
        }
        int day = (int)Math.floor(level.m_46468_() / (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        if (day >= (data = HordeSavedData.getData(level)).getNextDay()) {
            data.setNextDay(level.f_46441_.m_188503_((Integer)HordeEventConfig.hordeSpawnVariation.get() + 1) + (Integer)HordeEventConfig.hordeSpawnDays.get() + data.getNextDay());
        }
        data.save();
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !(event.player instanceof ServerPlayer) || event.player instanceof FakePlayer) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129783_();
        if (((Boolean)HordeEventConfig.pauseEventServer.get()).booleanValue() && level.m_6907_().isEmpty()) {
            return;
        }
        HordeEvent horde = HordeSavedData.getData(level).getEvent(player);
        if (horde == null) {
            return;
        }
        int time = Math.round(level.m_46468_() % (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        int day = horde.getCurrentDay(player);
        if (!horde.hasSynced(day)) {
            horde.sync(player, day);
        }
        if (horde.isActive(player)) {
            horde.update(player);
            return;
        }
        if (time >= (Integer)HordeEventConfig.hordeStartTime.get() && time <= (Integer)HordeEventConfig.hordeStartTime.get() + (Integer)HordeEventConfig.hordeStartBuffer.get() && day >= horde.getNextDay() && (day > 0 || ((Boolean)HordeEventConfig.spawnFirstDay.get()).booleanValue())) {
            horde.tryStartEvent(player, -1, false);
        }
    }

    @SubscribeEvent
    public void logIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        HordeEvent horde;
        if (event.getEntity() instanceof ServerPlayer && (horde = HordeSavedData.getData((player = (ServerPlayer)event.getEntity()).m_284548_()).getEvent(player)) != null) {
            horde.setPlayer(player);
        }
    }

    @SubscribeEvent
    public void tryDespawn(MobSpawnEvent.AllowDespawn event) {
        ServerPlayer player = HordeSpawn.getHordePlayer((Entity)event.getEntity());
        if (player == null) {
            return;
        }
        HordeEvent horde = HordeSavedData.getData((ServerLevel)player.m_9236_()).getEvent(player);
        if (horde != null && horde.isActive(player)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void update(LivingEvent.LivingTickEvent event) {
        HordeEvent horde;
        ServerPlayer player = HordeSpawn.getHordePlayer((Entity)event.getEntity());
        if (player == null) {
            return;
        }
        HordeSpawn cap = (HordeSpawn)event.getEntity().getCapability(HordesCapabilities.HORDESPAWN).orElseGet(null);
        if (cap.isSynced()) {
            return;
        }
        Mob entity = (Mob)event.getEntity();
        entity.f_21346_.m_25386_().forEach(WrappedGoal::m_8041_);
        if (entity instanceof PathfinderMob) {
            entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
        }
        if (!(entity instanceof ZombifiedPiglin) || !((Boolean)CommonConfigHandler.aggressiveZombiePiglins.get()).booleanValue()) {
            entity.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(entity, Player.class, true));
        }
        if ((horde = HordeSavedData.getData((ServerLevel)player.m_9236_()).getEvent(player)) != null && horde.isActive(player)) {
            horde.registerEntity(entity, player);
        }
        cap.setSynced();
    }

    @SubscribeEvent
    public void trySleep(PlayerSleepInBedEvent event) {
        if (((Boolean)HordeEventConfig.canSleepDuringHorde.get()).booleanValue() || !(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerLevel level = player.m_284548_();
        HordeEvent horde = HordeSavedData.getData((ServerLevel)player.m_9236_()).getEvent(player);
        if (horde == null) {
            return;
        }
        if (level.m_46461_() | (!level.m_6042_().f_63862_() || !horde.isHordeDay(player) && !horde.isActive(player))) {
            return;
        }
        event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        player.m_5661_((Component)TextUtils.translatableComponent((String)"message.hordes.TrySleep", (String)"Can't sleep now, a horde is approaching", (Object[])new Object[0]), true);
    }
}

