/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordeBuildSpawnDataEvent;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.hordeevent.data.functions.HordeFunction;
import net.smileycorp.hordes.hordeevent.data.functions.MultipleFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetEndMessageFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetEntitySpeedFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnAmountFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnDurationFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnIntervalFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnSoundFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnTypeFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawntableFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetStartMessageFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityLootTableFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityNBTFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityTypeFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityXFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityYFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityZFunction;

public class FunctionRegistry {
    private static Map<ResourceLocation, Pair<Class<? extends HordePlayerEvent>, Function<JsonElement, HordeFunction<? extends HordePlayerEvent>>>> DESERIALIZERS = Maps.newHashMap();

    public static void registerFunctionSerializers() {
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_spawntable"), HordeBuildSpawnDataEvent.class, SetSpawntableFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_type"), HordeBuildSpawnDataEvent.class, SetSpawnTypeFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_sound"), HordeBuildSpawnDataEvent.class, SetSpawnSoundFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_start_message"), HordeBuildSpawnDataEvent.class, SetStartMessageFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_end_message"), HordeBuildSpawnDataEvent.class, SetEndMessageFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_duration"), HordeBuildSpawnDataEvent.class, SetSpawnDurationFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_interval"), HordeBuildSpawnDataEvent.class, SetSpawnIntervalFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_amount"), HordeBuildSpawnDataEvent.class, SetSpawnAmountFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_entity_speed"), HordeBuildSpawnDataEvent.class, SetEntitySpeedFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_entity_type"), HordeSpawnEntityEvent.class, SetEntityTypeFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_entity_nbt"), HordeSpawnEntityEvent.class, SetEntityNBTFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_entity_x"), HordeSpawnEntityEvent.class, SetEntityXFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_entity_y"), HordeSpawnEntityEvent.class, SetEntityYFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_entity_z"), HordeSpawnEntityEvent.class, SetEntityZFunction::deserialize);
        FunctionRegistry.registerFunctionDeserializer(Constants.loc("set_entity_loot_table"), HordeSpawnEntityEvent.class, SetEntityLootTableFunction::deserialize);
    }

    public static <T extends HordePlayerEvent> Pair<Class<T>, HordeFunction<T>> readFunction(JsonObject json) {
        if (!json.has("function") || !json.has("value")) {
            return Pair.of(null, null);
        }
        if (json.get("function").getAsString().equals("hordes:multiple")) {
            return MultipleFunction.deserialize(json.get("value").getAsJsonArray());
        }
        try {
            ResourceLocation loc = new ResourceLocation(json.get("function").getAsString());
            Pair<Class<? extends HordePlayerEvent>, Function<JsonElement, HordeFunction<? extends HordePlayerEvent>>> pair = DESERIALIZERS.get(loc);
            if (pair == null) {
                throw new NullPointerException("function " + loc + " is not registered");
            }
            return Pair.of((Object)((Class)pair.getFirst()), (Object)((HordeFunction)((Function)pair.getSecond()).apply(json.get("value"))));
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to read function " + json, e);
            return Pair.of(null, null);
        }
    }

    public static <T extends HordePlayerEvent> void registerFunctionDeserializer(ResourceLocation name, Class<T> clazz, Function<JsonElement, HordeFunction<T>> serializer) {
        DESERIALIZERS.put(name, (Pair<Class<? extends HordePlayerEvent>, Function<JsonElement, HordeFunction<? extends HordePlayerEvent>>>)new Pair(clazz, serializer));
    }
}

