/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.event.InfectionDeathEvent;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.InfectedEffect;
import net.smileycorp.hordes.infection.capability.Infection;
import net.smileycorp.hordes.infection.data.InfectionDataLoader;
import net.smileycorp.hordes.infection.network.CureEntityMessage;
import net.smileycorp.hordes.infection.network.InfectMessage;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;

public class InfectionEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player && !(entity instanceof FakePlayer) || entity instanceof Villager || InfectionDataLoader.INSTANCE.canBeInfected(entity)) {
            event.addCapability(Constants.loc("InfectionCounter"), (ICapabilityProvider)new Infection.Provider());
        }
    }

    @SubscribeEvent
    public void addResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)InfectionDataLoader.INSTANCE);
    }

    @SubscribeEvent
    public void onEntityAdded(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob) || !((Boolean)InfectionConfig.infectionEntitiesAggroConversions.get()).booleanValue() || entity.m_9236_().f_46443_) {
            return;
        }
        if (HordesInfection.canCauseInfection((LivingEntity)entity)) {
            ((Mob)entity).f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)entity, LivingEntity.class, 10, true, false, InfectionDataLoader.INSTANCE::canBeInfected));
        }
    }

    @SubscribeEvent
    public void logIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            InfectionDataLoader.INSTANCE.syncData(((ServerPlayer)event.getEntity()).f_8906_.f_9742_);
        }
    }

    @SubscribeEvent
    public void onItemStackConsume(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack;
        LivingEntity entity = event.getEntity();
        if (InfectionDataLoader.INSTANCE.applyImmunity(entity, (stack = event.getItem()).m_41720_())) {
            return;
        }
        if (!entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) || !HordesInfection.isCure(stack)) {
            return;
        }
        LazyOptional optional = entity.getCapability(HordesCapabilities.INFECTION);
        if (optional.isPresent()) {
            ((Infection)optional.orElseGet(null)).increaseInfection();
        }
        if (!entity.m_21195_((MobEffect)HordesInfection.INFECTED.get())) {
            return;
        }
        if (entity.m_9236_().f_46443_) {
            return;
        }
        InfectionPacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> entity.m_9236_().m_46745_(entity.m_20097_())), new CureEntityMessage(entity));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        HitResult ray = DirectionUtils.getEntityRayTrace((Level)event.getLevel(), (Entity)event.getEntity(), (float)5.0f);
        if (!(ray instanceof EntityHitResult)) {
            return;
        }
        if (!(((EntityHitResult)ray).m_82443_() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)((EntityHitResult)ray).m_82443_();
        if (entity instanceof Player | (!entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && !HordesInfection.isCure(stack))) {
            return;
        }
        entity.m_21195_((MobEffect)HordesInfection.INFECTED.get());
        LazyOptional optional = entity.getCapability(HordesCapabilities.INFECTION);
        if (optional.isPresent()) {
            ((Infection)optional.orElseGet(null)).increaseInfection();
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.FAIL);
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        Level level = entity.m_9236_();
        if (level.f_46443_ | (!(entity instanceof LivingEntity) || !(attacker instanceof LivingEntity))) {
            return;
        }
        if (!HordesInfection.canCauseInfection((LivingEntity)attacker) || entity.m_21023_((MobEffect)HordesInfection.INFECTED.get())) {
            return;
        }
        if (InfectionDataLoader.INSTANCE.canBeInfected((Entity)entity)) {
            InfectionDataLoader.INSTANCE.tryToInfect(entity, (LivingEntity)attacker, event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Level level = entity.m_9236_();
        if (level.f_46443_ || !source.m_276093_(HordesInfection.INFECTION_DAMAGE) && !entity.m_21023_((MobEffect)HordesInfection.INFECTED.get())) {
            return;
        }
        InfectionDeathEvent newevent = new InfectionDeathEvent(entity, event.getSource());
        MinecraftForge.EVENT_BUS.post((Event)newevent);
        if (newevent.getResult() == Event.Result.DENY) {
            event.setCanceled(true);
            if (!(entity instanceof OwnableEntity)) {
                return;
            }
            LivingEntity owner = ((OwnableEntity)entity).m_269323_();
            if (!(owner instanceof ServerPlayer)) {
                return;
            }
            owner.m_213846_((Component)Component.m_237110_((String)"death.attack.infection.zombified", (Object[])new Object[]{entity.m_5446_()}));
        }
    }

    @SubscribeEvent
    public void onInfectDeath(InfectionDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (entity instanceof Player) {
            return;
        }
        if (entity instanceof Villager && level instanceof ServerLevel) {
            Villager villager = (Villager)entity;
            ZombieVillager zombie = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
            if (zombie != null) {
                zombie.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(zombie.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), null);
                zombie.m_34375_(villager.m_7141_());
                zombie.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                zombie.m_34411_(villager.m_6616_().m_45388_());
                zombie.m_34373_(villager.m_7809_());
                ForgeEventFactory.onLivingConvert((LivingEntity)villager, (LivingEntity)zombie);
            }
            event.setResult(Event.Result.DENY);
        } else if (InfectionDataLoader.INSTANCE.canBeInfected((Entity)entity)) {
            if (InfectionDataLoader.INSTANCE.convertEntity((Mob)entity)) {
                return;
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void canApplyEffect(MobEffectEvent.Applicable event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (event.getEffectInstance().m_19544_() == HordesInfection.INFECTED.get() && InfectedEffect.preventInfection(entity)) {
            event.setResult(Event.Result.DENY);
            if (entity instanceof ServerPlayer) {
                InfectionPacketHandler.sendTo(new InfectMessage(true), ((ServerPlayer)entity).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @SubscribeEvent
    public void applyEffect(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (event.getEffectInstance().m_19544_() == HordesInfection.IMMUNITY.get() && entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && entity.m_21195_((MobEffect)HordesInfection.INFECTED.get())) {
            InfectionPacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> entity.m_9236_().m_46745_(entity.m_20097_())), new CureEntityMessage(entity));
        }
    }
}

