/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.smileycorp.hordes.config.ClientConfigHandler;
import net.smileycorp.hordes.infection.HordesInfection;

public class ClientInfectionEventHandler {
    private static Map<Item, Integer> immunityItems = Maps.newHashMap();
    private static Map<Item, Integer> wearableProtection = Maps.newHashMap();

    @SubscribeEvent
    public void renderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (!((Boolean)ClientConfigHandler.playerInfectionVisuals.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_21023_((MobEffect)HordesInfection.INFECTED.get())) {
            return;
        }
        int a = player.m_21124_((MobEffect)HordesInfection.INFECTED.get()).m_19564_();
        if (a == 0) {
            return;
        }
        Color colour = new Color(0.4745f, 0.6117f, 0.3961f, 0.005f * (float)a);
        Window window = mc.m_91268_();
        event.getGuiGraphics().m_280509_(0, 0, window.m_85441_(), window.m_85442_(), colour.getRGB());
    }

    @SubscribeEvent
    public void preRenderEntity(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)ClientConfigHandler.playerInfectionVisuals.get()).booleanValue() && player != null && player.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && entity != player) {
            int a = player.m_21124_((MobEffect)HordesInfection.INFECTED.get()).m_19564_();
            if (a > 2) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (a == 2) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.4f, (float)0.4f, (float)1.0f);
            }
        }
    }

    @SubscribeEvent
    public void postRenderEntity(RenderLivingEvent.Post event) {
        if (RenderSystem.getShaderColor().equals(new float[]{1.0f, 1.0f, 1.0f, 1.0f})) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void tooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        ArrayList components = Lists.newArrayList();
        if (((Boolean)ClientConfigHandler.cureTooltip.get()).booleanValue() && stack.m_204117_(HordesInfection.INFECTION_CURES_TAG)) {
            components.add(Component.m_237115_((String)"tooltip.hordes.cure"));
        }
        if (((Boolean)ClientConfigHandler.immunityTooltip.get()).booleanValue() && immunityItems.containsKey(item)) {
            PotionUtils.m_257410_((List)Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance((MobEffect)HordesInfection.IMMUNITY.get(), immunityItems.get(item) * 20)}), (List)components, (float)1.0f);
        }
        if (((Boolean)ClientConfigHandler.wearableProtectionTooltip.get()).booleanValue() && wearableProtection.containsKey(item)) {
            int value = wearableProtection.get(item);
            if (value == 0) {
                return;
            }
            String str = value + "%";
            if (value > 0) {
                str = "+" + str;
            }
            components.add(Component.m_237110_((String)"tooltip.hordes.wearableProtection", (Object[])new Object[]{str}).m_130940_(ChatFormatting.BLUE));
        }
        components.forEach(c -> event.getTooltipElements().add(Either.left((Object)c)));
    }

    @SubscribeEvent
    public void logOut(PlayerEvent.PlayerLoggedOutEvent event) {
        immunityItems.clear();
        wearableProtection.clear();
    }

    public static void readImmunityItems(List<Map.Entry<Item, Integer>> data) {
        immunityItems.clear();
        data.forEach(e -> immunityItems.put((Item)e.getKey(), (Integer)e.getValue()));
    }

    public static void readWearableProtection(List<Pair<Item, Integer>> data) {
        wearableProtection.clear();
        data.forEach(e -> wearableProtection.put((Item)e.getFirst(), (Integer)e.getSecond()));
    }
}

