/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.InfectEntityEvent;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.InfectedEffect;
import net.smileycorp.hordes.infection.data.InfectionConversionEntry;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;
import net.smileycorp.hordes.infection.network.SyncImmunityItemsMessage;
import net.smileycorp.hordes.infection.network.SyncWearableProtectionMessage;

public class InfectionDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static InfectionDataLoader INSTANCE = new InfectionDataLoader();
    private final Map<EntityType<?>, InfectionConversionEntry> conversionTable = Maps.newHashMap();
    private final Map<Item, Integer> immunityItems = Maps.newHashMap();
    private final Map<Item, Float> wearablesProtection = Maps.newHashMap();

    public InfectionDataLoader() {
        super(GSON, "horde_data");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiller) {
        Item item;
        ResourceLocation name;
        JsonObject obj;
        JsonElement json;
        ResourceLocation loc;
        this.conversionTable.clear();
        HordesLogger.logInfo("Loading conversion tables");
        for (String id : manager.m_7187_()) {
            loc = new ResourceLocation(id, "infection_conversions");
            json = map.get(loc);
            if (json == null) continue;
            try {
                HordesLogger.logInfo("Loading conversion table " + loc);
                for (JsonElement element : json.getAsJsonArray()) {
                    try {
                        InfectionConversionEntry entry = InfectionConversionEntry.deserialize(element.getAsJsonObject());
                        this.conversionTable.put(entry.getEntity(), entry);
                    }
                    catch (Exception e) {
                        HordesLogger.logError("Failed to load conversion entry " + element.getAsString(), e);
                    }
                }
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to load conversion table " + loc, e);
            }
        }
        this.immunityItems.clear();
        HordesLogger.logInfo("Loading immunity item list");
        for (String id : manager.m_7187_()) {
            loc = new ResourceLocation(id, "immunity_items");
            json = map.get(loc);
            if (json == null) continue;
            try {
                HordesLogger.logInfo("Loading immunity item list " + loc);
                for (JsonElement element : json.getAsJsonArray()) {
                    try {
                        obj = element.getAsJsonObject();
                        name = new ResourceLocation(obj.get("item").getAsString());
                        item = (Item)ForgeRegistries.ITEMS.getValue(name);
                        int duration = obj.get("duration").getAsInt();
                        this.immunityItems.put(item, duration);
                        HordesLogger.logInfo("Loaded immunity item " + name + " with duration " + duration);
                    }
                    catch (Exception e) {
                        HordesLogger.logError("Failed to load immunity item " + element.getAsString(), e);
                    }
                }
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to load immunity item list " + loc, e);
            }
        }
        this.wearablesProtection.clear();
        HordesLogger.logInfo("Loading wearables protection list");
        for (String id : manager.m_7187_()) {
            loc = new ResourceLocation(id, "immune_wearables");
            json = map.get(loc);
            if (json == null) continue;
            try {
                HordesLogger.logInfo("Loading wearables protection list " + loc);
                for (JsonElement element : json.getAsJsonArray()) {
                    try {
                        obj = element.getAsJsonObject();
                        name = new ResourceLocation(obj.get("item").getAsString());
                        item = (Item)ForgeRegistries.ITEMS.getValue(name);
                        float modifier = obj.get("multiplier").getAsFloat();
                        this.wearablesProtection.put(item, Float.valueOf(modifier));
                        HordesLogger.logInfo("Loaded wearable protection " + name + " with modifier " + modifier);
                    }
                    catch (Exception e) {
                        HordesLogger.logError("Failed to load wearable protection " + element.getAsString(), e);
                    }
                }
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to load wearable protection list " + loc, e);
            }
        }
    }

    public void tryToInfect(LivingEntity entity, LivingEntity attacker, DamageSource source, float amount) {
        InfectionConversionEntry entry;
        if (MinecraftForge.EVENT_BUS.post((Event)new InfectEntityEvent(entity, attacker, source, amount))) {
            return;
        }
        if (entity instanceof Player && ((Boolean)InfectionConfig.infectPlayers.get()).booleanValue() && entity.m_217043_().m_188501_() <= this.getModifiedInfectChance(entity, (float)((Double)InfectionConfig.playerInfectChance.get()).doubleValue())) {
            InfectedEffect.apply(entity);
        }
        if (entity instanceof Villager && ((Boolean)InfectionConfig.infectVillagers.get()).booleanValue() && entity.m_217043_().m_188501_() <= this.getModifiedInfectChance(entity, (float)((Double)InfectionConfig.villagerInfectChance.get()).doubleValue())) {
            InfectedEffect.apply(entity);
        }
        if ((entry = this.conversionTable.get(entity.m_6095_())) != null && entry.shouldInfect(entity)) {
            InfectedEffect.apply(entity);
        }
    }

    public boolean canBeInfected(Entity entity) {
        if (entity instanceof Player) {
            return (Boolean)InfectionConfig.infectPlayers.get();
        }
        if (entity instanceof Villager && ((Boolean)InfectionConfig.infectVillagers.get()).booleanValue()) {
            return true;
        }
        if (!(entity instanceof Mob)) {
            return false;
        }
        return this.conversionTable.containsKey(entity.m_6095_());
    }

    public boolean convertEntity(Mob entity) {
        InfectionConversionEntry entry = this.conversionTable.get(entity.m_6095_());
        if (entry != null) {
            return entry.convertEntity(entity) != null;
        }
        return false;
    }

    public boolean applyImmunity(LivingEntity entity, Item item) {
        if (this.immunityItems.containsKey(item)) {
            entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.IMMUNITY.get(), this.immunityItems.get(item) * 20));
            return true;
        }
        return false;
    }

    public float getModifiedInfectChance(LivingEntity entity, float chance) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!slot.m_254934_()) continue;
            chance *= this.getProtectionMultiplier(entity.m_6844_(slot));
        }
        return chance;
    }

    public float getProtectionMultiplier(ItemStack stack) {
        if (stack.m_41619_()) {
            return 1.0f;
        }
        Item item = stack.m_41720_();
        return this.wearablesProtection.containsKey(item) ? this.wearablesProtection.get(item).floatValue() : 1.0f;
    }

    public void syncData(Connection connection) {
        InfectionPacketHandler.sendTo(new SyncImmunityItemsMessage(this.immunityItems), connection, NetworkDirection.PLAY_TO_CLIENT);
        InfectionPacketHandler.sendTo(new SyncWearableProtectionMessage(this.wearablesProtection), connection, NetworkDirection.PLAY_TO_CLIENT);
    }
}

