/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.network;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.atlas.api.network.AbstractMessage;
import net.smileycorp.hordes.infection.client.ClientInfectionEventHandler;

public class SyncImmunityItemsMessage
extends AbstractMessage {
    private final List<Map.Entry<Item, Integer>> data = Lists.newArrayList();

    public SyncImmunityItemsMessage() {
    }

    public SyncImmunityItemsMessage(Map<Item, Integer> immunityItems) {
        this.data.addAll(immunityItems.entrySet());
    }

    public void read(FriendlyByteBuf buf) {
        while (buf.isReadable()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(buf.m_130277_()));
            if (item == null) continue;
            this.data.add(new AbstractMap.SimpleEntry<Item, Integer>(item, buf.readInt()));
        }
    }

    public void m_5779_(FriendlyByteBuf buf) {
        this.data.forEach(e -> {
            buf.m_130070_(ForgeRegistries.ITEMS.getKey((Object)((Item)e.getKey())).toString());
            buf.writeInt(((Integer)e.getValue()).intValue());
        });
    }

    public void m_5797_(PacketListener handler) {
    }

    public void process(NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientInfectionEventHandler.readImmunityItems(this.data)));
        ctx.setPacketHandled(true);
    }
}

