/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.PlatStuff;
import pepjebs.mapatlases.client.AbstractAtlasWidget;
import pepjebs.mapatlases.client.Anchoring;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.integration.ImmediatelyFastCompat;
import pepjebs.mapatlases.integration.moonlight.ClientMarkers;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.map_collection.MapKey;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasesHUD
extends AbstractAtlasWidget {
    public static final ResourceLocation MAP_BACKGROUND = MapAtlasesMod.res("textures/gui/hud/map_background.png");
    public static final ResourceLocation MAP_FOREGROUND = MapAtlasesMod.res("textures/gui/hud/map_foreground.png");
    private static final int BACKGROUND_SIZE = 128;
    protected final int BG_SIZE = 64;
    private final Minecraft mc;
    private boolean needsInit = true;
    private ItemStack currentAtlas = ItemStack.f_41583_;
    private MapKey currentMapKey = null;
    private MapKey lastMapKey = null;
    private float globalScale = 1.0f;
    private boolean displaysY = true;

    public MapAtlasesHUD() {
        super(1);
        this.mc = Minecraft.m_91087_();
        this.rotatesWithPlayer = true;
        this.zoomLevel = 1.0f;
    }

    @Override
    @Nullable
    public MapDataHolder getMapWithCenter(int centerX, int centerZ) {
        Slice slice = this.currentMapKey.slice();
        IMapCollection maps = MapAtlasItem.getMaps(this.currentAtlas, (Level)this.mc.f_91073_);
        return maps.select(centerX, centerZ, slice);
    }

    @Override
    protected void initialize(MapDataHolder originalCenterMap) {
        super.initialize(originalCenterMap);
        this.followingPlayer = MapAtlasesClientConfig.miniMapFollowPlayer.get();
        this.rotatesWithPlayer = MapAtlasesClientConfig.miniMapRotate.get();
        this.globalScale = (float)MapAtlasesClientConfig.miniMapScale.get().doubleValue();
        this.displaysY = MapAtlasesClientConfig.yOnlyWithSlice.get() == false || MapAtlasItem.getMaps(this.currentAtlas, (Level)this.mc.f_91073_).hasOneSlice();
        this.drawBigPlayerMarker = this.followingPlayer;
    }

    @Override
    protected void applyScissors(GuiGraphics graphics, int x, int y, int x1, int y1) {
        super.applyScissors(graphics, (int)((float)x * this.globalScale), (int)((float)y * this.globalScale), (int)((float)x1 * this.globalScale), (int)((float)y1 * this.globalScale));
    }

    public void render(GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null || this.mc.f_91066_.f_92063_) {
            return;
        }
        if (!MapAtlasesClientConfig.drawMiniMapHUD.get().booleanValue()) {
            return;
        }
        ItemStack atlas = MapAtlasesClient.getCurrentActiveAtlas();
        if (atlas.m_41619_()) {
            return;
        }
        MapDataHolder activeMap = MapAtlasesClient.getActiveMap();
        this.currentMapKey = MapAtlasesClient.getActiveMapKey();
        if (activeMap == null || this.currentMapKey == null) {
            return;
        }
        if (MapAtlasesClientConfig.hideWhenInHand.get().booleanValue() && (this.mc.f_91074_.m_21205_().m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()) || this.mc.f_91074_.m_21206_().m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()))) {
            return;
        }
        if (this.currentAtlas != atlas) {
            this.needsInit = true;
        }
        this.currentAtlas = atlas;
        ClientLevel level = this.mc.f_91073_;
        LocalPlayer player = this.mc.f_91074_;
        if (this.needsInit) {
            this.needsInit = false;
            this.initialize(activeMap);
        }
        this.mapWherePlayerIs = activeMap;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(this.globalScale, this.globalScale, 1.0f);
        if (!Objects.equals(this.lastMapKey, this.currentMapKey)) {
            this.lastMapKey = this.currentMapKey;
            if (this.mc.f_91080_ == null && MapAtlasesClientConfig.mapChangeSound.get().booleanValue()) {
                player.m_5496_(MapAtlasesMod.ATLAS_PAGE_TURN_SOUND_EVENT.get(), (float)MapAtlasesClientConfig.soundScalar.get().doubleValue(), 1.0f);
            }
        }
        int mapWidgetSize = 58;
        Anchoring anchorLocation = MapAtlasesClientConfig.miniMapAnchoring.get();
        int off = 5;
        int x = anchorLocation.isLeft ? off : (int)((float)screenWidth / this.globalScale) - (64 + off);
        int y = anchorLocation.isUp ? off : (int)((float)screenHeight / this.globalScale) - (64 + off);
        x += (int)((float)MapAtlasesClientConfig.miniMapHorizontalOffset.get().intValue() / this.globalScale);
        y += (int)((float)MapAtlasesClientConfig.miniMapVerticalOffset.get().intValue() / this.globalScale);
        if (anchorLocation == Anchoring.UPPER_RIGHT) {
            boolean hasBeneficial = false;
            boolean hasNegative = false;
            for (MobEffectInstance e : player.m_21220_()) {
                MobEffect effect = e.m_19544_();
                if (effect.m_19486_()) {
                    hasBeneficial = true;
                    continue;
                }
                hasNegative = true;
            }
            int offsetForEffects = MapAtlasesClientConfig.activePotionVerticalOffset.get();
            if (hasNegative && y < 2 * offsetForEffects) {
                y += 2 * offsetForEffects - y;
            } else if (hasBeneficial && y < offsetForEffects) {
                y += offsetForEffects - y;
            }
        }
        poseStack.m_85836_();
        if (!this.followingPlayer) {
            this.currentXCenter = Math.floor((player.m_20185_() + 64.0) / (double)this.mapBlocksSize) * (double)this.mapBlocksSize + (double)((float)this.mapBlocksSize / 2.0f - 64.0f);
            this.currentZCenter = Math.floor((player.m_20189_() + 64.0) / (double)this.mapBlocksSize) * (double)this.mapBlocksSize + (double)((float)this.mapBlocksSize / 2.0f - 64.0f);
        } else {
            this.currentXCenter = player.m_20185_();
            this.currentZCenter = player.m_20189_();
        }
        MapAtlasesClient.setDecorationsScale((float)((double)(2.0f * this.zoomLevel) * MapAtlasesClientConfig.miniMapDecorationScale.get()));
        MapAtlasesClient.setDecorationsTextScale((float)((double)(2.0f * this.zoomLevel) * MapAtlasesClientConfig.miniMapDecorationTextScale.get()));
        float yRot = player.m_146908_();
        if (this.rotatesWithPlayer) {
            MapAtlasesClient.setDecorationRotation(yRot - 180.0f);
        }
        int light = MapAtlasesClientConfig.minimapSkyLight.get() == false ? 0xF000F0 : LightTexture.m_109885_((int)0, (int)level.m_45517_(LightLayer.SKY, player.m_20097_().m_7494_()));
        int borderSize = (64 - mapWidgetSize) / 2;
        this.drawAtlas(graphics, x + borderSize, y + borderSize, mapWidgetSize, mapWidgetSize, (Player)player, this.zoomLevel * (float)MapAtlasesClientConfig.miniMapZoomMultiplier.get().doubleValue(), MapAtlasesClientConfig.miniMapBorder.get(), this.currentMapKey.slice().type(), light);
        if (MapAtlasesMod.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.startBatching();
        }
        RenderSystem.enableDepthTest();
        graphics.m_280398_(MAP_BACKGROUND, x, y, -2, 0.0f, 0.0f, 64, 64, 64, 64);
        RenderSystem.disableDepthTest();
        MapAtlasesClient.setDecorationsScale(1.0f);
        MapAtlasesClient.setDecorationsTextScale(1.0f);
        if (this.rotatesWithPlayer) {
            MapAtlasesClient.setDecorationRotation(0.0f);
        }
        poseStack.m_85836_();
        poseStack.m_252880_((float)x + (float)mapWidgetSize / 2.0f + 3.0f, (float)y + (float)mapWidgetSize / 2.0f + 3.0f, 0.0f);
        if (!this.rotatesWithPlayer) {
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f - yRot));
        }
        if (this.drawBigPlayerMarker) {
            poseStack.m_252880_(-4.5f, -4.0f, 0.0f);
            graphics.m_280163_(DecorationBookmarkButton.MAP_ICON_TEXTURE, 0, 0, 0.0f, 0.0f, 8, 8, 128, 128);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
        float textScaling = (float)MapAtlasesClientConfig.minimapCoordsAndBiomeScale.get().doubleValue();
        int textHeightOffset = 2;
        int actualBgSize = (int)(64.0f * this.globalScale);
        poseStack.m_85836_();
        if (!anchorLocation.isUp) {
            poseStack.m_252880_(0.0f, -64.0f - 20.0f * textScaling - 2.0f, 0.0f);
        }
        Font font = this.mc.f_91062_;
        boolean global = MapAtlasesClientConfig.drawMinimapCoords.get();
        boolean local = MapAtlasesClientConfig.drawMinimapChunkCoords.get();
        if (global || local) {
            BlockPos pos = new BlockPos(new Vec3i(MapAtlasesHUD.towardsZero(player.m_20182_().f_82479_), MapAtlasesHUD.towardsZero(player.m_20182_().f_82480_), MapAtlasesHUD.towardsZero(player.m_20182_().f_82481_)));
            if (global) {
                this.drawMapComponentCoords(graphics, font, x, (int)((float)(y + 64) + (float)textHeightOffset / this.globalScale), actualBgSize, textScaling, pos, false);
                textHeightOffset = (int)((float)textHeightOffset + 10.0f * textScaling);
            }
            if (local) {
                this.drawMapComponentCoords(graphics, font, x, (int)((float)(y + 64) + (float)textHeightOffset / this.globalScale), actualBgSize, textScaling, pos, true);
                textHeightOffset = (int)((float)textHeightOffset + 10.0f * textScaling);
            }
        }
        if (MapAtlasesClientConfig.drawMinimapBiome.get().booleanValue()) {
            this.drawMapComponentBiome(graphics, font, x, (int)((float)(y + 64) + (float)textHeightOffset / this.globalScale), actualBgSize, textScaling, player.m_20183_(), (Level)level);
        }
        poseStack.m_85849_();
        if (MapAtlasesClientConfig.drawMinimapCardinals.get().booleanValue()) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)x + 32.0f, (float)y + 32.0f, 5.0f);
            Pair<Float, Float> p = MapAtlasesHUD.getDirectionPos(29.0f, this.rotatesWithPlayer ? yRot : 180.0f);
            float a = ((Float)p.getFirst()).floatValue();
            float b = ((Float)p.getSecond()).floatValue();
            this.drawLetter(graphics, font, a, b, "N");
            if (!MapAtlasesClientConfig.miniMapOnlyNorth.get().booleanValue()) {
                this.drawLetter(graphics, font, -a, -b, "S");
                this.drawLetter(graphics, font, -b, a, "E");
                this.drawLetter(graphics, font, b, -a, "W");
            }
            poseStack.m_85849_();
        }
        if (MapAtlasesMod.MOONLIGHT && MapAtlasesClientConfig.moonlightPinTracking.get().booleanValue()) {
            poseStack.m_85836_();
            RenderSystem.enableDepthTest();
            poseStack.m_252880_((float)x + 32.0f, (float)y + 32.0f, -10.0f);
            ClientMarkers.drawSmallPins(graphics, font, this.currentXCenter + (double)((float)this.mapBlocksSize / 2.0f), this.currentZCenter + (double)((float)this.mapBlocksSize / 2.0f), this.currentMapKey.slice(), (float)this.mapBlocksSize * this.zoomLevel, (Player)player, this.rotatesWithPlayer);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        if (MapAtlasesMod.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.endBatching();
        }
    }

    private void drawLetter(GuiGraphics graphics, Font font, float a, float b, String letter) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        float scale = (float)MapAtlasesClientConfig.miniMapCardinalsScale.get().doubleValue() / this.globalScale;
        pose.m_85841_(scale, scale, 1.0f);
        float f = a / scale - (float)font.m_92895_(letter) / 2.0f;
        float f2 = b / scale;
        Objects.requireNonNull(font);
        MapAtlasesHUD.drawStringWithLighterShadow(graphics, font, letter, f, f2 - 9.0f / 2.0f);
        pose.m_85849_();
    }

    private static int towardsZero(double d) {
        if (d < 0.0) {
            return -1 * (int)Math.floor(-1.0 * d);
        }
        return (int)Math.floor(d);
    }

    public void drawMapComponentCoords(GuiGraphics context, Font font, int x, int y, int targetWidth, float textScaling, BlockPos pos, boolean chunk) {
        String coordsToDisplay = chunk ? Component.m_237110_((String)"message.map_atlases.chunk_coordinates", (Object[])new Object[]{pos.m_123341_() / 16, pos.m_123343_() / 16, pos.m_123341_() % 16, pos.m_123343_() % 16}).getString() : (this.displaysY ? Component.m_237110_((String)"message.map_atlases.coordinates_full", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).getString() : Component.m_237110_((String)"message.map_atlases.coordinates", (Object[])new Object[]{pos.m_123341_(), pos.m_123343_()}).getString());
        MapAtlasesHUD.drawScaledComponent(context, font, x, y, coordsToDisplay, textScaling / this.globalScale, targetWidth, (int)((float)targetWidth / this.globalScale));
    }

    public void drawMapComponentBiome(GuiGraphics context, Font font, int x, int y, int targetWidth, float textScaling, BlockPos blockPos, Level level) {
        String biomeToDisplay = "";
        Optional key = level.m_204166_(blockPos).m_203543_();
        if (key.isPresent()) {
            ResourceKey biomeKey = (ResourceKey)key.get();
            biomeToDisplay = Component.m_237115_((String)Util.m_137492_((String)"biome", (ResourceLocation)biomeKey.m_135782_())).getString();
        }
        MapAtlasesHUD.drawScaledComponent(context, font, x, y, biomeToDisplay, textScaling / this.globalScale, targetWidth, (int)((float)targetWidth / this.globalScale));
    }

    public static void drawScaledComponent(GuiGraphics context, Font font, int x, int y, String text, float textScaling, int maxWidth, int targetWidth) {
        PoseStack pose = context.m_280168_();
        float textWidth = font.m_92895_(text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        float centerX = (float)x + (float)targetWidth / 2.0f;
        pose.m_85836_();
        pose.m_252880_(centerX, (float)(y + 4), 5.0f);
        pose.m_85841_(scale *= textScaling, scale, 1.0f);
        pose.m_252880_(-textWidth / 2.0f, -4.0f, 0.0f);
        MapAtlasesHUD.drawStringWithLighterShadow(context, font, text, 0.0f, 0.0f);
        pose.m_85849_();
    }

    private static void drawStringWithLighterShadow(GuiGraphics context, Font font, String text, float x, float y) {
        PlatStuff.drawString(context, font, text, x + 1.0f, y + 1.0f, 0x595959, false);
        PlatStuff.drawString(context, font, text, x, y, 0xE0E0E0, false);
    }

    public static Pair<Float, Float> getDirectionPos(float radius, float angleDegrees) {
        float y;
        float x;
        angleDegrees = Mth.m_14177_((float)(90.0f - angleDegrees));
        float angleRadians = (float)Math.toRadians(angleDegrees);
        if (angleDegrees >= -45.0f && angleDegrees < 45.0f) {
            x = radius;
            y = radius * (float)Math.tan(angleRadians);
        } else if (angleDegrees >= 45.0f && angleDegrees < 135.0f) {
            x = radius / (float)Math.tan(angleRadians);
            y = radius;
        } else if (angleDegrees >= 135.0f || angleDegrees < -135.0f) {
            x = -radius;
            y = -radius * (float)Math.tan(angleRadians);
        } else {
            x = -radius / (float)Math.tan(angleRadians);
            y = -radius;
        }
        return Pair.of((Object)Float.valueOf(x), (Object)Float.valueOf(y));
    }

    public void increaseZoom() {
        this.zoomLevel = Math.max(1.0f, this.zoomLevel - 0.5f);
    }

    public void decreaseZoom() {
        this.zoomLevel = Math.min(10.0f, this.zoomLevel + 0.5f);
    }
}

