/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.supplementaries.common.misc.MapLightHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class SupplementariesClientCompat {
    private static NativeImage dayTexture;
    private static NativeImage nightTexture;
    private static boolean lastTickWasDay;

    public static void init() {
        ClientHelper.addClientReloadListener(R::new, (ResourceLocation)MapAtlasesMod.res("lightmap"));
    }

    public static void onClientTick(ClientLevel level) {
        if (MapAtlasesClientConfig.nightLightMap.get().booleanValue()) {
            boolean isDay;
            float timeOfDay = level.m_46942_(0.0f);
            boolean bl = isDay = (double)timeOfDay < 0.26 || (double)timeOfDay > 0.8;
            if (isDay != lastTickWasDay) {
                lastTickWasDay = isDay;
                MapLightHandler.setLightMap((NativeImage)(lastTickWasDay ? dayTexture : nightTexture));
                MapRenderer mapRenderer = Minecraft.m_91087_().f_91063_.m_109151_();
                for (Map.Entry e : level.f_104556_.entrySet()) {
                    String keyId = (String)e.getKey();
                    if (!((String)e.getKey()).startsWith("map_")) continue;
                    MapItemSavedData data = (MapItemSavedData)e.getValue();
                    mapRenderer.m_168765_(MapAtlasesAccessUtils.findMapIntFromString(keyId), data);
                }
            }
        }
    }

    static {
        lastTickWasDay = true;
    }

    public static class R
    extends SimpleJsonResourceReloadListener {
        public R() {
            super(new Gson().newBuilder().create(), "lightmap");
        }

        protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
            try {
                dayTexture = TextureImage.open((ResourceManager)pResourceManager, (ResourceLocation)MapAtlasesMod.res("item/lightmap_day")).getImage();
                nightTexture = TextureImage.open((ResourceManager)pResourceManager, (ResourceLocation)MapAtlasesMod.res("item/lightmap_night")).getImage();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

