/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration.moonlight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.quickplay.QuickPlayLog;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.ui.MapAtlasesHUD;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.integration.XaeroMinimapCompat;
import pepjebs.mapatlases.integration.moonlight.CustomDecorationButton;
import pepjebs.mapatlases.integration.moonlight.PinDecoration;
import pepjebs.mapatlases.integration.moonlight.PinMarker;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class ClientMarkers {
    private static final TagKey<MapDecorationType<?, ?>> PINS = TagKey.m_203882_((ResourceKey)MapDataRegistry.REGISTRY_KEY, (ResourceLocation)MapAtlasesMod.res("pins"));
    private static final WeakHashMap<MapDecorationType<?, ?>, ResourceLocation> SMALL_PINS = new WeakHashMap();
    private static final Map<String, Set<MapBlockMarker<?>>> markers = new HashMap();
    private static final Map<Slice, Set<MapBlockMarker<?>>> markersPerSlice = new HashMap();
    private static final Map<MapItemSavedData, String> mapLookup = new IdentityHashMap<MapItemSavedData, String>();
    private static String lastFolderNameOrIP = null;
    private static QuickPlayLog.Type lastType = QuickPlayLog.Type.SINGLEPLAYER;
    private static Path currentPath = null;

    public static void setWorldFolder(String pId, QuickPlayLog.Type type) {
        lastFolderNameOrIP = pId;
        lastType = type;
    }

    public static void deleteAllMarkersData(String folderName) {
        try {
            Path path = ClientMarkers.getFilePath(folderName, QuickPlayLog.Type.SINGLEPLAYER);
            Files.deleteIfExists(path);
        }
        catch (Exception e) {
            MapAtlasesMod.LOGGER.error("Could not delete client markers saved data of world {}", (Object)folderName, (Object)e);
        }
    }

    public static void loadClientMarkers(long seed, String levelName) {
        markers.clear();
        markersPerSlice.clear();
        mapLookup.clear();
        if (lastFolderNameOrIP == null) {
            throw new RuntimeException("Could not load client markers saved data. Folder name is null");
        }
        currentPath = ClientMarkers.getFilePath(lastFolderNameOrIP, lastType);
        if (Files.exists(currentPath, new LinkOption[0])) {
            try (FileInputStream inputStream = new FileInputStream(currentPath.toFile());){
                ClientMarkers.load(NbtIo.m_128939_((InputStream)inputStream));
            }
            catch (Exception ignored) {
                MapAtlasesMod.LOGGER.error("Could not load client markers saved data at {}", (Object)currentPath);
            }
        }
        if (MapAtlasesClientConfig.convertXaero.get().booleanValue()) {
            XaeroMinimapCompat.parseXaeroWaypoints(lastFolderNameOrIP);
        }
        lastFolderNameOrIP = null;
        lastType = QuickPlayLog.Type.SINGLEPLAYER;
    }

    private static String sanitiseServerName(String input) {
        return input.toLowerCase().replaceAll("\\]:\\d+$", "").replaceAll("[\\[\\]]", "").replaceAll("[^a-z0-9 ]", "_");
    }

    @NotNull
    private static Path getFilePath(String lastFolderNameOrIP, QuickPlayLog.Type type) {
        String fileName = lastType == QuickPlayLog.Type.SINGLEPLAYER ? lastFolderNameOrIP : ClientMarkers.sanitiseServerName(lastFolderNameOrIP);
        try {
            return PlatHelper.getGamePath().resolve("map_atlases/" + type.m_7912_() + "/" + fileName + ".nbt");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get client pins path for world " + fileName, e);
        }
    }

    public static void saveClientMarkers() {
        if (markers.isEmpty()) {
            return;
        }
        if (currentPath == null) {
            MapAtlasesMod.LOGGER.error("Could not save client markers saved data. Path is null");
            return;
        }
        try {
            if (!Files.exists(currentPath, new LinkOption[0])) {
                Files.createDirectories(currentPath.getParent(), new FileAttribute[0]);
            }
            try (FileOutputStream outputstream = new FileOutputStream(currentPath.toFile());){
                NbtIo.m_128947_((CompoundTag)ClientMarkers.save(), (OutputStream)outputstream);
                MapAtlasesMod.LOGGER.info("Saved {} client map waypoints", (Object)markers.size());
            }
        }
        catch (Exception e) {
            MapAtlasesMod.LOGGER.error("Could not save client markers saved data at {}", (Object)currentPath, (Object)e);
        }
        markers.clear();
    }

    private static void load(CompoundTag tag) {
        for (String k : tag.m_128431_()) {
            HashSet<MapBlockMarker> l = new HashSet<MapBlockMarker>();
            ListTag listNbt = tag.m_128437_(k, 10);
            for (int j = 0; j < listNbt.size(); ++j) {
                CompoundTag c = listNbt.m_128728_(j);
                MapBlockMarker marker = MapDataRegistry.readMarker((CompoundTag)c);
                if (marker == null) continue;
                l.add(marker);
            }
            markers.put(k, l);
        }
    }

    private static CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, Set<MapBlockMarker<?>>> v : markers.entrySet()) {
            ListTag listNBT = new ListTag();
            for (MapBlockMarker<?> marker : v.getValue()) {
                CompoundTag c = new CompoundTag();
                c.m_128365_(marker.getTypeId(), (Tag)marker.saveToNBT());
                listNBT.add((Object)c);
            }
            tag.m_128365_(v.getKey(), (Tag)listNBT);
        }
        return tag;
    }

    public static Set<MapBlockMarker<?>> send(Integer integer, MapItemSavedData data) {
        String stringId = mapLookup.computeIfAbsent(data, g -> {
            MapDataHolder holder = MapDataHolder.findFromId((Level)Minecraft.m_91087_().f_91073_, integer);
            String st = Objects.requireNonNull(holder).stringId;
            Set<MapBlockMarker<?>> markersSet = markers.get(st);
            if (markersSet != null) {
                for (MapBlockMarker<?> mapBlockMarker : markersSet) {
                }
                markersPerSlice.computeIfAbsent(holder.slice, a -> new HashSet()).addAll(markersSet);
            }
            return st;
        });
        Set<MapBlockMarker<?>> m = markers.get(stringId);
        if (m != null) {
            return m;
        }
        return Set.of();
    }

    public static void addMarker(MapDataHolder holder, ColumnPos pos, String text, int index) {
        MapBlockMarker marker = ClientMarkers.getPinAt(index).createEmptyMarker();
        if (!text.isEmpty()) {
            marker.setName((Component)Component.m_237115_((String)text));
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Integer h = holder.height;
        if (h == null) {
            h = level.m_46472_().equals(holder.data.f_77887_) ? level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.f_140724_(), pos.f_140724_()) : 64;
        }
        marker.setPos(new BlockPos(pos.f_140723_(), h.intValue(), pos.f_140724_()));
        markers.computeIfAbsent(holder.stringId, k -> new HashSet()).add(marker);
        markersPerSlice.computeIfAbsent(holder.slice, a -> new HashSet()).add(marker);
        ((ExpandedMapData)holder.data).addCustomMarker(marker);
    }

    private static MapDecorationType<?, ?> getPinAt(int index) {
        Optional tag = MapDataRegistry.getRegistry((RegistryAccess)Utils.hackyGetRegistryAccess()).m_203431_(PINS);
        if (tag.isEmpty()) {
            throw new AssertionError((Object)"map_atlases:pins tag was empty or not found. How is this possible?");
        }
        List<Holder> pins = ((HolderSet.Named)tag.get()).m_203614_().sorted(Comparator.comparing(h -> {
            Optional key = h.m_203543_();
            if (key.isEmpty()) {
                throw new AssertionError((Object)"Registry key for MapDecorationType was null. How?");
            }
            return ((ResourceKey)key.get()).toString();
        })).toList();
        return (MapDecorationType)pins.get(Math.floorMod(index, pins.size())).m_203334_();
    }

    public static boolean removeDeco(String mapId, String key) {
        Set<MapBlockMarker<?>> mr = markers.get(mapId);
        if (mr != null) {
            mr.removeIf(m -> m.getMarkerId().equals(key));
        }
        for (Set<MapBlockMarker<?>> v : markersPerSlice.values()) {
            v.removeIf(m -> m.getMarkerId().equals(key));
        }
        return mr != null;
    }

    public static void renderDecorationPreview(GuiGraphics pGuiGraphics, float x, float y, int index, boolean outline, int alpha) {
        CustomDecorationButton.renderStaticMarker(pGuiGraphics, ClientMarkers.getPinAt(index), x, y, 1, outline, alpha);
    }

    public static void drawSmallPins(GuiGraphics graphics, Font font, double mapCenterX, double mapCenterZ, Slice slice, float widgetWorldLen, Player player, boolean rotateWithPlayer) {
        Set<MapBlockMarker<?>> pins = markersPerSlice.get(slice);
        if (pins != null) {
            Registry reg = MapDataRegistry.getRegistry((RegistryAccess)player.m_9236_().m_9598_());
            PoseStack matrixStack = graphics.m_280168_();
            int i = 0;
            VertexConsumer vertexBuilder = graphics.m_280091_().m_6299_(MapDecorationClientManager.MAP_MARKERS_RENDER_TYPE);
            float yRot = rotateWithPlayer ? player.m_146908_() : 180.0f;
            BlockPos playerPos = rotateWithPlayer ? player.m_20183_() : BlockPos.m_274561_((double)mapCenterX, (double)0.0, (double)mapCenterZ);
            for (MapBlockMarker<?> marker : pins) {
                PinMarker mp;
                BlockPos pos = marker.getPos();
                Vec3 dist = playerPos.m_252807_().m_82546_(pos.m_252807_());
                if (!(marker instanceof PinMarker) || !(mp = (PinMarker)marker).isFocused() || ClientMarkers.isOffscreen(widgetWorldLen, yRot, dist)) continue;
                matrixStack.m_85836_();
                double angle = 57.2957763671875 * Math.atan2(dist.f_82479_, dist.f_82481_) + (double)yRot;
                Pair<Float, Float> pp = MapAtlasesHUD.getDirectionPos(29.0f, (float)angle);
                float a = ((Float)pp.getFirst()).floatValue();
                float b = ((Float)pp.getSecond()).floatValue();
                matrixStack.m_252880_(a, b, 5.0f);
                matrixStack.m_85841_(4.0f, 4.0f, 0.0f);
                matrixStack.m_85837_(-0.25, -0.25, 0.0);
                ResourceLocation texture = SMALL_PINS.computeIfAbsent(marker.getType(), t -> reg.m_7981_(t).m_247266_(k -> "map_marker/" + k + "_small"));
                TextureAtlasSprite sprite = MapDecorationClientManager.getAtlasSprite((ResourceLocation)texture);
                RenderUtil.renderSprite((PoseStack)matrixStack, (VertexConsumer)vertexBuilder, (int)0xF000F0, (int)i++, (int)255, (int)255, (int)255, (TextureAtlasSprite)sprite);
                matrixStack.m_85849_();
            }
        }
    }

    private static boolean isOffscreen(float maxSize, float playerYRot, Vec3 dist) {
        Vec3 c = dist.m_82524_(playerYRot * ((float)Math.PI / 180));
        float l = maxSize / 2.0f + 5.0f;
        return c.f_82481_ <= (double)l && c.f_82481_ >= (double)(-l) && c.f_82479_ <= (double)l && c.f_82479_ >= (double)(-l);
    }

    public static void focusMarker(MapDataHolder map, CustomMapDecoration deco, boolean focused) {
        if (deco instanceof PinDecoration) {
            PinDecoration mp = (PinDecoration)deco;
            mp.forceFocused(focused);
        }
    }

    public static boolean isDecorationFocused(MapDataHolder map, CustomMapDecoration deco) {
        if (deco instanceof PinDecoration) {
            PinDecoration mp = (PinDecoration)deco;
            return mp.isFocused();
        }
        return false;
    }
}

