/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration.moonlight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.client.DecorationRenderer;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.integration.moonlight.ClientMarkers;
import pepjebs.mapatlases.integration.moonlight.PinDecoration;
import pepjebs.mapatlases.networking.C2SRemoveMarkerPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.MapDataHolder;

public class CustomDecorationButton
extends DecorationBookmarkButton {
    private final CustomMapDecoration decoration;

    public static DecorationBookmarkButton create(int px, int py, AtlasOverviewScreen screen, MapDataHolder data, Object mapDecoration, String id) {
        return new CustomDecorationButton(px, py, screen, data, (CustomMapDecoration)mapDecoration, id);
    }

    private CustomDecorationButton(int px, int py, AtlasOverviewScreen screen, MapDataHolder data, CustomMapDecoration mapDecoration, String id) {
        super(px, py, screen, data, id);
        this.decoration = mapDecoration;
        this.m_257544_(this.createTooltip());
    }

    @Override
    public double getWorldX() {
        return (double)this.mapData.data.f_256718_ - CustomDecorationButton.getDecorationPos(this.decoration.getX(), this.mapData.data);
    }

    @Override
    public double getWorldZ() {
        return (double)this.mapData.data.f_256789_ - CustomDecorationButton.getDecorationPos(this.decoration.getY(), this.mapData.data);
    }

    @Override
    public int getBatchGroup() {
        return 1;
    }

    @Override
    public Component getDecorationName() {
        Component displayName = this.decoration.getDisplayName();
        return displayName == null ? Component.m_237113_((String)AtlasOverviewScreen.getReadableName(Utils.getID((MapDecorationType)this.decoration.getType()).m_135815_().toLowerCase(Locale.ROOT))) : displayName;
    }

    @Override
    protected void renderDecoration(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        PinDecoration p;
        CustomMapDecoration customMapDecoration;
        CustomDecorationButton.renderStaticMarker(pGuiGraphics, this.decoration.getType(), (float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f, 1, (customMapDecoration = this.decoration) instanceof PinDecoration && (p = (PinDecoration)customMapDecoration).isFocused(), 255);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        if (this.control || button == 1) {
            this.focusMarker();
        } else {
            super.m_5716_(mouseX, mouseY);
        }
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        if (this.control) {
            this.focusMarker();
        } else {
            super.m_5716_(mouseX, mouseY);
        }
    }

    protected boolean m_7972_(int pButton) {
        return pButton == 0 && this.canDeleteMarker() || pButton == 1 && this.canFocusMarker();
    }

    protected void focusMarker() {
        ClientMarkers.focusMarker(this.mapData, this.decoration, !ClientMarkers.isDecorationFocused(this.mapData, this.decoration));
    }

    @Override
    protected boolean canFocusMarker() {
        return this.decoration instanceof PinDecoration;
    }

    @Override
    protected void deleteMarker() {
        Map decorations = ((ExpandedMapData)this.mapData.data).getCustomDecorations();
        CustomMapDecoration d = (CustomMapDecoration)decorations.get(this.decorationId);
        if (d != null) {
            if (!ClientMarkers.removeDeco(this.mapData.stringId, this.decorationId)) {
                MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2SRemoveMarkerPacket(this.mapData.stringId, d.hashCode(), true));
            }
            decorations.remove(this.decorationId);
        }
    }

    public static void renderStaticMarker(GuiGraphics pGuiGraphics, MapDecorationType<?, ?> type, float x, float y, int index, boolean outline, int alpha) {
        DecorationRenderer renderer = MapDecorationClientManager.getRenderer(type);
        if (renderer != null) {
            PoseStack poseStack = pGuiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)x, (double)y, 0.005);
            poseStack.m_85841_(4.0f, 4.0f, -3.0f);
            MultiBufferSource.BufferSource buffer = pGuiGraphics.m_280091_();
            VertexConsumer vertexBuilder = buffer.m_6299_(MapDecorationClientManager.MAP_MARKERS_RENDER_TYPE);
            renderer.renderDecorationSprite(poseStack, (MultiBufferSource)buffer, vertexBuilder, 0xF000F0, index, -1, alpha, outline);
            poseStack.m_85849_();
        }
    }
}

