/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration.moonlight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.integration.moonlight.ClientMarkers;
import pepjebs.mapatlases.integration.moonlight.EntityPinDecoration;
import pepjebs.mapatlases.integration.moonlight.EntityPinDecorationRenderer;
import pepjebs.mapatlases.integration.moonlight.EntityPinMarker;
import pepjebs.mapatlases.integration.moonlight.EntityRadar;
import pepjebs.mapatlases.integration.moonlight.PinDecoration;
import pepjebs.mapatlases.integration.moonlight.PinDecorationRenderer;
import pepjebs.mapatlases.integration.moonlight.PinMarker;
import pepjebs.mapatlases.utils.DecorationHolder;
import pepjebs.mapatlases.utils.MapDataHolder;

public class MoonlightCompat {
    private static final TagKey<MapDecorationType<?, ?>> NOT_ON_ATLAS = TagKey.m_203882_((ResourceKey)MapDataRegistry.REGISTRY_KEY, (ResourceLocation)MapAtlasesMod.res("no_button_on_atlas"));
    private static final ResourceLocation PIN_TYPE_ID = MapAtlasesMod.res("pin");
    private static final ResourceLocation PIN_ENTITY_TYPE_ID = MapAtlasesMod.res("entity_pin");

    public static void init() {
        MapDataRegistry.registerCustomType((ResourceLocation)PIN_TYPE_ID, () -> CustomDecorationType.simple(PinMarker::new, PinDecoration::new));
        MapDataRegistry.registerCustomType((ResourceLocation)PIN_ENTITY_TYPE_ID, () -> CustomDecorationType.simple(EntityPinMarker::new, EntityPinDecoration::new));
        if (PlatHelper.getPhysicalSide().isClient()) {
            MapDataRegistry.addDynamicClientMarkersEvent(ClientMarkers::send);
            MapDataRegistry.addDynamicClientMarkersEvent(EntityRadar::send);
            MapDecorationClientManager.registerCustomRenderer((ResourceLocation)PIN_TYPE_ID, PinDecorationRenderer::new);
            MapDecorationClientManager.registerCustomRenderer((ResourceLocation)PIN_ENTITY_TYPE_ID, EntityPinDecorationRenderer::new);
        }
    }

    public static Collection<DecorationHolder> getCustomDecorations(MapDataHolder map) {
        return ((ExpandedMapData)map.data).getCustomDecorations().entrySet().stream().filter(e -> !MapDataRegistry.getRegistry((RegistryAccess)Utils.hackyGetRegistryAccess()).m_263177_((Object)((CustomMapDecoration)e.getValue()).getType()).m_203656_(NOT_ON_ATLAS)).map(a -> new DecorationHolder(a.getValue(), (String)a.getKey(), map)).toList();
    }

    public static void addDecoration(MapItemSavedData data, BlockPos pos, ResourceLocation id, @Nullable Component name) {
        MapDecorationType type = MapDataRegistry.get((ResourceLocation)id);
        if (type != null) {
            MapBlockMarker defaultMarker = type.createEmptyMarker();
            defaultMarker.setPos(pos);
            defaultMarker.setName(name);
            ((ExpandedMapData)data).addCustomMarker(defaultMarker);
        }
    }

    public static void removeCustomDecoration(MapItemSavedData data, int hash) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData d = (ExpandedMapData)data;
            String selected = null;
            for (Map.Entry v : d.getCustomMarkers().entrySet()) {
                CustomMapDecoration decorationFromMarker = ((MapBlockMarker)v.getValue()).createDecorationFromMarker(data);
                if (decorationFromMarker == null || decorationFromMarker.hashCode() != hash) continue;
                selected = (String)v.getKey();
            }
            if (selected == null || !d.removeCustomMarker(selected)) {
                MapAtlasesMod.LOGGER.warn("Tried to delete custom marker but none was found");
            }
        }
    }

    public static boolean maybePlaceMarkerInFront(Player player, ItemStack atlas) {
        MapItemSavedData data;
        BlockHitResult hit = Utils.rayTrace((LivingEntity)player, (boolean)true, (float)0.0f);
        boolean resoult = MapHelper.toggleMarkersAtPos((Level)player.m_9236_(), (BlockPos)hit.m_82425_(), (ItemStack)atlas, (Player)player);
        if (!resoult && (data = MapHelper.getMapData((ItemStack)atlas, (Level)player.m_9236_(), (Player)player)) != null) {
            resoult = data.m_77934_((LevelAccessor)player.m_9236_(), hit.m_82425_());
        }
        return resoult;
    }

    public static void updateMarkers(MapItemSavedData data, Player player, int maxRange) {
        ExpandedMapData d = (ExpandedMapData)data;
        HashMap markers = new HashMap(d.getCustomMarkers());
        if (!markers.isEmpty()) {
            markers.entrySet().removeIf(m -> !((MapBlockMarker)m.getValue()).shouldRefresh());
            ArrayList<String> toRemove = new ArrayList<String>();
            ArrayList<MapBlockMarker> toAdd = new ArrayList<MapBlockMarker>();
            Level level = player.m_9236_();
            for (Map.Entry m2 : markers.entrySet()) {
                MapBlockMarker marker = (MapBlockMarker)m2.getValue();
                BlockPos pos = marker.getPos();
                if (!(pos.m_203193_((Position)player.m_20182_()) < (double)(maxRange * maxRange)) || !level.m_46749_(pos)) continue;
                MapBlockMarker newMarker = marker.getType().getWorldMarkerFromWorld((BlockGetter)level, marker.getPos());
                String id = (String)m2.getKey();
                if (newMarker == null) {
                    toRemove.add(id);
                    continue;
                }
                if (Objects.equals(marker, newMarker)) continue;
                toRemove.add(id);
                toAdd.add(newMarker);
            }
            toRemove.forEach(arg_0 -> ((ExpandedMapData)d).removeCustomMarker(arg_0));
            toAdd.forEach(arg_0 -> ((ExpandedMapData)d).addCustomMarker(arg_0));
        }
    }
}

