/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.lifecycle;

import java.util.TreeSet;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.integration.SupplementariesClientCompat;
import pepjebs.mapatlases.integration.moonlight.ClientMarkers;
import pepjebs.mapatlases.integration.moonlight.EntityRadar;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.networking.C2S2COpenAtlasScreenPacket;
import pepjebs.mapatlases.networking.C2SSelectSlicePacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasesClientEvents {
    public static void onClientTick(Minecraft client, ClientLevel level) {
        long gameTime = level.m_46467_();
        if (MapAtlasesMod.SUPPLEMENTARIES && (gameTime + 27L) % 40L == 0L) {
            SupplementariesClientCompat.onClientTick(level);
        } else if (client.f_91080_ == null && (gameTime + 5L) % 40L == 0L && MapAtlasesClientConfig.automaticSlice.get().booleanValue()) {
            ItemStack atlas = MapAtlasesClient.getCurrentActiveAtlas();
            if (!atlas.m_41619_()) {
                IMapCollection maps = MapAtlasItem.getMaps(atlas, (Level)level);
                Slice s = MapAtlasItem.getSelectedSlice(atlas, (ResourceKey<Level>)level.m_46472_());
                MapAtlasesClientEvents.maybeChangeSlice((Player)client.f_91074_, (Level)level, maps, s, atlas);
            }
        } else if ((gameTime + 7L) % 40L == 0L && MapAtlasesClientConfig.entityRadar.get().booleanValue()) {
            EntityRadar.onClientTick((Player)client.f_91074_);
        }
    }

    public static void onKeyPressed(int key, int code) {
        ItemStack atlas;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91080_ != null) {
            return;
        }
        if (MapAtlasesClient.OPEN_ATLAS_KEYBIND.m_90832_(key, code)) {
            if (client.f_91073_ == null || client.f_91074_ == null) {
                return;
            }
            atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)client.f_91074_);
            if (atlas.m_41720_() instanceof MapAtlasItem) {
                MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2S2COpenAtlasScreenPacket());
            }
        }
        if (MapAtlasesClient.PLACE_PIN_KEYBIND.m_90832_(key, code) && MapAtlasesMod.MOONLIGHT && MapAtlasesClientConfig.moonlightCompat.get().booleanValue()) {
            if (client.f_91073_ == null || client.f_91074_ == null) {
                return;
            }
            atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)client.f_91074_);
            if (atlas.m_41720_() instanceof MapAtlasItem) {
                MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2S2COpenAtlasScreenPacket(null, true));
            }
        }
        if (!(atlas = MapAtlasesClient.getCurrentActiveAtlas()).m_41619_()) {
            Integer newHeight;
            MapType type;
            int current;
            Slice selectedSlice;
            ResourceKey dim;
            IMapCollection maps;
            if (MapAtlasesClient.DECREASE_MINIMAP_ZOOM.m_90832_(key, code)) {
                MapAtlasesClient.decreaseHoodZoom();
            }
            if (MapAtlasesClient.INCREASE_MINIMAP_ZOOM.m_90832_(key, code)) {
                MapAtlasesClient.increaseHoodZoom();
            }
            if (MapAtlasesClient.INCREASE_SLICE.m_90832_(key, code)) {
                maps = MapAtlasItem.getMaps(atlas, (Level)client.f_91073_);
                dim = client.f_91073_.m_46472_();
                selectedSlice = MapAtlasItem.getSelectedSlice(atlas, (ResourceKey<Level>)dim);
                current = selectedSlice.heightOrTop();
                type = selectedSlice.type();
                newHeight = maps.getHeightTree((ResourceKey<Level>)dim, type).ceiling(current + 1);
                MapAtlasesClientEvents.maybeSyncNewSlice(atlas, selectedSlice, newHeight);
            }
            if (MapAtlasesClient.DECREASE_SLICE.m_90832_(key, code)) {
                maps = MapAtlasItem.getMaps(atlas, (Level)client.f_91073_);
                dim = client.f_91073_.m_46472_();
                selectedSlice = MapAtlasItem.getSelectedSlice(atlas, (ResourceKey<Level>)dim);
                current = selectedSlice.heightOrTop();
                type = selectedSlice.type();
                newHeight = maps.getHeightTree((ResourceKey<Level>)dim, type).floor(current - 1);
                MapAtlasesClientEvents.maybeSyncNewSlice(atlas, selectedSlice, newHeight);
            }
        }
    }

    private static void maybeSyncNewSlice(ItemStack atlas, Slice oldSlice, Integer newHeight) {
        Slice newSlice = Slice.of(oldSlice.type(), newHeight, oldSlice.dimension());
        if (!newSlice.equals(oldSlice)) {
            MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2SSelectSlicePacket(newSlice, null));
        }
        MapAtlasItem.setSelectedSlice(atlas, newSlice);
    }

    public static void onLoggedOut() {
        if (MapAtlasesMod.MOONLIGHT) {
            ClientMarkers.saveClientMarkers();
        }
    }

    private static void maybeChangeSlice(Player player, Level level, IMapCollection maps, Slice lastSlice, ItemStack atlas) {
        MapType type = lastSlice.type();
        ResourceKey<Level> dim = lastSlice.dimension();
        Integer newHeight = MapAtlasesClientEvents.getClosestSlice(player, level, maps, dim, type);
        if (newHeight != null) {
            MapAtlasesClientEvents.maybeSyncNewSlice(atlas, lastSlice, newHeight);
        }
    }

    @Nullable
    public static Integer getClosestSlice(Player player, Level level, IMapCollection cap, ResourceKey<Level> dim, MapType type) {
        int worldSurface;
        TreeSet<Integer> heightTree = cap.getHeightTree(dim, type);
        if (heightTree.size() == 1) {
            return null;
        }
        int y = player.m_146904_();
        boolean isAboveHeightMap = y >= (worldSurface = level.m_6924_(Heightmap.Types.OCEAN_FLOOR, player.m_146903_(), player.m_146907_()));
        Integer ceiling = heightTree.ceiling(y);
        if (isAboveHeightMap) {
            return ceiling;
        }
        Integer floor = heightTree.floor(y);
        int aboveDist = ceiling == null ? 0 : ceiling - y;
        int belowDist = floor == null ? 0 : y - floor;
        int max = Math.max(belowDist, aboveDist);
        boolean canGoUp = true;
        boolean canGoDown = true;
        BlockPos.MutableBlockPos pos = player.m_20183_().m_122032_();
        int startY = pos.m_123342_();
        for (int j = 1; j <= max; ++j) {
            if (!canGoUp && !canGoDown) {
                return null;
            }
            if (j == aboveDist) {
                return ceiling;
            }
            if (j == belowDist) {
                return floor;
            }
            if (canGoUp) {
                pos.m_142448_(startY + j);
                if (level.m_8055_((BlockPos)pos).m_284242_((BlockGetter)level, (BlockPos)pos) != MapColor.f_283808_) {
                    canGoUp = false;
                }
            }
            if (!canGoDown) continue;
            pos.m_142448_(startY - j);
            if (level.m_8055_((BlockPos)pos).m_284242_((BlockGetter)level, (BlockPos)pos) == MapColor.f_283808_) continue;
            canGoDown = false;
        }
        return null;
    }
}

