/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.utils;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.CuriosCompat;
import pepjebs.mapatlases.integration.TrinketsCompat;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.networking.S2CMapPacketWrapper;
import pepjebs.mapatlases.utils.ActivationLocation;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.TriState;

public class MapAtlasesAccessUtils {
    public static boolean isValidFilledMap(ItemStack item) {
        return MapType.fromItem(item.m_41720_()) != null && MapItem.m_151131_((ItemStack)item) != null;
    }

    public static boolean isValidEmptyMap(ItemStack item) {
        return MapType.isEmptyMap(item.m_41720_());
    }

    public static MapDataHolder findMapFromItemStack(Level level, ItemStack item) {
        return MapDataHolder.findFromId(level, MapItem.m_151131_((ItemStack)item));
    }

    public static int findMapIntFromString(String id) {
        return Integer.parseInt(id.split("_")[1]);
    }

    public static ItemStack createMapItemStackFromId(int id) {
        ItemStack map = new ItemStack((ItemLike)Items.f_42573_);
        map.m_41784_().m_128405_("map", id);
        return map;
    }

    @NotNull
    private static ItemStack getAtlasFromInventory(Inventory inventory, boolean onlyHotbar) {
        int max = onlyHotbar ? 9 : inventory.m_6643_();
        for (int i = 0; i < max; ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (!itemstack.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static ItemStack getAtlasFromPlayerByConfig(Player player) {
        Inventory inventory = player.m_150109_();
        ActivationLocation loc = MapAtlasesConfig.activationLocation.get();
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
            return itemStack;
        }
        if (loc.hasOffhand() && (itemStack = player.m_21206_()).m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
            return itemStack;
        }
        ItemStack atlasFromCurio = MapAtlasesAccessUtils.getAtlasFromCurioOrTrinket(player);
        if (!atlasFromCurio.m_41619_()) {
            return atlasFromCurio;
        }
        if (loc.scanAll()) {
            itemStack = MapAtlasesAccessUtils.getAtlasFromInventory(inventory, false);
        } else if (loc.hasHotbar()) {
            itemStack = MapAtlasesAccessUtils.getAtlasFromInventory(inventory, true);
        }
        return itemStack;
    }

    public static ItemStack getAtlasFromCurioOrTrinket(Player player) {
        ItemStack itemStack;
        if (MapAtlasesMod.CURIOS && !(itemStack = CuriosCompat.getAtlasInCurio(player)).m_41619_()) {
            return itemStack;
        }
        if (MapAtlasesMod.TRINKETS && !(itemStack = TrinketsCompat.getAtlasInTrinket(player)).m_41619_()) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static int getMapCountToAdd(ItemStack atlas, ItemStack bottomItem, Level level) {
        int amountToAdd = bottomItem.m_41613_();
        int existingMapCount = MapAtlasItem.getMaps(atlas, level).getCount() + MapAtlasItem.getEmptyMaps(atlas);
        amountToAdd *= MapAtlasesConfig.mapEntryValueMultiplier.get().intValue();
        if (MapAtlasItem.getMaxMapCount() != -1 && existingMapCount + bottomItem.m_41613_() > MapAtlasItem.getMaxMapCount()) {
            amountToAdd = MapAtlasItem.getMaxMapCount() - existingMapCount;
        }
        return amountToAdd;
    }

    public static void updateMapDataAndSync(MapDataHolder holder, ServerPlayer player, ItemStack atlas, TriState forceBeingCarried) {
        MapAtlasesMod.setMapInInventoryHack(forceBeingCarried);
        holder.data.m_77918_((Player)player, atlas);
        MapAtlasesAccessUtils.syncMapDataToClient(holder, player);
        MapAtlasesMod.setMapInInventoryHack(TriState.PASS);
    }

    private static void syncMapDataToClient(MapDataHolder holder, ServerPlayer player) {
        Packet p = holder.data.m_164796_(holder.id, (Player)player);
        if (p != null) {
            if (MapAtlasesMod.MOONLIGHT) {
                player.f_8906_.m_9829_(p);
            } else if (p instanceof ClientboundMapItemDataPacket) {
                ClientboundMapItemDataPacket pp = (ClientboundMapItemDataPacket)p;
                MapAtlasesNetworking.CHANNEL.sendToClientPlayer(player, (Message)new S2CMapPacketWrapper(holder.data, pp));
            }
        }
    }
}

