/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.Hashtable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class WallFoundationDataManager {
    public static Hashtable<String, wallFoundationItem> wallFoundationsHashtable = new Hashtable();

    public static wallFoundationItem getWallFoundationInfo(String key) {
        String iKey = key;
        if (wallFoundationsHashtable.isEmpty()) {
            WallFoundationDataManager.wallFoundationsInit();
        }
        wallFoundationItem r = wallFoundationsHashtable.get(iKey);
        return r;
    }

    public static String getWallFoundationHashAsString() {
        Object returnString = "";
        for (String key : wallFoundationsHashtable.keySet()) {
            String wallFoundationType = WallFoundationDataManager.wallFoundationsHashtable.get((Object)key).wallFoundationType;
            String tempString = key + "," + wallFoundationType + ";";
            returnString = (String)returnString + tempString;
        }
        return returnString;
    }

    public static void wallFoundationsInit() {
        int i = 0;
        wallFoundationsHashtable.clear();
        for (i = 0; i < MyConfig.defaultWallFoundationsArray.length; ++i) {
            try {
                String wallFoundationBlockKey;
                String key = wallFoundationBlockKey = MyConfig.defaultWallFoundationsArray[i];
                if (ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(wallFoundationBlockKey))) {
                    wallFoundationsHashtable.put(key, new wallFoundationItem(wallFoundationBlockKey));
                    continue;
                }
                System.out.println("Regrowth Debug: Wall Foundation Block: " + wallFoundationBlockKey + " not in Forge Entity Type Registry.  Mispelled?  Missing semicolon? ");
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Foundation Config (illegal characters, Upper Case or not [a-z0-9_.-] ?): " + MyConfig.defaultWallFoundationsArray[i]);
            }
        }
    }

    public static class wallFoundationItem {
        String wallFoundationType;

        public wallFoundationItem(String wallFoundationType) {
            this.wallFoundationType = wallFoundationType;
        }

        public String getwallFoundationType() {
            return this.wallFoundationType.toLowerCase();
        }
    }
}

