/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.compat.iris.mixin;

import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.compat.iris.IriaAuxIndexHolder;
import com.vicmatskiv.pointblank.compat.iris.IrisAuxShaderProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisShaderPropertiesProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisShaderUtil;
import java.io.IOException;
import java.util.Optional;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.targets.RenderTargets;
import net.minecraft.client.renderer.ShaderInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IrisRenderingPipeline.class})
public abstract class IrisRenderingPipelineMixin
implements IrisAuxShaderProvider {
    @Shadow
    @Final
    private RenderTargets renderTargets;
    @Unique
    private ShaderInstance auxShader;
    @Unique
    private ShaderInstance auxPlainShader;
    @Unique
    private ShaderInstance maskShader;

    @Shadow
    protected abstract void destroyShaders();

    @Shadow
    protected abstract ShaderInstance createShader(String var1, Optional<ProgramSource> var2, ShaderKey var3) throws IOException;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(ProgramSet programSet, CallbackInfo ci) {
        ProgramSource programSource;
        String vsh;
        String fsh;
        if (!Config.advancedIrisIntegrationEnabled) {
            return;
        }
        if (!(programSet instanceof IrisShaderPropertiesProvider)) {
            return;
        }
        IrisShaderPropertiesProvider aux = (IrisShaderPropertiesProvider)programSet;
        Integer auxIndex = IriaAuxIndexHolder.value.get();
        if (auxIndex == null) {
            return;
        }
        try {
            fsh = IrisShaderUtil.getResource("/iris_aux_shader.fsh");
            fsh = IrisShaderUtil.replaceRenderTargets(fsh, auxIndex);
            vsh = IrisShaderUtil.getResource("/iris_aux_shader.vsh");
            programSource = IrisShaderUtil.createProgramSource("pointblank_iris_aux", vsh, fsh, programSet, aux::getPointblankShaderProperties, ShaderKey.TEXTURED.getProgram().getBlendModeOverride());
            this.auxShader = this.createShader(programSource.getName(), Optional.of(programSource), ShaderKey.TEXTURED);
        }
        catch (IOException e) {
            this.destroyShaders();
            throw new RuntimeException(e);
        }
        finally {
            IriaAuxIndexHolder.value.remove();
        }
        try {
            fsh = IrisShaderUtil.getResource("/iris_aux_shader_plain.fsh");
            fsh = IrisShaderUtil.replaceRenderTargets(fsh, auxIndex);
            vsh = IrisShaderUtil.getResource("/iris_aux_shader_plain.vsh");
            programSource = IrisShaderUtil.createProgramSource("pointblank_iris_aux_plain", vsh, fsh, programSet, aux::getPointblankShaderProperties, ShaderKey.TEXTURED.getProgram().getBlendModeOverride());
            this.auxPlainShader = this.createShader(programSource.getName(), Optional.of(programSource), ShaderKey.TEXTURED);
        }
        catch (IOException e) {
            this.destroyShaders();
            throw new RuntimeException(e);
        }
        finally {
            IriaAuxIndexHolder.value.remove();
        }
        try {
            fsh = IrisShaderUtil.getResource("/iris_mask_shader.fsh");
            fsh = IrisShaderUtil.replaceRenderTargets(fsh, auxIndex);
            vsh = IrisShaderUtil.getResource("/iris_mask_shader.vsh");
            programSource = IrisShaderUtil.createProgramSource("pointblank_iris_mask", vsh, fsh, programSet, aux::getPointblankShaderProperties, ShaderKey.TEXTURED_COLOR.getProgram().getBlendModeOverride());
            this.maskShader = this.createShader(programSource.getName(), Optional.of(programSource), ShaderKey.TEXTURED_COLOR);
        }
        catch (IOException e) {
            this.destroyShaders();
            throw new RuntimeException(e);
        }
        finally {
            IriaAuxIndexHolder.value.remove();
        }
    }

    @Override
    @Unique
    public ShaderInstance getPointblankAuxShader() {
        return this.auxShader;
    }

    @Override
    @Unique
    public ShaderInstance getPointblankAuxPlainShader() {
        return this.auxPlainShader;
    }

    @Override
    public ShaderInstance getPointblankMaskShader() {
        return this.maskShader;
    }

    @Override
    public RenderTargets getPointblankRenderTargets() {
        return this.renderTargets;
    }
}

