/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.util;

public enum TimeUnit {
    TICK(50000000L),
    SECOND(1000000000L),
    MILLISECOND(1000000L),
    NANOSECOND(1L);

    private long nanosPerUnit;

    private TimeUnit(long nanosPerUnit) {
        this.nanosPerUnit = nanosPerUnit;
    }

    public long toMillis(long sourceUnits) {
        return (long)this.convert(sourceUnits, MILLISECOND);
    }

    public long toNanos(long sourceUnits) {
        return (long)this.convert(sourceUnits, NANOSECOND);
    }

    public long toTicks(long sourceUnits) {
        return (long)this.convert(sourceUnits, TICK);
    }

    public double toSeconds(long sourceUnits) {
        return this.convert(sourceUnits, SECOND);
    }

    public double convert(long sourceUnits, TimeUnit targetTimeUnit) {
        if (this == targetTimeUnit) {
            return sourceUnits;
        }
        return (double)sourceUnits * (double)this.nanosPerUnit / (double)targetTimeUnit.nanosPerUnit;
    }
}

