/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.scalingmobs.config;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ScalingMobsConfig {
    private static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    private static final ScalingMobsConfig INSTANCE;
    private static final ForgeConfigSpec.DoubleValue mobHealthRate;
    private static final ForgeConfigSpec.DoubleValue mobHealthBase;
    private static final ForgeConfigSpec.DoubleValue maxHealth;
    private static final ForgeConfigSpec.DoubleValue mobDamageRate;
    private static final ForgeConfigSpec.DoubleValue mobDamageBase;
    private static final ForgeConfigSpec.DoubleValue maxDamage;
    private static final ForgeConfigSpec.DoubleValue mobSpeedRate;
    private static final ForgeConfigSpec.DoubleValue mobSpeedBase;
    private static final ForgeConfigSpec.DoubleValue maxSpeed;
    private static final ForgeConfigSpec.DoubleValue mobPiercingRate;
    private static final ForgeConfigSpec.DoubleValue mobPiercingBase;
    private static final ForgeConfigSpec.DoubleValue maxPiercing;
    private static final ForgeConfigSpec.DoubleValue mobDropsRate;
    private static final ForgeConfigSpec.DoubleValue mobDropsBase;
    private static final ForgeConfigSpec.DoubleValue maxDrops;
    public static final ForgeConfigSpec.IntValue mobsStopBurningDay;
    private static final ForgeConfigSpec.BooleanValue exponential;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> mobWhitelist;

    public List<? extends String> getMobWhitelist() {
        return (List)mobWhitelist.get();
    }

    public double getMobHealthRate() {
        return (Double)mobHealthRate.get();
    }

    public double getMobHealthBase() {
        return (Double)mobHealthBase.get();
    }

    public double getMobHealthMax() {
        return (Double)maxHealth.get();
    }

    public double getMobDamageRate() {
        return (Double)mobDamageRate.get();
    }

    public double getMobDamageBase() {
        return (Double)mobDamageBase.get();
    }

    public double getMobDamageMax() {
        return (Double)maxDamage.get();
    }

    public double getPiercingRate() {
        return (Double)mobPiercingRate.get();
    }

    public double getMaxPiercing() {
        return (Double)maxPiercing.get();
    }

    public double getPiercingBase() {
        return (Double)mobPiercingBase.get();
    }

    public double getMobDropsRate() {
        return (Double)mobDropsRate.get();
    }

    public double getMobDropsBase() {
        return (Double)mobDropsBase.get();
    }

    public double getMobDropsMax() {
        return (Double)maxDrops.get();
    }

    public double getMobSpeedRate() {
        return (Double)mobSpeedRate.get();
    }

    public double getMobSpeedBase() {
        return (Double)mobSpeedBase.get();
    }

    public double getMobSpeedMax() {
        return (Double)maxSpeed.get();
    }

    public int getMobsStopBurningDay() {
        return (Integer)mobsStopBurningDay.get();
    }

    public boolean areStatsExponential() {
        return (Boolean)exponential.get();
    }

    public void setMobHealthRate(double rate) {
        mobHealthRate.set((Object)rate);
    }

    public void setMobHealthBase(double base) {
        mobHealthBase.set((Object)base);
    }

    public void setMobHealthMax(double max) {
        maxHealth.set((Object)max);
    }

    public void setMobDamageRate(double rate) {
        mobDamageRate.set((Object)rate);
    }

    public void setMobDamageBase(double base) {
        mobDamageBase.set((Object)base);
    }

    public void setMobDamageMax(double max) {
        maxDamage.set((Object)max);
    }

    public void setMobSpeedRate(double rate) {
        mobSpeedRate.set((Object)rate);
    }

    public void setMobSpeedBase(double base) {
        mobSpeedBase.set((Object)base);
    }

    public void setMobSpeedMax(double max) {
        maxSpeed.set((Object)max);
    }

    public void setPiercingRate(double rate) {
        mobPiercingRate.set((Object)rate);
    }

    public void setPiercingBase(double base) {
        mobPiercingBase.set((Object)base);
    }

    public void setMaxPiercing(double max) {
        maxPiercing.set((Object)max);
    }

    public void setMobDropsRate(double rate) {
        mobDropsRate.set((Object)rate);
    }

    public void setMobDropsBase(double base) {
        mobDropsBase.set((Object)base);
    }

    public void setMobDropsMax(double max) {
        maxDrops.set((Object)max);
    }

    public void setMobsStopBurningDay(int day) {
        mobsStopBurningDay.set((Object)day);
    }

    public void setExponentialStats(boolean log) {
        exponential.set((Object)log);
    }

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "scaling_mobs");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "scaling_mobs/main.toml");
    }

    public static ScalingMobsConfig getInstance() {
        return INSTANCE;
    }

    public void save() {
        SPEC.save();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new ScalingMobsConfig();
        BUILDER.push("Misc");
        exponential = BUILDER.comment("If true, mob stats will increase exponentially").define("Use Exponential Scaling", false);
        mobsStopBurningDay = BUILDER.comment("After this day in the Minecraft world, all hostile mobs will be immune to burning in daylight").defineInRange("Mobs Stop Burning on Day", 7, 0, Integer.MAX_VALUE);
        mobWhitelist = BUILDER.comment("A list of mobs that will scale, even if they're not monsters").defineList("Mob Whitelist", List.of(), element -> element instanceof String);
        BUILDER.pop();
        BUILDER.push("Health");
        mobHealthRate = BUILDER.comment("The decimal amount that hostile mobs' health increase per day").defineInRange("Health Scale Rate", 0.03, 0.0, Double.POSITIVE_INFINITY);
        mobHealthBase = BUILDER.comment("The decimal amount of the mobs' base health in the beginning").defineInRange("Mob Health Base", 1.0, 0.0, Double.POSITIVE_INFINITY);
        maxHealth = BUILDER.comment("The maximum amount that hostile mobs' damage can scale to").defineInRange("Max Scaled Health", Double.POSITIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Damage");
        mobDamageRate = BUILDER.comment("The decimal amount that hostile mobs' damage increase per day").defineInRange("Damage Scale Rate", 0.03, 0.0, Double.POSITIVE_INFINITY);
        mobDamageBase = BUILDER.comment("The decimal amount of the mobs' base damage in the beginning").defineInRange("Mob Damage Base", 1.0, 0.0, Double.POSITIVE_INFINITY);
        maxDamage = BUILDER.comment("The maximum amount that hostile mobs' damage can scale to").defineInRange("Max Scaled Damage", Double.POSITIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Speed");
        mobSpeedRate = BUILDER.comment("The decimal amount that hostile mobs' speed increase per day").defineInRange("Speed Scale Rate", 0.005, 0.0, Double.POSITIVE_INFINITY);
        mobSpeedBase = BUILDER.comment("The decimal amount of the mobs' base speed in the beginning").defineInRange("Mob Speed Base", 1.0, 0.0, Double.POSITIVE_INFINITY);
        maxSpeed = BUILDER.comment("The maximum amount that hostile mobs' speed can scale to").defineInRange("Max Scaled Speed", 1.5, 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Armor Piercing");
        mobPiercingRate = BUILDER.comment("The decimal amount of increase to mobs' damage that ignores armor per day").defineInRange("Armor Piercing Scale Rate", 0.01, 0.0, Double.POSITIVE_INFINITY);
        mobPiercingBase = BUILDER.comment("The decimal amount of mobs' damage that ignores armor in the beginning").defineInRange("Armor Piercing Base", 0.1, 0.0, Double.POSITIVE_INFINITY);
        maxPiercing = BUILDER.comment("The maximum amount of increase to mobs' damage that ignores armor").defineInRange("Max Scaled Armor Piercing", 1.0, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Drops");
        mobDropsRate = BUILDER.comment("The decimal amount of increase to mobs' drops per day").defineInRange("Mob Drops Scaling Rate", 0.02, 0.0, Double.POSITIVE_INFINITY);
        mobDropsBase = BUILDER.comment("The decimal amount of mobs' drops in the beginning").defineInRange("Mob Drops Base", 1.0, 0.0, Double.POSITIVE_INFINITY);
        maxDrops = BUILDER.comment("The maximum amount of increase to mobs' drops").defineInRange("Max Scaled Mob Drops", 400.0, 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

