/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.scalingmobs.events;

import com.momosoftworks.scalingmobs.config.ScalingMobsConfig;
import java.lang.reflect.Method;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MonsterEvents {
    @SubscribeEvent
    public static void onMobSpawn(EntityJoinLevelEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && MonsterEvents.isScalingMob(living = (LivingEntity)entity)) {
            int currentDay = (int)(event.getLevel().m_46468_() / 24000L);
            AttributeInstance maxHealth = living.m_21051_(Attributes.f_22276_);
            AttributeInstance damage = living.m_21051_(Attributes.f_22281_);
            AttributeInstance speed = living.m_21051_(Attributes.f_22279_);
            float currentHealthPercent = living.m_21223_() / living.m_21233_();
            boolean exponential = ScalingMobsConfig.getInstance().areStatsExponential();
            if (damage != null) {
                double damageRate = ScalingMobsConfig.getInstance().getMobDamageRate();
                double damageMax = ScalingMobsConfig.getInstance().getMobDamageMax();
                double baseDamage = ScalingMobsConfig.getInstance().getMobDamageBase();
                damage.m_22118_(new AttributeModifier("ScalingMobs:DamageBase", baseDamage - 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                damage.m_22118_(new AttributeModifier("ScalingMobs:Damage", Math.min(damageMax - 1.0, MonsterEvents.getStatIncrease(damageRate, currentDay, exponential)), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (maxHealth != null) {
                double baseHealth = ScalingMobsConfig.getInstance().getMobHealthBase();
                double healthRate = ScalingMobsConfig.getInstance().getMobHealthRate();
                double healthMax = ScalingMobsConfig.getInstance().getMobHealthMax();
                maxHealth.m_22118_(new AttributeModifier("ScalingMobs:HealthBase", baseHealth - 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                maxHealth.m_22118_(new AttributeModifier("ScalingMobs:Health", Math.min(healthMax - 1.0, MonsterEvents.getStatIncrease(healthRate, currentDay, exponential)), AttributeModifier.Operation.MULTIPLY_TOTAL));
                living.m_21153_(living.m_21233_() * currentHealthPercent);
            }
            if (speed != null) {
                double speedRate = ScalingMobsConfig.getInstance().getMobSpeedRate();
                double speedMax = ScalingMobsConfig.getInstance().getMobSpeedMax();
                double baseSpeed = ScalingMobsConfig.getInstance().getMobSpeedBase();
                speed.m_22118_(new AttributeModifier("ScalingMobs:SpeedBase", baseSpeed - 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
                speed.m_22118_(new AttributeModifier("ScalingMobs:Speed", Math.min(speedMax - 1.0, MonsterEvents.getStatIncrease(speedRate, currentDay, exponential)), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    public static double getMultipliedStat(double stat, double base, double rate, double max, int day, boolean exponential) {
        if (exponential) {
            return Math.min(max, stat * base * Math.pow(1.0 + rate, day));
        }
        return Math.min(max, stat * base * (1.0 + (double)day * rate));
    }

    public static double getStatIncrease(double rate, int day, boolean exponential) {
        if (exponential) {
            return Math.pow(1.0 + rate, day) - 1.0;
        }
        return (double)day * rate;
    }

    @SubscribeEvent
    public static void onMobDealDamage(LivingDamageEvent event) {
        LivingEntity living;
        Entity entity;
        if (event.getEntity() instanceof Player && (entity = event.getSource().m_7639_()) instanceof LivingEntity && MonsterEvents.isScalingMob(living = (LivingEntity)entity)) {
            int currentDay = (int)(event.getEntity().m_9236_().m_46468_() / 24000L);
            double scaleRate = ScalingMobsConfig.getInstance().getPiercingRate();
            double maxPiercing = ScalingMobsConfig.getInstance().getMaxPiercing();
            float damage = event.getAmount();
            float normalDamage = (float)((double)damage * Math.max(0.0, 1.0 - (double)currentDay * Math.min(scaleRate, maxPiercing)));
            float armorPierceDamage = (float)Math.min((double)damage, (double)damage * ((double)currentDay * Math.min(scaleRate, maxPiercing)));
            event.setAmount(normalDamage);
            event.getEntity().m_21153_(event.getEntity().m_21223_() - armorPierceDamage);
        }
    }

    @SubscribeEvent
    public static void onMobDrop(LivingDropsEvent event) {
        if (MonsterEvents.isScalingMob(event.getEntity())) {
            double dropRate = ScalingMobsConfig.getInstance().getMobDropsRate();
            double dropBase = ScalingMobsConfig.getInstance().getMobDropsBase();
            double maxDrops = ScalingMobsConfig.getInstance().getMobDropsMax();
            int currentDay = (int)(event.getEntity().m_9236_().m_46468_() / 24000L);
            double multiplier = MonsterEvents.getMultipliedStat(1 + event.getLootingLevel(), dropBase, dropRate, maxDrops, currentDay, false);
            int repetitions = (int)Math.floor(multiplier);
            double remainder = multiplier - (double)repetitions;
            if (Math.random() < remainder) {
                ++repetitions;
            }
            try {
                Method dropLoot = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_213354_a", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
                Method dropSpecialItems = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_213333_a", (Class[])new Class[]{DamageSource.class, Integer.TYPE, Boolean.TYPE});
                for (int i = 0; i < repetitions; ++i) {
                    dropLoot.invoke((Object)event.getEntity(), event.getSource(), event.isRecentlyHit());
                    dropSpecialItems.invoke((Object)event.getEntity(), event.getSource(), event.getLootingLevel(), event.isRecentlyHit());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isScalingMob(LivingEntity entity) {
        return entity instanceof Monster || ScalingMobsConfig.getInstance().getMobWhitelist().contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }
}

