/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TurtleEggBlock;

public class ObjectToPermissionMap {
    private static final Map<Block, ResourceLocation> blockToPermission = new HashMap<Block, ResourceLocation>();
    private static final Map<Predicate<Block>, Supplier<ResourceLocation>> blockPermissionBuilder = new HashMap<Predicate<Block>, Supplier<ResourceLocation>>();
    private static final Map<Item, ResourceLocation> itemToPermission = new HashMap<Item, ResourceLocation>();
    private static final Map<Predicate<Item>, Supplier<ResourceLocation>> itemPermissionBuilder = new HashMap<Predicate<Item>, Supplier<ResourceLocation>>();
    private static final Map<EntityType<?>, ResourceLocation> entityToPermission = new HashMap();
    private static final Map<Block, ResourceLocation> leftClickBlockPermission = new HashMap<Block, ResourceLocation>();

    public static void reload(MinecraftServer server) {
        blockToPermission.clear();
        itemToPermission.clear();
        entityToPermission.clear();
        leftClickBlockPermission.clear();
        for (Block block : CrossPlatformStuff.INSTANCE.registryBlocks().getIterator()) {
            blockPermissionBuilder.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> blockToPermission.put(block, (ResourceLocation)sub.get()));
        }
        for (Item item : CrossPlatformStuff.INSTANCE.registryItems().getIterator()) {
            itemPermissionBuilder.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(item)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> itemToPermission.put(item, (ResourceLocation)sub.get()));
        }
        ObjectToPermissionMap.process(ConfigHandler.CONFIG.itemPermission, BuiltInRegistries.f_257033_, itemToPermission);
        ObjectToPermissionMap.process(ConfigHandler.CONFIG.blockPermission, BuiltInRegistries.f_256975_, blockToPermission);
        ObjectToPermissionMap.process(ConfigHandler.CONFIG.entityPermission, BuiltInRegistries.f_256780_, entityToPermission);
        ObjectToPermissionMap.process(ConfigHandler.CONFIG.leftClickBlockPermission, BuiltInRegistries.f_256975_, leftClickBlockPermission);
    }

    private static <T> void process(List<String> list, Registry<T> registry, Map<T, ResourceLocation> map) {
        for (String s : list) {
            String[] sub = s.split("-");
            boolean remove = sub[1].equals("NONE");
            if (s.startsWith("@")) {
                ResourceLocation res = new ResourceLocation(sub[0].substring(1));
                ObjectToPermissionMap.processTag(res, registry, b -> {
                    if (remove) {
                        map.remove(b);
                    } else {
                        ResourceLocation id = BuiltinPermission.tryLegacy(sub[1]);
                        ClaimPermission perm = PermissionManager.INSTANCE.get(id);
                        if (perm == null) {
                            Flan.error("Configuring custom permission map: No such permission for {}", sub[1]);
                        }
                        map.put(b, id);
                    }
                });
                continue;
            }
            if (remove) {
                map.remove(registry.m_7745_(new ResourceLocation(sub[0])));
                continue;
            }
            ResourceLocation id = BuiltinPermission.tryLegacy(sub[1]);
            ClaimPermission perm = PermissionManager.INSTANCE.get(id);
            if (perm == null) {
                Flan.error("Configuring custom permission map: No such permission for {} {}", sub[1], id);
            }
            map.put(registry.m_7745_(new ResourceLocation(sub[0])), id);
        }
    }

    private static <T> void processTag(ResourceLocation tag, Registry<T> registry, Consumer<T> action) {
        Optional<HolderSet.Named> t = registry.m_203612_().filter(p -> ((TagKey)p.getFirst()).f_203868_().equals((Object)tag)).map(Pair::getSecond).findFirst();
        t.ifPresent(holders -> holders.forEach(i -> action.accept(i.m_203334_())));
    }

    public static ResourceLocation getFromBlock(Block block) {
        return blockToPermission.get(block);
    }

    public static ResourceLocation getFromItem(Item item) {
        return itemToPermission.get(item);
    }

    public static ResourceLocation getFromEntity(EntityType<?> entity) {
        return entityToPermission.get(entity);
    }

    public static ResourceLocation getForLeftClickBlock(Block block) {
        return leftClickBlockPermission.get(block);
    }

    public static void registerBlockPredicateMap(Predicate<Block> pred, Supplier<ResourceLocation> perm) {
        blockPermissionBuilder.put(pred, perm);
    }

    public static void registerItemPredicateMap(Predicate<Item> pred, Supplier<ResourceLocation> perm) {
        itemPermissionBuilder.put(pred, perm);
    }

    static {
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof AnvilBlock, () -> BuiltinPermission.ANVIL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BedBlock, () -> BuiltinPermission.BED);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BeaconBlock, () -> BuiltinPermission.BEACON);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof DoorBlock, () -> BuiltinPermission.DOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof FenceGateBlock, () -> BuiltinPermission.FENCEGATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TrapDoorBlock, () -> BuiltinPermission.TRAPDOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof LeverBlock || block instanceof ButtonBlock, () -> BuiltinPermission.BUTTONLEVER);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof NoteBlock, () -> BuiltinPermission.NOTEBLOCK);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof DiodeBlock || block instanceof RedStoneWireBlock || block instanceof DaylightDetectorBlock, () -> BuiltinPermission.REDSTONE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof JukeboxBlock, () -> BuiltinPermission.JUKEBOX);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BasePressurePlateBlock, () -> BuiltinPermission.PRESSUREPLATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof NetherPortalBlock, () -> BuiltinPermission.PORTAL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TurtleEggBlock || block instanceof FarmBlock, () -> BuiltinPermission.TRAMPLE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TargetBlock, () -> BuiltinPermission.TARGETBLOCK);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BellBlock || block instanceof CampfireBlock || block instanceof TntBlock || block instanceof ChorusFlowerBlock, () -> BuiltinPermission.PROJECTILES);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof EnderChestBlock, () -> BuiltinPermission.ENDERCHEST);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof EnchantmentTableBlock, () -> BuiltinPermission.ENCHANTMENTTABLE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BrushableBlock, () -> BuiltinPermission.ARCHAEOLOGY);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof EnderpearlItem, () -> BuiltinPermission.ENDERPEARL);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BucketItem, () -> BuiltinPermission.BUCKET);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.f_42729_, () -> BuiltinPermission.ENDCRYSTALPLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.f_42730_, () -> BuiltinPermission.CHORUSFRUIT);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.f_42094_, () -> BuiltinPermission.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BoneMealItem, () -> BuiltinPermission.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof RecordItem, () -> BuiltinPermission.JUKEBOX);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BoatItem, () -> BuiltinPermission.BOAT);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BrushItem, () -> BuiltinPermission.ARCHAEOLOGY);
    }
}

