/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.AllowedRegistryList;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.ClaimPermissionCheck;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import io.github.flemmli97.flan.player.LogoutTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.ClaimDisplayBox;
import io.github.flemmli97.flan.player.display.DisplayBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Claim
implements IPermissionContainer {
    private boolean dirty;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    private int minY;
    private UUID owner;
    private UUID claimID;
    private String claimName = "";
    private BlockPos homePos;
    private final Map<ResourceLocation, Boolean> globalPerm = new HashMap<ResourceLocation, Boolean>();
    private final Map<String, Map<ResourceLocation, Boolean>> permissions = new HashMap<String, Map<ResourceLocation, Boolean>>();
    private final Map<UUID, String> playersGroups = new HashMap<UUID, String>();
    private final Set<UUID> fakePlayers = new HashSet<UUID>();
    private final List<Claim> subClaims = new ArrayList<Claim>();
    private UUID parent;
    private Claim parentClaim;
    private boolean removed;
    private final ServerLevel world;
    private final Map<MobEffect, Integer> potions = new HashMap<MobEffect, Integer>();
    public final AllowedRegistryList<Item> allowedItems = AllowedRegistryList.ofItemLike(BuiltInRegistries.f_257033_, this);
    public final AllowedRegistryList<Block> allowedUseBlocks = AllowedRegistryList.ofItemLike(BuiltInRegistries.f_256975_, this);
    public final AllowedRegistryList<Block> allowedBreakBlocks = AllowedRegistryList.ofItemLike(BuiltInRegistries.f_256975_, this);
    public final AllowedRegistryList<EntityType<?>> allowedEntityAttack = new AllowedRegistryList((Registry<EntityType<?>>)BuiltInRegistries.f_256780_, this, AllowedRegistryList.ENTITY_AS_ITEM);
    public final AllowedRegistryList<EntityType<?>> allowedEntityUse = new AllowedRegistryList((Registry<EntityType<?>>)BuiltInRegistries.f_256780_, this, AllowedRegistryList.ENTITY_AS_ITEM);
    public Component enterTitle;
    public Component enterSubtitle;
    public Component leaveTitle;
    public Component leaveSubtitle;

    private Claim(ServerLevel world) {
        this.world = world;
    }

    public Claim(BlockPos pos1, BlockPos pos2, ServerPlayer creator) {
        this(pos1.m_123341_(), pos2.m_123341_(), pos1.m_123343_(), pos2.m_123343_(), Math.min(pos1.m_123342_(), pos2.m_123342_()), creator.m_20148_(), creator.m_284548_(), PlayerClaimData.get(creator).playerDefaultGroups().isEmpty());
        PlayerClaimData.get(creator).playerDefaultGroups().forEach((s, m) -> m.forEach((perm, bool) -> this.editPerms(null, (String)s, (ResourceLocation)perm, bool != false ? 1 : 0, true)));
        Collection<Claim> all = ClaimStorage.get(creator.m_284548_()).allClaimsFromPlayer(creator.m_20148_());
        Object name = String.format(ConfigHandler.CONFIG.defaultClaimName, "%1$s", all.size());
        if (!((String)name).isEmpty()) {
            for (Claim claim : all) {
                String numbered = claim.claimName.replace((String)name + " #", "");
                if (numbered.isEmpty()) continue;
                name = (String)name + " #" + all.size();
                break;
            }
        }
        this.claimName = name;
        if (!ConfigHandler.CONFIG.defaultEnterMessage.isEmpty()) {
            this.enterTitle = Component.m_237113_((String)String.format(ConfigHandler.CONFIG.defaultEnterMessage, this.claimName));
        }
        if (!ConfigHandler.CONFIG.defaultLeaveMessage.isEmpty()) {
            this.leaveTitle = Component.m_237113_((String)String.format(ConfigHandler.CONFIG.defaultLeaveMessage, this.claimName));
        }
    }

    public Claim(BlockPos pos1, BlockPos pos2, UUID creator, ServerLevel world) {
        this(pos1.m_123341_(), pos2.m_123341_(), pos1.m_123343_(), pos2.m_123343_(), Math.min(pos1.m_123342_(), pos2.m_123342_()), creator, world);
    }

    public Claim(int x1, int x2, int z1, int z2, int minY, UUID creator, ServerLevel world) {
        this(x1, x2, z1, z2, minY, creator, world, true);
    }

    public Claim(int x1, int x2, int z1, int z2, int minY, UUID creator, ServerLevel world, boolean setDefaultGroups) {
        this.minX = Math.min(x1, x2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxZ = Math.max(z1, z2);
        this.minY = Math.max(world.m_141937_(), minY);
        this.owner = creator;
        this.world = world;
        this.homePos = this.getInitCenterPos();
        this.setDirty(true);
        PermissionManager.INSTANCE.getAll().stream().filter(perm -> perm.defaultVal).forEach(perm -> this.globalPerm.put(perm.getId(), true));
        ConfigHandler.CONFIG.getGloballyDefinedVals(world).forEach(e -> this.globalPerm.put((ResourceLocation)e.getKey(), ((Config.GlobalType)((Object)((Object)e.getValue()))).getValue()));
        if (setDefaultGroups) {
            ConfigHandler.CONFIG.defaultGroups.forEach((s, m) -> m.forEach((perm, bool) -> this.editPerms(null, (String)s, (ResourceLocation)perm, bool != false ? 1 : 0, true)));
        }
    }

    public static Claim fromJson(JsonObject obj, UUID owner, ServerLevel world) {
        Claim claim = new Claim(world);
        claim.readJson(obj, owner);
        ClaimUpdater.updateClaim(claim);
        return claim;
    }

    private BlockPos getInitCenterPos() {
        BlockPos center = BlockPos.m_274561_((double)((double)this.minX + (double)(this.maxX - this.minX) * 0.5), (double)0.0, (double)((double)this.minZ + (double)(this.maxZ - this.minZ) * 0.5));
        int y = !this.world.m_7232_(center.m_123341_() >> 4, center.m_123343_() >> 4) ? this.minY + 1 : this.world.m_6325_(center.m_123341_() >> 4, center.m_123343_() >> 4).m_5885_(Heightmap.Types.MOTION_BLOCKING, center.m_123341_() & 0xF, center.m_123343_() & 0xF);
        return new BlockPos(center.m_123341_(), y + 1, center.m_123343_());
    }

    private BlockPos getDefaultCenterPos() {
        BlockPos center = BlockPos.m_274561_((double)((double)this.minX + (double)(this.maxX - this.minX) * 0.5), (double)0.0, (double)((double)this.minZ + (double)(this.maxZ - this.minZ) * 0.5));
        return new BlockPos(center.m_123341_(), 255, center.m_123343_());
    }

    public void setClaimID(UUID uuid) {
        this.claimID = uuid;
        this.setDirty(true);
    }

    public void extendDownwards(BlockPos pos) {
        this.minY = pos.m_123342_();
        this.setDirty(true);
        WebmapCalls.onExtendDownwards(this);
    }

    public UUID getClaimID() {
        return this.claimID;
    }

    public String getClaimName() {
        String ownerName = this.isAdminClaim() ? "Admin" : this.world.m_7654_().m_129927_().m_11002_(this.owner).map(GameProfile::getName).orElse("<UNKNOWN>");
        return String.format(this.claimName, ownerName);
    }

    public void setClaimName(String name) {
        this.claimName = name;
        this.setDirty(true);
        WebmapCalls.changeClaimName(this);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Optional<ServerPlayer> getOwnerPlayer() {
        if (this.getOwner() != null) {
            return Optional.ofNullable(this.world.m_7654_().m_6846_().m_11259_(this.getOwner()));
        }
        return Optional.empty();
    }

    public ServerLevel getWorld() {
        return this.world;
    }

    public Claim parentClaim() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentClaim == null) {
            ClaimStorage storage = ClaimStorage.get(this.world);
            this.parentClaim = storage.getFromUUID(this.parent);
        }
        return this.parentClaim;
    }

    public void copySizes(Claim claim) {
        this.minX = claim.minX;
        this.maxX = claim.maxX;
        this.minZ = claim.minZ;
        this.maxZ = claim.maxZ;
        this.minY = claim.minY;
        this.removed = false;
        this.setDirty(true);
    }

    public void toggleAdminClaim(ServerPlayer player, boolean flag) {
        if (!flag) {
            this.transferOwner(player.m_20148_());
        } else {
            this.owner = null;
            this.subClaims.forEach(claim -> {
                claim.owner = null;
            });
        }
        this.setDirty(true);
    }

    public boolean isAdminClaim() {
        return this.owner == null;
    }

    public void transferOwner(UUID player) {
        this.owner = player;
        this.subClaims.forEach(claim -> {
            claim.owner = player;
        });
        this.setDirty(true);
    }

    public int getPlane() {
        return (this.maxX - this.minX + 1) * (this.maxZ - this.minZ + 1);
    }

    public int[] getDimensions() {
        return new int[]{this.minX, this.maxX, this.minZ, this.maxZ, this.minY};
    }

    public int getMaxY() {
        return this.getWorld().m_151558_();
    }

    public boolean insideClaim(BlockPos pos) {
        return this.minX <= pos.m_123341_() && this.maxX >= pos.m_123341_() && this.minZ <= pos.m_123343_() && this.maxZ >= pos.m_123343_() && this.minY <= pos.m_123342_();
    }

    public boolean intersects(Claim other) {
        return this.minX <= other.maxX && this.maxX >= other.minX && this.minZ <= other.maxZ && this.maxZ >= other.minZ;
    }

    public boolean intersects(AABB box) {
        return (double)this.minX < box.f_82291_ && (double)(this.maxX + 1) > box.f_82288_ && (double)this.minZ < box.f_82293_ && (double)(this.maxZ + 1) > box.f_82290_ && box.f_82292_ >= (double)this.minY;
    }

    public boolean isCorner(BlockPos pos) {
        return pos.m_123341_() == this.minX && pos.m_123343_() == this.minZ || pos.m_123341_() == this.minX && pos.m_123343_() == this.maxZ || pos.m_123341_() == this.maxX && pos.m_123343_() == this.minZ || pos.m_123341_() == this.maxX && pos.m_123343_() == this.maxZ;
    }

    public void remove() {
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean canInteract(ServerPlayer player, ResourceLocation perm, BlockPos pos, boolean message) {
        Map<ResourceLocation, Boolean> map;
        InteractionResult res;
        boolean realPlayer = player != null && player.getClass().equals(ServerPlayer.class);
        boolean bl = message = message && realPlayer && player.f_8906_ != null;
        if (player != null && !realPlayer) {
            if (this.fakePlayers.contains(player.m_20148_())) {
                return true;
            }
            if (!player.m_20148_().equals(this.owner) && !this.playersGroups.containsKey(player.m_20148_())) {
                perm = BuiltinPermission.FAKEPLAYER;
            }
        }
        if ((res = ClaimPermissionCheck.INSTANCE.check(player, perm, pos)) != InteractionResult.PASS) {
            return res != InteractionResult.FAIL;
        }
        if (!this.isAdminClaim()) {
            Object global = ConfigHandler.CONFIG.getGlobal(this.world, perm);
            if (!global.canModify()) {
                if (global.getValue() || player != null && this.isAdminIgnore(player)) {
                    return true;
                }
                if (message) {
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionSimple"), ChatFormatting.DARK_RED), true);
                }
                if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
                    this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
                }
                return false;
            }
            if (ConfigHandler.CONFIG.offlineProtectActivation != -1 && (LogoutTracker.getInstance(this.world.m_7654_()).justLoggedOut(this.getOwner()) || this.getOwnerPlayer().isPresent())) {
                return global == Config.GlobalType.NONE || global.getValue();
            }
        }
        if (PermissionManager.INSTANCE.isGlobalPermission(perm)) {
            for (Claim claim : this.subClaims) {
                if (!claim.insideClaim(pos)) continue;
                return claim.canInteract(player, perm, pos, message);
            }
            if (this.hasPerm(perm)) {
                return true;
            }
            if (message) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionSimple"), ChatFormatting.DARK_RED), true);
            }
            if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
                this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
            }
            return false;
        }
        if (this.isAdminIgnore(player) || player.m_20148_().equals(this.owner)) {
            return true;
        }
        if (!perm.equals((Object)BuiltinPermission.EDITCLAIM) && !perm.equals((Object)BuiltinPermission.EDITPERMS)) {
            for (Claim claim : this.subClaims) {
                if (!claim.insideClaim(pos)) continue;
                return claim.canInteract(player, perm, pos, message);
            }
        }
        if (this.playersGroups.containsKey(player.m_20148_()) && (map = this.permissions.get(this.playersGroups.get(player.m_20148_()))) != null && map.containsKey(perm)) {
            if (map.get(perm).booleanValue()) {
                return true;
            }
            if (message) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionSimple"), ChatFormatting.DARK_RED), true);
            }
            if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
                this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
            }
            return false;
        }
        if (this.hasPerm(perm)) {
            return true;
        }
        if (message) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionSimple"), ChatFormatting.DARK_RED), true);
        }
        if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
            this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
        }
        return false;
    }

    private boolean isAdminIgnore(ServerPlayer player) {
        if (player == null) {
            return true;
        }
        if (PlayerClaimData.get(player).isAdminIgnoreClaim()) {
            return !this.isAdminClaim() || PermissionNodeHandler.INSTANCE.perm(player, "flan.command.bypass.admin.mode", true);
        }
        return this.isAdminClaim() && player.m_20310_(2);
    }

    public int permEnabled(ResourceLocation perm) {
        return !this.globalPerm.containsKey(perm) ? -1 : (this.globalPerm.get(perm) != false ? 1 : 0);
    }

    private boolean hasPerm(ResourceLocation perm) {
        if (this.parentClaim() == null) {
            return this.permEnabled(perm) == 1;
        }
        if (this.permEnabled(perm) == -1) {
            return this.parentClaim().permEnabled(perm) == 1;
        }
        return this.permEnabled(perm) == 1;
    }

    private UUID generateUUID() {
        UUID uuid = UUID.randomUUID();
        for (Claim claim : this.subClaims) {
            if (!claim.claimID.equals(uuid)) continue;
            return this.generateUUID();
        }
        return uuid;
    }

    public Set<Claim> tryCreateSubClaim(BlockPos pos1, BlockPos pos2) {
        if (this.parentClaim() != null) {
            return Set.of(this.parentClaim());
        }
        Claim sub = new Claim(pos1, new BlockPos(pos2.m_123341_(), 0, pos2.m_123343_()), this.owner, this.world);
        sub.setClaimID(this.generateUUID());
        HashSet<Claim> conflicts = new HashSet<Claim>();
        for (Claim other : this.subClaims) {
            if (!sub.intersects(other)) continue;
            conflicts.add(other);
        }
        if (conflicts.isEmpty()) {
            sub.parent = this.claimID;
            sub.parentClaim = this;
            this.subClaims.add(sub);
            sub.permissions.clear();
            sub.permissions.putAll(this.permissions);
            sub.playersGroups.clear();
            sub.playersGroups.putAll(this.playersGroups);
            sub.potions.clear();
            sub.potions.putAll(this.potions);
            this.setDirty(true);
        }
        return conflicts;
    }

    public void addSubClaimGriefprevention(Claim claim) {
        claim.setClaimID(this.generateUUID());
        claim.parent = this.claimID;
        claim.parentClaim = this;
        this.subClaims.add(claim);
        this.setDirty(true);
    }

    public Claim getSubClaim(BlockPos pos) {
        for (Claim claim : this.subClaims) {
            if (!claim.insideClaim(pos)) continue;
            return claim;
        }
        return null;
    }

    public boolean deleteSubClaim(Claim claim) {
        claim.remove();
        this.setDirty(true);
        return this.subClaims.remove(claim);
    }

    public List<Claim> getAllSubclaims() {
        return ImmutableList.copyOf(this.subClaims);
    }

    public Set<Claim> resizeSubclaim(Claim claim, BlockPos from, BlockPos to) {
        int[] dims = claim.getDimensions();
        BlockPos opposite = new BlockPos(dims[0] == from.m_123341_() ? dims[1] : dims[0], dims[4], dims[2] == from.m_123343_() ? dims[3] : dims[2]);
        Claim newClaim = new Claim(opposite, to, claim.claimID, this.world);
        HashSet<Claim> conflicts = new HashSet<Claim>();
        for (Claim other : this.subClaims) {
            if (claim.equals(other) || !newClaim.intersects(other)) continue;
            conflicts.add(other);
        }
        if (conflicts.isEmpty()) {
            claim.copySizes(newClaim);
            this.setDirty(true);
        }
        return conflicts;
    }

    public boolean setPlayerGroup(UUID player, String group, boolean force) {
        if (player.equals(this.owner)) {
            return false;
        }
        if (group == null) {
            this.playersGroups.remove(player);
            this.setDirty(true);
            return true;
        }
        if (!this.playersGroups.containsKey(player) || force) {
            this.playersGroups.put(player, group);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public boolean modifyFakePlayerUUID(UUID uuid, boolean remove) {
        if (remove) {
            return this.fakePlayers.remove(uuid);
        }
        return this.fakePlayers.add(uuid);
    }

    public List<String> playersFromGroup(MinecraftServer server, String group) {
        ArrayList l = new ArrayList();
        this.playersGroups.forEach((uuid, g) -> {
            if (g.equals(group)) {
                l.add(uuid);
            }
        });
        ArrayList<String> names = new ArrayList<String>();
        l.forEach(uuid -> server.m_129927_().m_11002_(uuid).ifPresent(prof -> names.add(prof.getName())));
        names.sort(null);
        return names;
    }

    public List<String> getAllowedFakePlayerUUID() {
        return this.fakePlayers.stream().map(UUID::toString).toList();
    }

    public boolean editGlobalPerms(ServerPlayer player, ResourceLocation toggle, int mode) {
        if (player != null && !this.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_()) || !this.isAdminClaim() && ConfigHandler.CONFIG.globallyDefined(this.world, toggle)) {
            return false;
        }
        if (mode > 1) {
            mode = -1;
        }
        if (mode == -1) {
            this.globalPerm.remove(toggle);
        } else {
            this.globalPerm.put(toggle, mode == 1);
        }
        this.setDirty(true);
        return true;
    }

    public boolean editPerms(ServerPlayer player, String group, ResourceLocation perm, int mode) {
        return this.editPerms(player, group, perm, mode, false);
    }

    public boolean editPerms(ServerPlayer player, String group, ResourceLocation perm, int mode, boolean alwaysCan) {
        if (PermissionManager.INSTANCE.isGlobalPermission(perm) || !this.isAdminClaim() && ConfigHandler.CONFIG.globallyDefined(this.world, perm)) {
            return false;
        }
        if (alwaysCan || this.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_())) {
            boolean has;
            HashMap<ResourceLocation, Boolean> perms;
            if (mode > 1) {
                mode = -1;
            }
            Map<ResourceLocation, Boolean> map = perms = (has = this.permissions.containsKey(group)) ? this.permissions.get(group) : new HashMap<ResourceLocation, Boolean>();
            if (mode == -1) {
                perms.remove(perm);
            } else {
                perms.put(perm, mode == 1);
            }
            if (!has) {
                this.permissions.put(group, perms);
            }
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public boolean removePermGroup(ServerPlayer player, String group) {
        if (this.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_())) {
            this.permissions.remove(group);
            ArrayList toRemove = new ArrayList();
            this.playersGroups.forEach((uuid, g) -> {
                if (g.equals(group)) {
                    toRemove.add(uuid);
                }
            });
            toRemove.forEach(this.playersGroups::remove);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public int groupHasPerm(String rank, ResourceLocation perm) {
        if (!this.permissions.containsKey(rank) || !this.permissions.get(rank).containsKey(perm)) {
            return -1;
        }
        return this.permissions.get(rank).get(perm) != false ? 1 : 0;
    }

    public List<String> groups() {
        ArrayList<String> l = new ArrayList<String>(this.permissions.keySet());
        l.sort(null);
        return l;
    }

    public boolean setHomePos(BlockPos homePos) {
        if (this.insideClaim(homePos)) {
            this.homePos = homePos;
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public void addPotion(MobEffect effect, int amplifier) {
        this.potions.put(effect, amplifier);
        this.setDirty(true);
    }

    public void removePotion(MobEffect effect) {
        this.potions.remove(effect);
        this.setDirty(true);
    }

    public Map<MobEffect, Integer> getPotions() {
        return this.potions;
    }

    public void applyEffects(ServerPlayer player) {
        if (player.m_9236_().m_46467_() % 80L == 0L) {
            this.potions.forEach((effect, amp) -> player.m_147215_(new MobEffectInstance(effect, effect == MobEffects.f_19611_ ? 400 : 200, amp - 1, true, false), null));
        }
    }

    public BlockPos getHomePos() {
        return this.homePos;
    }

    public void setEnterTitle(Component title, Component sub) {
        if (title != null && title.getString().equals("$empty")) {
            title = null;
        }
        if (sub != null && sub.getString().equals("$empty")) {
            sub = null;
        }
        this.enterTitle = title;
        this.enterSubtitle = sub;
        this.setDirty(true);
    }

    public void setLeaveTitle(Component title, Component sub) {
        if (title != null && title.getString().equals("$empty")) {
            title = null;
        }
        if (sub != null && sub.getString().equals("$empty")) {
            sub = null;
        }
        this.leaveTitle = title;
        this.leaveSubtitle = sub;
        this.setDirty(true);
    }

    private void displayTitleMessage(ServerPlayer player, @Nullable Component title, @Nullable Component subtitle) {
        if ((title = this.transformForDisplay(title)) == null) {
            return;
        }
        subtitle = this.transformForDisplay(subtitle);
        if (ConfigHandler.CONFIG.claimDisplayActionBar) {
            if (subtitle != null) {
                MutableComponent message = title.m_6881_().m_7220_((Component)Component.m_237113_((String)" | ").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))).m_7220_(subtitle);
                player.m_5661_((Component)message, true);
                return;
            }
            player.m_5661_(title, true);
            return;
        }
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(title));
        if (subtitle != null) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket(subtitle));
        }
    }

    @Nullable
    private Component transformForDisplay(Component component) {
        MutableComponent res;
        if (component == null) {
            return null;
        }
        String claimName = this.getClaimName();
        ComponentContents componentContents = component.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents trans = (TranslatableContents)componentContents;
            res = Component.m_237110_((String)trans.m_237508_(), (Object[])new Object[]{this.isAdminClaim() ? "Admin" : this.world.m_7654_().m_129927_().m_11002_(this.owner).map(GameProfile::getName).orElse("<UNKNOWN>"), claimName});
        } else {
            componentContents = component.m_214077_();
            if (componentContents instanceof LiteralContents) {
                LiteralContents comp = (LiteralContents)componentContents;
                res = Component.m_237110_((String)comp.f_237368_(), (Object[])new Object[]{this.isAdminClaim() ? "Admin" : this.world.m_7654_().m_129927_().m_11002_(this.owner).map(GameProfile::getName).orElse("<UNKNOWN>"), claimName});
            } else {
                res = component.m_6879_();
            }
        }
        res.m_7360_().addAll(component.m_7360_().stream().map(this::transformForDisplay).toList());
        res.m_6270_(component.m_7383_());
        return res;
    }

    public void displayEnterTitle(ServerPlayer player) {
        this.displayTitleMessage(player, this.enterTitle, this.enterSubtitle);
    }

    public void displayLeaveTitle(ServerPlayer player) {
        this.displayTitleMessage(player, this.leaveTitle, this.leaveSubtitle);
    }

    public boolean canUseItem(ItemStack stack) {
        return this.allowedItems.matches(arg_0 -> ((ItemStack)stack).m_150930_(arg_0), arg_0 -> ((ItemStack)stack).m_204117_(arg_0));
    }

    public boolean canUseBlockItem(BlockState state) {
        return this.allowedUseBlocks.matches(arg_0 -> ((BlockState)state).m_60713_(arg_0), arg_0 -> ((BlockState)state).m_204336_(arg_0));
    }

    public boolean canBreakBlockItem(BlockState state) {
        return this.allowedBreakBlocks.matches(arg_0 -> ((BlockState)state).m_60713_(arg_0), arg_0 -> ((BlockState)state).m_204336_(arg_0));
    }

    public boolean canAttackEntity(Entity entity) {
        return this.allowedEntityAttack.matches(type -> entity.m_6095_() == type, tag -> entity.m_6095_().m_204039_(tag));
    }

    public boolean canInteractWithEntity(Entity entity) {
        return this.allowedEntityUse.matches(type -> entity.m_6095_() == type, tag -> entity.m_6095_().m_204039_(tag));
    }

    public void setDirty(boolean flag) {
        if (this.parentClaim() != null) {
            this.parentClaim().setDirty(flag);
        } else {
            this.dirty = flag;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void readJson(JsonObject obj, UUID uuid) {
        try {
            this.claimID = UUID.fromString(obj.get("ID").getAsString());
            this.claimName = ConfigHandler.fromJson(obj, "Name", "");
            JsonArray pos = obj.getAsJsonArray("PosxXzZY");
            this.minX = pos.get(0).getAsInt();
            this.maxX = pos.get(1).getAsInt();
            this.minZ = pos.get(2).getAsInt();
            this.maxZ = pos.get(3).getAsInt();
            this.minY = pos.get(4).getAsInt();
            JsonArray home = ConfigHandler.arryFromJson(obj, "Home");
            this.homePos = home.size() != 3 ? this.getDefaultCenterPos() : new BlockPos(home.get(0).getAsInt(), home.get(1).getAsInt(), home.get(2).getAsInt());
            String message = ConfigHandler.fromJson(obj, "EnterTitle", "");
            this.enterTitle = !message.isEmpty() ? Component.Serializer.m_130701_((String)message) : null;
            message = ConfigHandler.fromJson(obj, "EnterSubtitle", "");
            this.enterSubtitle = !message.isEmpty() ? Component.Serializer.m_130701_((String)message) : null;
            message = ConfigHandler.fromJson(obj, "LeaveTitle", "");
            this.leaveTitle = !message.isEmpty() ? Component.Serializer.m_130701_((String)message) : null;
            message = ConfigHandler.fromJson(obj, "LeaveSubtitle", "");
            this.leaveSubtitle = !message.isEmpty() ? Component.Serializer.m_130701_((String)message) : null;
            JsonObject potion = ConfigHandler.fromJson(obj, "Potions");
            potion.entrySet().forEach(e -> this.potions.put(CrossPlatformStuff.INSTANCE.registryStatusEffects().getFromId(new ResourceLocation((String)e.getKey())), ((JsonElement)e.getValue()).getAsInt()));
            this.owner = ConfigHandler.fromJson(obj, "AdminClaim", false) ? null : uuid;
            this.allowedItems.read(ConfigHandler.arryFromJson(obj, "AllowedItems"));
            this.allowedUseBlocks.read(ConfigHandler.arryFromJson(obj, "AllowedUseBlocks"));
            this.allowedBreakBlocks.read(ConfigHandler.arryFromJson(obj, "AllowedBreakBlocks"));
            this.allowedEntityAttack.read(ConfigHandler.arryFromJson(obj, "AllowedEntityAttack"));
            this.allowedEntityUse.read(ConfigHandler.arryFromJson(obj, "AllowedEntityUse"));
            this.globalPerm.clear();
            this.permissions.clear();
            this.subClaims.clear();
            if (obj.has("Parent")) {
                this.parent = UUID.fromString(obj.get("Parent").getAsString());
            }
            if (obj.has("GlobalPerms")) {
                if (this.parent == null) {
                    obj.getAsJsonArray("GlobalPerms").forEach(perm -> this.globalPerm.put(BuiltinPermission.tryLegacy(perm.getAsString()), true));
                } else {
                    obj.getAsJsonObject("GlobalPerms").entrySet().forEach(entry -> this.globalPerm.put(BuiltinPermission.tryLegacy((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean()));
                }
            }
            ConfigHandler.fromJson(obj, "PermGroup").entrySet().forEach(key -> {
                HashMap map = new HashMap();
                JsonObject group = ((JsonElement)key.getValue()).getAsJsonObject();
                group.entrySet().forEach(gkey -> map.put(BuiltinPermission.tryLegacy((String)gkey.getKey()), ((JsonElement)gkey.getValue()).getAsBoolean()));
                this.permissions.put((String)key.getKey(), map);
            });
            ConfigHandler.fromJson(obj, "PlayerPerms").entrySet().forEach(key -> this.playersGroups.put(UUID.fromString((String)key.getKey()), ((JsonElement)key.getValue()).getAsString()));
            ConfigHandler.arryFromJson(obj, "SubClaims").forEach(sub -> this.subClaims.add(Claim.fromJson(sub.getAsJsonObject(), this.owner, this.world)));
            ConfigHandler.arryFromJson(obj, "FakePlayers").forEach(e -> {
                try {
                    this.fakePlayers.add(UUID.fromString(e.getAsString()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
        }
        catch (Exception e2) {
            throw new IllegalStateException("Error reading claim data for claim " + String.valueOf(uuid));
        }
    }

    public JsonObject toJson(JsonObject obj) {
        JsonArray list;
        obj.addProperty("ID", this.claimID.toString());
        obj.addProperty("Name", this.claimName);
        JsonArray pos = new JsonArray();
        pos.add((Number)this.minX);
        pos.add((Number)this.maxX);
        pos.add((Number)this.minZ);
        pos.add((Number)this.maxZ);
        pos.add((Number)this.minY);
        obj.add("PosxXzZY", (JsonElement)pos);
        JsonArray home = new JsonArray();
        home.add((Number)this.homePos.m_123341_());
        home.add((Number)this.homePos.m_123342_());
        home.add((Number)this.homePos.m_123343_());
        obj.add("Home", (JsonElement)home);
        obj.addProperty("EnterTitle", this.enterTitle == null ? "" : Component.Serializer.m_130703_((Component)this.enterTitle));
        obj.addProperty("EnterSubtitle", this.enterSubtitle == null ? "" : Component.Serializer.m_130703_((Component)this.enterSubtitle));
        obj.addProperty("LeaveTitle", this.leaveTitle == null ? "" : Component.Serializer.m_130703_((Component)this.leaveTitle));
        obj.addProperty("LeaveSubtitle", this.leaveSubtitle == null ? "" : Component.Serializer.m_130703_((Component)this.leaveSubtitle));
        JsonObject potions = new JsonObject();
        this.potions.forEach((effect, amp) -> potions.addProperty(CrossPlatformStuff.INSTANCE.registryStatusEffects().getIDFrom((MobEffect)effect).toString(), (Number)amp));
        obj.add("Potions", (JsonElement)potions);
        if (this.parent != null) {
            obj.addProperty("Parent", this.parent.toString());
        }
        obj.add("AllowedItems", this.allowedItems.save());
        obj.add("AllowedUseBlocks", this.allowedUseBlocks.save());
        obj.add("AllowedBreakBlocks", this.allowedBreakBlocks.save());
        obj.add("AllowedEntityAttack", this.allowedEntityAttack.save());
        obj.add("AllowedEntityUse", this.allowedEntityUse.save());
        if (!this.globalPerm.isEmpty()) {
            JsonArray gPerm;
            if (this.parent == null) {
                gPerm = new JsonArray();
                this.globalPerm.forEach((arg_0, arg_1) -> Claim.lambda$toJson$31((JsonElement)gPerm, arg_0, arg_1));
            } else {
                gPerm = new JsonObject();
                this.globalPerm.forEach((arg_0, arg_1) -> Claim.lambda$toJson$32((JsonElement)gPerm, arg_0, arg_1));
            }
            obj.add("GlobalPerms", (JsonElement)gPerm);
        }
        if (!this.permissions.isEmpty()) {
            JsonObject perms = new JsonObject();
            this.permissions.forEach((s, pmap) -> {
                JsonObject group = new JsonObject();
                pmap.forEach((perm, bool) -> group.addProperty(perm.toString(), bool));
                perms.add(s, (JsonElement)group);
            });
            obj.add("PermGroup", (JsonElement)perms);
        }
        if (!this.playersGroups.isEmpty()) {
            JsonObject pl = new JsonObject();
            this.playersGroups.forEach((uuid, s) -> pl.addProperty(uuid.toString(), s));
            obj.add("PlayerPerms", (JsonElement)pl);
        }
        if (!this.subClaims.isEmpty()) {
            list = new JsonArray();
            this.subClaims.forEach(p -> list.add((JsonElement)p.toJson(new JsonObject())));
            obj.add("SubClaims", (JsonElement)list);
        }
        if (!this.fakePlayers.isEmpty()) {
            list = new JsonArray();
            this.fakePlayers.forEach(uuid -> list.add(uuid.toString()));
            obj.add("FakePlayers", (JsonElement)list);
        }
        return obj;
    }

    public int hashCode() {
        return this.claimID == null ? Arrays.hashCode(this.getDimensions()) : this.claimID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Claim) {
            Claim other = (Claim)obj;
            if (this.claimID == null && other.claimID == null) {
                return Arrays.equals(this.getDimensions(), ((Claim)obj).getDimensions());
            }
            if (this.claimID != null) {
                return this.claimID.equals(((Claim)obj).claimID);
            }
        }
        return false;
    }

    public String toString() {
        return String.format("Claim:[ID=%s, Owner=%s, from: [x=%d,z=%d], to: [x=%d,z=%d]", this.claimID != null ? this.claimID.toString() : "null", this.owner != null ? this.owner.toString() : "Admin", this.minX, this.minZ, this.maxX, this.maxZ);
    }

    public String nameAndPosition() {
        String name = this.getClaimName();
        if (name.isEmpty()) {
            return String.format("[x=%d,z=%d]-[x=%d,z=%d]", this.minX, this.minZ, this.maxX, this.maxZ);
        }
        return String.format("%s:[x=%d,z=%d]-[x=%d,z=%d]", name, this.minX, this.minZ, this.maxX, this.maxZ);
    }

    public String formattedClaim() {
        String name = this.getClaimName();
        if (name.isEmpty()) {
            return String.format("[x=%d,z=%d] - [x=%d,z=%d] = %d blocks", this.minX, this.minZ, this.maxX, this.maxZ, this.getPlane());
        }
        return String.format("%s:[x=%d,z=%d] - [x=%d,z=%d] = %d blocks", name, this.minX, this.minZ, this.maxX, this.maxZ, this.getPlane());
    }

    public List<Component> infoString(ServerPlayer player, InfoType infoType) {
        boolean perms = this.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_());
        ArrayList<Component> l = new ArrayList<Component>();
        l.add((Component)PermHelper.simpleColoredText("=============================================", ChatFormatting.GREEN));
        String ownerName = this.isAdminClaim() ? "Admin" : player.m_20194_().m_129927_().m_11002_(this.owner).map(GameProfile::getName).orElse("<UNKNOWN>");
        String claimName = this.getClaimName();
        if (this.parent == null) {
            if (claimName.isEmpty()) {
                l.add((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBasicInfo"), ownerName, this.minX, this.minZ, this.maxX, this.maxZ, this.subClaims.size()), ChatFormatting.GOLD));
            } else {
                l.add((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBasicInfoNamed"), ownerName, this.minX, this.minZ, this.maxX, this.maxZ, this.subClaims.size(), claimName), ChatFormatting.GOLD));
            }
        } else if (claimName.isEmpty()) {
            l.add((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBasicInfoSub"), ownerName, this.minX, this.minZ, this.maxX, this.maxZ), ChatFormatting.GOLD));
        } else {
            l.add((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBasicInfoSubNamed"), ownerName, this.minX, this.minZ, this.maxX, this.maxZ, claimName), ChatFormatting.GOLD));
        }
        if (perms) {
            if (infoType == InfoType.ALL || infoType == InfoType.GLOBAL) {
                l.add(Claim.fromPermissionMap("claimInfoPerms", this.globalPerm));
            }
            if (infoType == InfoType.ALL || infoType == InfoType.GROUP) {
                l.add((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimGroupInfoHeader"), ChatFormatting.GOLD));
                HashMap nameToGroup = new HashMap();
                for (Map.Entry<UUID, String> entry : this.playersGroups.entrySet()) {
                    player.m_20194_().m_129927_().m_11002_(entry.getKey()).ifPresent(pgroup -> nameToGroup.merge((String)e.getValue(), Lists.newArrayList((Object[])new String[]{pgroup.getName()}), (old, val) -> {
                        old.add(pgroup.getName());
                        return old;
                    }));
                }
                for (Map.Entry<Object, Object> entry : this.permissions.entrySet()) {
                    l.add((Component)PermHelper.simpleColoredText(String.format("  %s:", entry.getKey()), ChatFormatting.YELLOW));
                    l.add(Claim.fromPermissionMap("claimGroupPerms", (Map)entry.getValue()));
                    l.add((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimGroupPlayers"), nameToGroup.getOrDefault(entry.getKey(), new ArrayList())), ChatFormatting.RED));
                }
            }
        }
        l.add((Component)PermHelper.simpleColoredText("=============================================", ChatFormatting.GREEN));
        return l;
    }

    private static Component fromPermissionMap(String lang, Map<ResourceLocation, Boolean> map) {
        MutableComponent mapComp = Component.m_237113_((String)"[").m_130940_(ChatFormatting.GRAY);
        int i = 0;
        for (Map.Entry<ResourceLocation, Boolean> entry : map.entrySet()) {
            MutableComponent pComp = Component.m_237113_((String)((i != 0 ? ", " : "") + String.valueOf(entry.getKey()) + "=")).m_130940_(ChatFormatting.GRAY);
            pComp.m_7220_((Component)Component.m_237113_((String)entry.getValue().toString()).m_130940_(entry.getValue() != false ? ChatFormatting.GREEN : ChatFormatting.RED));
            mapComp.m_7220_((Component)pComp);
            ++i;
        }
        mapComp.m_130946_("]");
        MutableComponent component = Component.m_237110_((String)ConfigHandler.LANG_MANAGER.get(lang), (Object[])new Object[]{mapComp}).m_130940_(ChatFormatting.DARK_BLUE);
        return component;
    }

    public DisplayBox display() {
        return new ClaimDisplayBox(this, () -> new DisplayBox.Box(this.minX, this.minY, this.minZ, this.maxX, this.world.m_151558_(), this.maxZ), this::isRemoved);
    }

    private static /* synthetic */ void lambda$toJson$32(JsonElement gPerm, ResourceLocation perm, Boolean bool) {
        ((JsonObject)gPerm).addProperty(perm.toString(), bool);
    }

    private static /* synthetic */ void lambda$toJson$31(JsonElement gPerm, ResourceLocation perm, Boolean bool) {
        if (bool.booleanValue()) {
            ((JsonArray)gPerm).add(perm.toString());
        }
    }

    static interface ClaimUpdater {
        public static final Map<Integer, ClaimUpdater> updater = Config.createHashMap(map -> map.put(2, claim -> claim.globalPerm.put(BuiltinPermission.LOCKITEMS, true)));

        public static void updateClaim(Claim claim) {
            updater.entrySet().stream().filter(e -> (Integer)e.getKey() > ConfigHandler.CONFIG.preConfigVersion).map(Map.Entry::getValue).forEach(up -> up.update(claim));
        }

        public void update(Claim var1);
    }

    public static enum InfoType {
        ALL,
        SIMPLE,
        GLOBAL,
        GROUP;

    }
}

