/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.data.IPermissionStorage;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.GlobalClaim;
import io.github.flemmli97.flan.claim.IClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.claiming.OtherClaimingModCheck;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import io.github.flemmli97.flan.player.EnumEditMode;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.PlayerDataHandler;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import io.github.flemmli97.flan.shadow.org.yaml.snakeyaml.Yaml;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;

public class ClaimStorage
implements IPermissionStorage {
    public static final String ADMIN_CLAIMS = "!AdminClaims";
    private final Long2ObjectMap<List<Claim>> claims = new Long2ObjectOpenHashMap();
    private final Map<UUID, Claim> claimUUIDMap = new HashMap<UUID, Claim>();
    private final Map<UUID, Set<Claim>> playerClaimMap = new HashMap<UUID, Set<Claim>>();
    private final Set<UUID> dirty = new HashSet<UUID>();
    private final GlobalClaim globalClaim;

    public static ClaimStorage get(ServerLevel world) {
        return ((IClaimStorage)world).get();
    }

    public ClaimStorage(MinecraftServer server, ServerLevel world) {
        this.globalClaim = new GlobalClaim(world);
        this.read(server, world);
        PlayerDataHandler.deleteUnusedClaims(server, this, world);
    }

    public UUID generateUUID() {
        UUID uuid = UUID.randomUUID();
        if (this.claimUUIDMap.containsKey(uuid)) {
            return this.generateUUID();
        }
        return uuid;
    }

    public Claim createAdminClaim(BlockPos pos1, BlockPos pos2, ServerLevel level) {
        Claim claim = new Claim(pos1.m_6625_(ConfigHandler.CONFIG.defaultClaimDepth), pos2.m_6625_(ConfigHandler.CONFIG.defaultClaimDepth), null, level);
        Set<DisplayBox> conflicts = this.conflicts(claim, null);
        if (conflicts.isEmpty()) {
            claim.setClaimID(this.generateUUID());
            Flan.log("Creating new admin claim {}", claim);
            this.addClaim(claim);
            return claim;
        }
        return null;
    }

    public boolean createClaim(BlockPos pos1, BlockPos pos2, ServerPlayer player) {
        PlayerClaimData data;
        Set<DisplayBox> conflicts;
        Claim claim = new Claim(pos1.m_6625_(ConfigHandler.CONFIG.defaultClaimDepth), pos2.m_6625_(ConfigHandler.CONFIG.defaultClaimDepth), player);
        if (ConfigHandler.CONFIG.spawnProtection && player.m_9236_().m_46472_() == Level.f_46428_ && player.m_20194_().m_6396_() > 0) {
            AABB aabb = new AABB(player.m_9236_().m_220360_()).m_82400_((double)player.m_20194_().m_6396_());
            int[] dim = claim.getDimensions();
            if ((double)dim[0] <= aabb.f_82291_ && (double)dim[1] >= aabb.f_82288_ && (double)dim[2] <= aabb.f_82293_ && (double)dim[3] >= aabb.f_82290_) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("conflictSpawn"), ChatFormatting.RED), false);
                return false;
            }
        }
        if ((conflicts = this.conflicts(claim, null)).isEmpty()) {
            data = PlayerClaimData.get(player);
            long cooldown = data.nextClaimCooldown();
            if (cooldown > 0L) {
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimCooldown"), cooldown), ChatFormatting.RED), false);
                return false;
            }
            if (claim.getPlane() < ConfigHandler.CONFIG.minClaimsize) {
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("minClaimSize"), ConfigHandler.CONFIG.minClaimsize), ChatFormatting.RED), false);
                return false;
            }
            if (!data.isAdminIgnoreClaim() && ConfigHandler.CONFIG.maxClaims != -1 && !PermissionNodeHandler.INSTANCE.permBelowEqVal(player, "flan.claims.amount", this.playerClaimMap.getOrDefault(player.m_20148_(), Sets.newHashSet()).size() + 1, ConfigHandler.CONFIG.maxClaims)) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("maxClaims"), ChatFormatting.RED), false);
                return false;
            }
            if (!data.isAdminIgnoreClaim() && !data.canUseClaimBlocks(claim.getPlane())) {
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("notEnoughBlocks"), claim.getPlane(), data.remainingClaimBlocks()), ChatFormatting.RED), false);
                return false;
            }
            claim.setClaimID(this.generateUUID());
            Flan.log("Creating new claim {}", claim);
            this.addClaim(claim);
            data.updateLastClaim();
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
            data.updateScoreboard();
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimCreateSuccess"), ChatFormatting.GOLD), false);
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBlocksFormat"), data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks()), ChatFormatting.GOLD), false);
            return true;
        }
        data = PlayerClaimData.get(player);
        conflicts.forEach(conf -> data.addDisplayClaim((DisplayBox)conf, EnumDisplayType.CONFLICT, player.m_20183_().m_123342_()));
        player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("conflictOther"), ChatFormatting.RED), false);
        return false;
    }

    private Set<DisplayBox> conflicts(Claim claim, Claim except) {
        HashSet<DisplayBox> conflicted = new HashSet<DisplayBox>();
        int[] chunks = ClaimStorage.getChunkPos(claim);
        for (int x = chunks[0]; x <= chunks[1]; ++x) {
            for (int z = chunks[2]; z <= chunks[3]; ++z) {
                List claims = (List)this.claims.get(ChunkPos.m_45589_((int)x, (int)z));
                if (claims == null) continue;
                for (Claim other : claims) {
                    if (!claim.intersects(other) || other.equals(except)) continue;
                    conflicted.add(other.display());
                }
            }
        }
        if (!claim.isAdminClaim()) {
            OtherClaimingModCheck.INSTANCE.findConflicts(claim, conflicted);
        }
        return conflicted;
    }

    public boolean deleteClaim(Claim claim, boolean updateClaim, EnumEditMode mode, ServerLevel world) {
        if (mode == EnumEditMode.SUBCLAIM) {
            if (claim.parentClaim() != null) {
                return claim.parentClaim().deleteSubClaim(claim);
            }
            return false;
        }
        Flan.log("Try deleting claim {}", claim);
        int[] pos = ClaimStorage.getChunkPos(claim);
        for (int x = pos[0]; x <= pos[1]; ++x) {
            for (int z = pos[2]; z <= pos[3]; ++z) {
                this.claims.compute(ChunkPos.m_45589_((int)x, (int)z), (key, val) -> {
                    if (val == null) {
                        return null;
                    }
                    val.remove(claim);
                    return val.isEmpty() ? null : val;
                });
            }
        }
        ((Set)this.playerClaimMap.getOrDefault(claim.getOwner(), new HashSet())).remove(claim);
        this.dirty.add(claim.getOwner());
        if (updateClaim) {
            claim.remove();
            claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        }
        WebmapCalls.removeMarker(claim);
        return this.claimUUIDMap.remove(claim.getClaimID()) != null;
    }

    public void toggleAdminClaim(ServerPlayer player, Claim claim, boolean toggle) {
        Flan.log("Set claim {} to an admin claim", claim);
        this.deleteClaim(claim, false, EnumEditMode.DEFAULT, player.m_284548_());
        if (toggle) {
            claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        }
        claim.toggleAdminClaim(player, toggle);
        if (!toggle) {
            PlayerClaimData.get(player).updateScoreboard();
        }
        this.addClaim(claim);
    }

    public boolean resizeClaim(Claim claim, BlockPos from, BlockPos to, ServerPlayer player) {
        boolean enoughBlocks;
        int[] dims = claim.getDimensions();
        BlockPos opposite = new BlockPos(dims[0] == from.m_123341_() ? dims[1] : dims[0], dims[4], dims[2] == from.m_123343_() ? dims[3] : dims[2]);
        Claim newClaim = new Claim(opposite, to, player.m_20148_(), player.m_284548_());
        if (newClaim.getPlane() < ConfigHandler.CONFIG.minClaimsize) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("minClaimSize"), ConfigHandler.CONFIG.minClaimsize), ChatFormatting.RED), false);
            return false;
        }
        Set<DisplayBox> conflicts = this.conflicts(newClaim, claim);
        if (!conflicts.isEmpty()) {
            conflicts.forEach(conf -> PlayerClaimData.get(player).addDisplayClaim((DisplayBox)conf, EnumDisplayType.CONFLICT, player.m_20183_().m_123342_()));
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("conflictOther"), ChatFormatting.RED), false);
            return false;
        }
        int diff = newClaim.getPlane() - claim.getPlane();
        PlayerClaimData data = PlayerClaimData.get(player);
        IPlayerData newData = claim.getOwnerPlayer().map(o -> {
            if (o == player || claim.isAdminClaim()) {
                return data;
            }
            return PlayerClaimData.get(o);
        }).orElse(new OfflinePlayerData(player.m_20194_(), claim.getOwner()));
        boolean bl = enoughBlocks = claim.isAdminClaim() || data.isAdminIgnoreClaim() || newData.canUseClaimBlocks(diff);
        if (enoughBlocks) {
            Flan.log("Resizing claim {}", claim);
            this.deleteClaim(claim, false, EnumEditMode.DEFAULT, player.m_284548_());
            claim.copySizes(newClaim);
            this.addClaim(claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
            if (newData instanceof PlayerClaimData) {
                ((PlayerClaimData)newData).updateScoreboard();
            }
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("resizeSuccess"), ChatFormatting.GOLD), false);
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBlocksFormat"), newData.getClaimBlocks(), newData.getAdditionalClaims(), newData.usedClaimBlocks(), data.remainingClaimBlocks()), ChatFormatting.GOLD), false);
            return true;
        }
        player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("notEnoughBlocks"), claim.getPlane(), data.remainingClaimBlocks()), ChatFormatting.RED), false);
        return false;
    }

    public Claim getClaimAt(BlockPos pos) {
        long chunk = ChunkPos.m_45589_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4));
        List list = (List)this.claims.get(chunk);
        if (list != null) {
            for (Claim claim : list) {
                if (!claim.insideClaim(pos)) continue;
                return claim;
            }
        }
        return null;
    }

    public List<Claim> getClaimsAt(int chunkX, int chunkZ) {
        return (List)this.claims.getOrDefault(ChunkPos.m_45589_((int)chunkX, (int)chunkZ), Collections.emptyList());
    }

    @Override
    public IPermissionContainer getForPermissionCheck(BlockPos pos) {
        Claim claim = this.getClaimAt(pos);
        if (claim != null) {
            return claim;
        }
        return this.globalClaim;
    }

    public Set<Claim> getNearbyClaims(BlockPos pos, int rX, int rZ) {
        int posX;
        ChunkPos c = new ChunkPos(new BlockPos(pos.m_123341_() - rX, pos.m_123342_(), pos.m_123343_() - rZ));
        HashSet<Claim> affected = new HashSet<Claim>();
        int x = 0;
        while ((posX = SectionPos.m_123223_((int)(c.f_45578_ + x))) <= pos.m_123341_() + rX) {
            int posZ;
            int z = 0;
            while ((posZ = SectionPos.m_123223_((int)(c.f_45579_ + z))) <= pos.m_123343_() + rZ) {
                List list = (List)this.claims.get(ChunkPos.m_45589_((int)(c.f_45578_ + x), (int)(c.f_45579_ + z)));
                if (list != null) {
                    int minX = Math.max(posX, pos.m_123341_() - rX);
                    int minZ = Math.max(posZ, pos.m_123343_() - rZ);
                    int maxX = Math.min(posX + 15, pos.m_123341_() + rX);
                    int maxZ = Math.min(posZ + 15, pos.m_123343_() + rZ);
                    AABB bb = new AABB((double)minX, 0.0, (double)minZ, (double)maxX, 0.0, (double)maxZ);
                    list.stream().filter(claim -> claim.intersects(bb)).forEach(affected::add);
                }
                ++z;
            }
            ++x;
        }
        return affected;
    }

    public boolean canInteract(BlockPos pos, int radius, ServerPlayer player, ResourceLocation perm, boolean message) {
        boolean realPlayer = player != null && player.getClass().equals(ServerPlayer.class);
        message = message && realPlayer;
        Set<Claim> affected = this.getNearbyClaims(pos, radius, radius);
        affected.remove(this.getClaimAt(pos));
        for (BlockPos ipos : BlockPos.m_121976_((int)(pos.m_123341_() - radius), (int)pos.m_123342_(), (int)(pos.m_123343_() - radius), (int)(pos.m_123341_() + radius), (int)pos.m_123342_(), (int)(pos.m_123343_() + radius))) {
            for (Claim claim : affected) {
                if (!claim.insideClaim(ipos) || claim.canInteract(player, perm, ipos, message)) continue;
                if (message) {
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionTooClose"), ChatFormatting.DARK_RED), true);
                }
                return false;
            }
        }
        return true;
    }

    public Claim getFromUUID(UUID uuid) {
        return this.claimUUIDMap.get(uuid);
    }

    private void addClaim(Claim claim) {
        int[] pos = ClaimStorage.getChunkPos(claim);
        for (int x = pos[0]; x <= pos[1]; ++x) {
            for (int z = pos[2]; z <= pos[3]; ++z) {
                this.claims.merge(ChunkPos.m_45589_((int)x, (int)z), (Object)Lists.newArrayList((Object[])new Claim[]{claim}), (old, val) -> {
                    old.add(claim);
                    return old;
                });
            }
        }
        this.claimUUIDMap.put(claim.getClaimID(), claim);
        this.playerClaimMap.merge(claim.getOwner(), Sets.newHashSet((Object[])new Claim[]{claim}), (old, val) -> {
            old.add(claim);
            return old;
        });
        WebmapCalls.addClaimMarker(claim);
    }

    public boolean transferOwner(Claim claim, ServerPlayer player, UUID newOwner) {
        if (!PlayerClaimData.get(player).isAdminIgnoreClaim() && !player.m_20148_().equals(claim.getOwner())) {
            return false;
        }
        return this.transferOwner(claim, newOwner);
    }

    public boolean transferOwner(Claim claim, UUID newOwner) {
        this.playerClaimMap.merge(claim.getOwner(), new HashSet(), (old, val) -> {
            old.remove(claim);
            return old;
        });
        this.dirty.add(claim.getOwner());
        claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        claim.transferOwner(newOwner);
        this.playerClaimMap.merge(claim.getOwner(), Sets.newHashSet((Object[])new Claim[]{claim}), (old, val) -> {
            old.add(claim);
            return old;
        });
        this.dirty.add(claim.getOwner());
        WebmapCalls.changeClaimOwner(claim);
        return true;
    }

    public Collection<Claim> allClaimsFromPlayer(UUID player) {
        return this.playerClaimMap.containsKey(player) ? ImmutableSet.copyOf((Collection)this.playerClaimMap.get(player)) : ImmutableSet.of();
    }

    public Collection<Claim> getAdminClaims() {
        return ImmutableSet.copyOf((Collection)this.playerClaimMap.get(null));
    }

    public Map<UUID, Set<Claim>> getClaims() {
        return this.playerClaimMap;
    }

    public static int[] getChunkPos(Claim claim) {
        int[] dim = claim.getDimensions();
        int[] pos = new int[]{dim[0] >> 4, dim[1] >> 4, dim[2] >> 4, dim[3] >> 4};
        return pos;
    }

    public void read(MinecraftServer server, ServerLevel world) {
        Flan.log("Loading claim data for world {}", world.m_46472_());
        Path dir = ConfigHandler.getClaimSavePath(server, (ResourceKey<Level>)world.m_46472_());
        if (Files.exists(dir, new LinkOption[0])) {
            try {
                for (Path file : Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toSet())) {
                    String name = file.toFile().getName();
                    if (!name.endsWith(".json")) continue;
                    String realName = name.replace(".json", "");
                    UUID uuid = realName.equals(ADMIN_CLAIMS) ? null : UUID.fromString(realName);
                    JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8));
                    JsonArray arr = (JsonArray)ConfigHandler.GSON.fromJson(reader, JsonArray.class);
                    reader.close();
                    if (arr == null) continue;
                    Flan.debug("Reading claim data from json {} for player uuid {}", arr, uuid);
                    arr.forEach(el -> {
                        if (el.isJsonObject()) {
                            this.addClaim(Claim.fromJson((JsonObject)el, uuid, world));
                        }
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save(MinecraftServer server, ResourceKey<Level> reg) {
        Flan.log("Saving claims for world {}", reg);
        Path dir = ConfigHandler.getClaimSavePath(server, reg);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            for (Map.Entry<UUID, Set<Claim>> e : this.playerClaimMap.entrySet()) {
                String owner = e.getKey() == null ? ADMIN_CLAIMS : e.getKey().toString();
                Path file = dir.resolve(owner + ".json");
                Flan.debug("Attempting saving claim data for player uuid {}", owner);
                boolean dirty = false;
                if (!Files.exists(file, new LinkOption[0])) {
                    if (e.getValue().isEmpty()) continue;
                    Files.createFile(file, new FileAttribute[0]);
                    dirty = true;
                } else {
                    if (e.getValue().isEmpty()) {
                        Files.delete(file);
                        continue;
                    }
                    if (this.dirty.remove(owner.equals(ADMIN_CLAIMS) ? null : e.getKey())) {
                        dirty = true;
                    } else {
                        for (Claim claim2 : e.getValue()) {
                            if (!claim2.isDirty()) continue;
                            dirty = true;
                            claim2.setDirty(false);
                        }
                    }
                }
                if (!dirty) continue;
                JsonArray arr = new JsonArray();
                e.getValue().forEach(claim -> arr.add((JsonElement)claim.toJson(new JsonObject())));
                Flan.debug("Attempting saving changed claim data {} for player uuid {}", arr, owner);
                JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
                ConfigHandler.GSON.toJson((JsonElement)arr, jsonWriter);
                jsonWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean readGriefPreventionData(MinecraftServer server, CommandSourceStack src) {
        Yaml yml = new Yaml();
        File griefPrevention = server.m_129843_(LevelResource.f_78182_).resolve("plugins/GriefPreventionData/ClaimData").toFile();
        if (!griefPrevention.exists()) {
            src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("cantFindData"), griefPrevention.getAbsolutePath()), ChatFormatting.DARK_RED), false);
            return false;
        }
        HashMap<File, List> subClaimMap = new HashMap<File, List>();
        HashMap<Integer, File> intFileMap = new HashMap<Integer, File>();
        Set<ResourceLocation> managers = ClaimStorage.complementOf(BuiltinPermission.EDITCLAIM);
        Set<ResourceLocation> builders = ClaimStorage.complementOf(BuiltinPermission.EDITPERMS, BuiltinPermission.EDITCLAIM);
        Set<ResourceLocation> containers = ClaimStorage.complementOf(BuiltinPermission.EDITPERMS, BuiltinPermission.EDITCLAIM, BuiltinPermission.BREAK, BuiltinPermission.PLACE, BuiltinPermission.NOTEBLOCK, BuiltinPermission.REDSTONE, BuiltinPermission.JUKEBOX, BuiltinPermission.ITEMFRAMEROTATE, BuiltinPermission.LECTERNTAKE, BuiltinPermission.ENDCRYSTALPLACE, BuiltinPermission.PROJECTILES, BuiltinPermission.TRAMPLE, BuiltinPermission.RAID, BuiltinPermission.BUCKET, BuiltinPermission.ARMORSTAND, BuiltinPermission.BREAKNONLIVING);
        Set<ResourceLocation> accessors = ClaimStorage.complementOf(BuiltinPermission.EDITPERMS, BuiltinPermission.EDITCLAIM, BuiltinPermission.BREAK, BuiltinPermission.PLACE, BuiltinPermission.OPENCONTAINER, BuiltinPermission.ANVIL, BuiltinPermission.BEACON, BuiltinPermission.NOTEBLOCK, BuiltinPermission.REDSTONE, BuiltinPermission.JUKEBOX, BuiltinPermission.ITEMFRAMEROTATE, BuiltinPermission.LECTERNTAKE, BuiltinPermission.ENDCRYSTALPLACE, BuiltinPermission.PROJECTILES, BuiltinPermission.TRAMPLE, BuiltinPermission.RAID, BuiltinPermission.BUCKET, BuiltinPermission.ANIMALINTERACT, BuiltinPermission.HURTANIMAL, BuiltinPermission.TRADING, BuiltinPermission.ARMORSTAND, BuiltinPermission.BREAKNONLIVING);
        HashMap<String, Set<ResourceLocation>> perms = new HashMap<String, Set<ResourceLocation>>();
        perms.put("managers", managers);
        perms.put("builders", builders);
        perms.put("containers", containers);
        perms.put("accessors", accessors);
        try {
            Object reader;
            Map values;
            for (File f : griefPrevention.listFiles()) {
                if (!f.getName().endsWith(".yml") || !(values = (Map)yml.load((Reader)(reader = new FileReader(f)))).get("Parent Claim ID").equals(-1)) continue;
                try {
                    intFileMap.put(Integer.valueOf(f.getName().replace(".yml", "")), f);
                }
                catch (NumberFormatException e) {
                    src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("errorFile"), f.getName(), ChatFormatting.RED), new ChatFormatting[0]), false);
                }
            }
            for (File f : griefPrevention.listFiles()) {
                if (!f.getName().endsWith(".yml") || (values = (Map)yml.load((Reader)(reader = new FileReader(f)))).get("Parent Claim ID").equals(-1)) continue;
                subClaimMap.merge((File)intFileMap.get(Integer.valueOf(values.get("Parent Claim ID").toString())), Lists.newArrayList((Object[])new File[]{f}), (key, val) -> {
                    key.add(f);
                    return key;
                });
            }
            for (File parent : intFileMap.values()) {
                try {
                    ClaimStorage storage;
                    Set<DisplayBox> conflicts;
                    Tuple<ServerLevel, Claim> parentClaim = ClaimStorage.parseFromYaml(parent, yml, server, perms);
                    List childs = (List)subClaimMap.get(parent);
                    if (childs != null && !childs.isEmpty()) {
                        for (File childF : childs) {
                            ((Claim)parentClaim.m_14419_()).addSubClaimGriefprevention((Claim)ClaimStorage.parseFromYaml(childF, yml, server, perms).m_14419_());
                        }
                    }
                    if ((conflicts = (storage = ClaimStorage.get((ServerLevel)parentClaim.m_14418_())).conflicts((Claim)parentClaim.m_14419_(), null)).isEmpty()) {
                        ((Claim)parentClaim.m_14419_()).setClaimID(storage.generateUUID());
                        storage.addClaim((Claim)parentClaim.m_14419_());
                        continue;
                    }
                    src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("readConflict"), parent.getName(), conflicts), ChatFormatting.DARK_RED), false);
                    for (DisplayBox claim : conflicts) {
                        DisplayBox.Box dim = claim.box();
                        MutableComponent text = PermHelper.simpleColoredText(String.format("@[x=%d;z=%d]", dim.minX(), dim.minZ()), ChatFormatting.RED);
                        text.m_6270_(text.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + dim.minX() + " ~ " + dim.minZ())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                        src.m_288197_(() -> text, false);
                    }
                }
                catch (Exception e) {
                    src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("errorFile"), parent.getName(), ChatFormatting.RED), new ChatFormatting[0]), false);
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static Set<ResourceLocation> complementOf(ResourceLocation ... perms) {
        HashSet set = Sets.newHashSet(PermissionManager.INSTANCE.getIds());
        for (ResourceLocation perm : perms) {
            set.remove(perm);
        }
        return set;
    }

    private static Tuple<ServerLevel, Claim> parseFromYaml(File file, Yaml yml, MinecraftServer server, Map<String, Set<ResourceLocation>> perms) throws IOException {
        FileReader reader = new FileReader(file);
        Map values = (Map)yml.load(reader);
        reader.close();
        String ownerString = (String)values.get("Owner");
        UUID owner = ownerString.isEmpty() ? null : UUID.fromString(ownerString);
        List<String> builders = ClaimStorage.readList(values, "Builders");
        List<String> managers = ClaimStorage.readList(values, "Managers");
        List<String> containers = ClaimStorage.readList(values, "Containers");
        List<String> accessors = ClaimStorage.readList(values, "Accessors");
        String[] lesserCorner = values.get("Lesser Boundary Corner").toString().split(";");
        String[] greaterCorner = values.get("Greater Boundary Corner").toString().split(";");
        ServerLevel world = server.m_129880_(ClaimStorage.worldRegFromString(lesserCorner[0]));
        Claim claim = new Claim(Integer.parseInt(lesserCorner[1]), Integer.parseInt(greaterCorner[1]), Integer.parseInt(lesserCorner[3]), Integer.parseInt(greaterCorner[3]), ConfigHandler.CONFIG.defaultClaimDepth == 255 ? 0 : Integer.parseInt(lesserCorner[2]), owner, world);
        if (!builders.isEmpty() && !builders.contains(ownerString)) {
            if (builders.contains("public")) {
                perms.get("builders").forEach(perm -> {
                    if (!PermissionManager.INSTANCE.isGlobalPermission((ResourceLocation)perm)) {
                        claim.editGlobalPerms(null, (ResourceLocation)perm, 1);
                    }
                });
            } else {
                perms.get("builders").forEach(perm -> claim.editPerms(null, "Builders", (ResourceLocation)perm, 1, true));
                builders.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Builders", true));
            }
        }
        if (!managers.isEmpty() && !managers.contains(ownerString)) {
            if (managers.contains("public")) {
                perms.get("managers").forEach(perm -> {
                    if (!PermissionManager.INSTANCE.isGlobalPermission((ResourceLocation)perm)) {
                        claim.editGlobalPerms(null, (ResourceLocation)perm, 1);
                    }
                });
            } else {
                perms.get("managers").forEach(perm -> claim.editPerms(null, "Managers", (ResourceLocation)perm, 1, true));
                managers.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Managers", true));
            }
        }
        if (!containers.isEmpty() && !containers.contains(ownerString)) {
            if (containers.contains("public")) {
                perms.get("containers").forEach(perm -> {
                    if (!PermissionManager.INSTANCE.isGlobalPermission((ResourceLocation)perm)) {
                        claim.editGlobalPerms(null, (ResourceLocation)perm, 1);
                    }
                });
            } else {
                perms.get("containers").forEach(perm -> claim.editPerms(null, "Containers", (ResourceLocation)perm, 1, true));
                containers.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Containers", true));
            }
        }
        if (!accessors.isEmpty() && !accessors.contains(ownerString)) {
            if (accessors.contains("public")) {
                perms.get("accessors").forEach(perm -> {
                    if (!PermissionManager.INSTANCE.isGlobalPermission((ResourceLocation)perm)) {
                        claim.editGlobalPerms(null, (ResourceLocation)perm, 1);
                    }
                });
            } else {
                perms.get("accessors").forEach(perm -> claim.editPerms(null, "Accessors", (ResourceLocation)perm, 1, true));
                accessors.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Accessors", true));
            }
        }
        return new Tuple((Object)world, (Object)claim);
    }

    private static <T> List<T> readList(Map<String, Object> values, String key) {
        Object obj = values.get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return new ArrayList();
    }

    public static ResourceKey<Level> worldRegFromString(String spigot) {
        if (spigot.equals("world_the_end")) {
            return Level.f_46430_;
        }
        if (spigot.equals("world_nether")) {
            return Level.f_46429_;
        }
        return Level.f_46428_;
    }
}

