/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.AllowedRegistryList;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.commands.CommandHelp;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.CustomInteractListScreenHandler;
import io.github.flemmli97.flan.gui.PersonalGroupScreenHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.EnumEditMode;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class CommandClaim {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, boolean dedicated) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"flan").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.reload", true))).executes(CommandClaim::reloadConfig))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.create"))).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(CommandClaim::addClaim)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)ResourceLocationArgument.m_106984_()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.admin.create", true))).suggests((src, build) -> SharedSuggestionProvider.m_82970_(((CommandSourceStack)src.getSource()).m_81377_().m_129784_().stream().map(k -> k.m_135782_().toString()).toList(), (SuggestionsBuilder)build)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((src, build) -> SharedSuggestionProvider.m_82970_(Stream.concat(Stream.of("+Admin"), ((CommandSourceStack)src.getSource()).m_81377_().m_6846_().m_11314_().stream().map(p -> p.m_20148_().toString())).toList(), (SuggestionsBuilder)build)).executes(CommandClaim::addClaimAs)))))).then(Commands.m_82127_((String)"all").executes(CommandClaim::addClaimAll))).then(Commands.m_82127_((String)"rect").then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClaim.addClaimRect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"expand").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.create"))).then(Commands.m_82129_((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::expandClaim)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"menu").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.menu"))).executes(CommandClaim::openMenu))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setHome").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.home"))).executes(CommandClaim::setClaimHome))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"trapped").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.trapped"))).executes(CommandClaim::trapped))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"name").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.name"))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::nameClaim)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unlockDrops").executes(CommandClaim::unlockDrops)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.unlock.all", true))).executes(CommandClaim::unlockDropsPlayers)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"personalGroups").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.personal"))).executes(CommandClaim::openPersonalGroups))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"info").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.info"))).executes(ctx -> CommandClaim.claimInfo((CommandContext<CommandSourceStack>)ctx, Claim.InfoType.ALL))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((src, b) -> CommandHelpers.enumSuggestion(Claim.InfoType.class, b)).executes(CommandClaim::claimInfo)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transferClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.transfer"))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(CommandClaim::transferClaim)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"delete").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete"))).executes(CommandClaim::deleteClaim))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"deleteAll").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.all"))).executes(CommandClaim::deleteAllClaim))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"deleteSubClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.sub"))).executes(CommandClaim::deleteSubClaim))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"deleteAllSubClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.sub.all"))).executes(CommandClaim::deleteAllSubClaim))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.list"))).executes(CommandClaim::listClaims)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.list.all", true))).executes(cmd -> CommandClaim.listClaims((CommandContext<CommandSourceStack>)cmd, GameProfileArgument.m_94590_((CommandContext)cmd, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"switchMode").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.claim.mode"))).executes(CommandClaim::switchClaimMode))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"bypass").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.bypass.claim", true))).executes(CommandClaim::switchAdminMode))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"readGriefPrevention").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.read.griefprevention", true))).executes(CommandClaim::readGriefPreventionData))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setAdminClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.claim", true))).then(Commands.m_82129_((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(CommandClaim::toggleAdminClaim)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"listAdminClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.list", true))).executes(CommandClaim::listAdminClaims))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"adminDelete").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.delete", true))).executes(CommandClaim::adminDelete)).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(CommandClaim::adminDeleteAll))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"giveClaimBlocks").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.give", true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::giveClaimBlocks))).then(Commands.m_82127_((String)"base").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClaim.giveClaimBlocks((CommandContext<CommandSourceStack>)ctx, true))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"buy").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.sell", false))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::buyClaimBlocks)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sell").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.buy", false))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::sellClaimBlocks)))).then(Commands.m_82127_((String)"claimMessage").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"enter", "leave"}, (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"title", "subtitle"}, (SuggestionsBuilder)b)).then(Commands.m_82127_((String)"text").then(Commands.m_82129_((String)"component", (ArgumentType)ComponentArgument.m_87114_()).executes(ctx -> CommandClaim.editClaimMessages((CommandContext<CommandSourceStack>)ctx, ComponentArgument.m_87117_((CommandContext)ctx, (String)"component")))))).then(Commands.m_82127_((String)"string").then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::editClaimMessages))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"group").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.group"))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::addGroup)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).executes(CommandClaim::removeGroup)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"players").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(CommandClaim::addPlayer)).then(Commands.m_82127_((String)"overwrite").executes(CommandClaim::forceAddPlayer)))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).suggests((context, build) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String group = StringArgumentType.getString((CommandContext)context, (String)"group");
            List<Object> list = new ArrayList();
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.m_81372_());
            Claim claim = storage.getClaimAt(src.m_81375_().m_20183_());
            if (claim != null && claim.canInteract(src.m_81375_(), BuiltinPermission.EDITPERMS, src.m_81375_().m_20183_())) {
                list = claim.playersFromGroup(player.m_20194_(), group);
            }
            return SharedSuggestionProvider.m_82970_(list, (SuggestionsBuilder)build);
        }).executes(CommandClaim::removePlayer))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fakePlayer").executes(CommandClaim::toggleFakePlayer)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.fakeplayer"))).then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).executes(CommandClaim::addFakePlayer)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.fakeplayer"))).then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).suggests((context, build) -> {
            List<Object> list = new ArrayList();
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.m_81372_());
            Claim claim = storage.getClaimAt(src.m_81375_().m_20183_());
            if (claim != null && claim.canInteract(src.m_81375_(), BuiltinPermission.EDITPERMS, src.m_81375_().m_20183_())) {
                list = claim.getAllowedFakePlayerUUID();
            }
            return SharedSuggestionProvider.m_82970_(list, (SuggestionsBuilder)build);
        }).executes(CommandClaim::removeFakePlayer))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"teleport").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.teleport"))).then(Commands.m_82127_((String)"self").then(Commands.m_82129_((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, ((CommandSourceStack)ctx.getSource()).m_81375_().m_20148_())).executes(CommandClaim::teleport)))).then(Commands.m_82127_((String)"global").then(Commands.m_82129_((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, null)).executes(CommandClaim::teleportAdminClaims)))).then(Commands.m_82127_((String)"other").then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, CommandHelpers.singleProfile((CommandContext<CommandSourceStack>)ctx, "player").getId())).executes(src -> CommandClaim.teleport((CommandContext<CommandSourceStack>)src, CommandHelpers.singleProfile((CommandContext<CommandSourceStack>)src, "player").getId()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"permission").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.permission"))).then(Commands.m_82127_((String)"personal").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::personalGroupSuggestion).then(Commands.m_82129_((String)"permission", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, true)).then(Commands.m_82129_((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editPersonalPerm)))))).then(Commands.m_82127_((String)"global").then(Commands.m_82129_((String)"permission", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, false)).then(Commands.m_82129_((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editGlobalPerm))))).then(Commands.m_82127_((String)"group").then(Commands.m_82129_((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).then(Commands.m_82129_((String)"permission", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, true)).then(Commands.m_82129_((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editGroupPerm))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ignoreList").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.claim.ignore", false))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.ITEM.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256913_)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ITEM))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.BLOCKBREAK.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256747_)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKBREAK))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.BLOCKUSE.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256747_)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKUSE))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.ENTITYATTACK.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256939_)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYATTACK))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.ENTITYUSE.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256939_)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYUSE)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.ITEM.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256913_)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.ITEM)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ITEM))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.BLOCKBREAK.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256747_)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.BLOCKBREAK)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKBREAK))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.BLOCKUSE.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256747_)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.BLOCKUSE)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKUSE))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.ENTITYATTACK.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256939_)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.ENTITYATTACK)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYATTACK))))).then(Commands.m_82127_((String)CustomInteractListScreenHandler.Type.ENTITYUSE.commandKey).then(Commands.m_82129_((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256939_)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.ENTITYUSE)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYUSE))))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"help").executes(ctx -> CommandHelp.helpMessage((CommandContext<CommandSourceStack>)ctx, 0, builder.getArguments()))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandHelp.helpMessage((CommandContext<CommandSourceStack>)ctx, builder.getArguments())))).then(Commands.m_82127_((String)"cmd").then(Commands.m_82129_((String)"command", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82970_(CommandHelp.registeredCommands((CommandContext<CommandSourceStack>)ctx, builder.getArguments()), (SuggestionsBuilder)sb)).executes(CommandHelp::helpCmd))));
        builder.then(Commands.m_82127_((String)"?").executes(ctx -> CommandHelp.helpCmd((CommandContext<CommandSourceStack>)ctx, "help")));
        dispatcher.register(builder);
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        ConfigHandler.reloadConfigs(((CommandSourceStack)context.getSource()).m_81377_());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("configReload"), new ChatFormatting[0]), true);
        return 1;
    }

    private static int addClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!ItemInteractEvents.canClaimWorld(player.m_284548_(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        BlockPos from = BlockPosArgument.m_118242_(context, (String)"from");
        BlockPos to = BlockPosArgument.m_118242_(context, (String)"to");
        storage.createClaim(from, to, player);
        return 1;
    }

    private static int addClaimAs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos to;
        BlockPos from;
        String as = StringArgumentType.getString(context, (String)"player");
        ResourceLocation levelID = ResourceLocationArgument.m_107011_(context, (String)"dimension");
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81377_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)levelID));
        if (level == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("noSuchLevel"), levelID), new ChatFormatting[0]), true);
            return 0;
        }
        UUID uuid = null;
        if (!as.equals("+Admin") && (uuid = (UUID)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_10996_(as).map(GameProfile::getId).orElse(null)) == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("noSuchPlayer"), as), new ChatFormatting[0]), true);
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(level);
        Claim claim = storage.createAdminClaim(from = BlockPosArgument.m_118242_(context, (String)"from"), to = BlockPosArgument.m_118242_(context, (String)"to"), level);
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimCreationFailCommand"), new ChatFormatting[0]), true);
            return 0;
        }
        if (uuid != null) {
            storage.transferOwner(claim, uuid);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimCreateSuccess"), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int addClaimAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        int usable = data.getClaimBlocks() + data.getAdditionalClaims() - data.usedClaimBlocks();
        int size = (int)Math.floor(Math.sqrt(usable));
        return CommandClaim.addClaimRect(context, size, size);
    }

    private static int addClaimRect(CommandContext<CommandSourceStack> context, int x, int z) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!ItemInteractEvents.canClaimWorld(player.m_284548_(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        boolean evenX = x % 2 == 0;
        boolean evenZ = z % 2 == 0;
        BlockPos from = player.m_20183_().m_7918_(evenX ? -((int)((double)(x - 1) * 0.5)) : -((int)((double)x * 0.5)), -5, evenZ ? -((int)((double)(z - 1) * 0.5)) : -((int)((double)z * 0.5)));
        BlockPos to = player.m_20183_().m_7918_((int)((double)x * 0.5), -5, (int)((double)z * 0.5));
        storage.createClaim(from, to, player);
        return 1;
    }

    private static int transferClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Collection profs = GameProfileArgument.m_94590_(context, (String)"player");
        if (profs.size() != 1) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("onlyOnePlayer"), ChatFormatting.RED), false);
            return 0;
        }
        GameProfile prof = (GameProfile)profs.iterator().next();
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(player.m_20183_());
        if (claim == null) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noClaim"), ChatFormatting.RED), false);
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        boolean enoughBlocks = true;
        if (!data.isAdminIgnoreClaim()) {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            ServerPlayer newOwner = server.m_6846_().m_11259_(prof.getId());
            IPlayerData newData = newOwner != null ? PlayerClaimData.get(newOwner) : new OfflinePlayerData(server, prof.getId());
            enoughBlocks = newData.canUseClaimBlocks(claim.getPlane());
        }
        if (!enoughBlocks) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("ownerTransferNoBlocks"), ChatFormatting.RED), false);
            if (PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)context.getSource(), "flan.command.bypass.claim", true)) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("ownerTransferNoBlocksAdmin"), ChatFormatting.RED), false);
            }
            return 0;
        }
        if (!storage.transferOwner(claim, player, prof.getId())) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("ownerTransferFail"), ChatFormatting.RED), false);
            return 0;
        }
        player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("ownerTransferSuccess"), prof.getName()), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int openMenu(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim claim = ClaimStorage.get(player.m_284548_()).getClaimAt(player.m_20183_());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (data.getEditMode() == EnumEditMode.DEFAULT) {
            ClaimMenuScreenHandler.openClaimMenu(player, claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
        } else {
            Claim sub = claim.getSubClaim(player.m_20183_());
            if (sub != null) {
                ClaimMenuScreenHandler.openClaimMenu(player, sub);
            } else {
                ClaimMenuScreenHandler.openClaimMenu(player, claim);
            }
        }
        return 1;
    }

    private static int trapped(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.setTrappedRescue()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("trappedRescue"), ChatFormatting.GOLD), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("trappedFail"), ChatFormatting.RED), false);
        return 0;
    }

    private static int nameClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getEditMode() == EnumEditMode.DEFAULT) {
            Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITPERMS, PermHelper.genericNoPermMessage(player));
            if (claim == null) {
                return 0;
            }
            boolean nameUsed = ClaimStorage.get(player.m_284548_()).allClaimsFromPlayer(claim.getOwner()).stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
            if (!nameUsed) {
                String name2 = StringArgumentType.getString(context, (String)"name");
                claim.setClaimName(name2);
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimNameSet"), name2), ChatFormatting.GOLD), false);
            } else {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimNameUsed"), ChatFormatting.DARK_RED), false);
            }
        } else {
            Claim claim = ClaimStorage.get(player.m_284548_()).getClaimAt(player.m_20183_());
            Claim sub = claim.getSubClaim(player.m_20183_());
            if (sub != null && (claim.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_()) || sub.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_()))) {
                boolean nameUsed = claim.getAllSubclaims().stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
                if (!nameUsed) {
                    String name3 = StringArgumentType.getString(context, (String)"name");
                    sub.setClaimName(name3);
                    player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimNameSet"), name3), ChatFormatting.GOLD), false);
                } else {
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimNameUsedSub"), ChatFormatting.DARK_RED), false);
                }
            } else if (claim.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_())) {
                boolean nameUsed = ClaimStorage.get(player.m_284548_()).allClaimsFromPlayer(claim.getOwner()).stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
                if (!nameUsed) {
                    String name4 = StringArgumentType.getString(context, (String)"name");
                    claim.setClaimName(name4);
                    player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimNameSet"), name4), ChatFormatting.GOLD), false);
                } else {
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimNameUsed"), ChatFormatting.DARK_RED), false);
                }
            } else {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermission"), ChatFormatting.DARK_RED), false);
            }
        }
        return 1;
    }

    private static int unlockDrops(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        data.unlockDeathItems();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("unlockDrops"), ConfigHandler.CONFIG.dropTicks), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int unlockDropsPlayers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.m_94590_(context, (String)"players");
        ArrayList<String> success = new ArrayList<String>();
        for (GameProfile prof : profs) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(prof.getId());
            if (player == null) continue;
            PlayerClaimData data = PlayerClaimData.get(player);
            data.unlockDeathItems();
            success.add(prof.getName());
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("unlockDropsMulti"), success), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int openPersonalGroups(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PersonalGroupScreenHandler.openGroupMenu((Player)player);
        return 1;
    }

    private static int claimInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.claimInfo(context, CommandHelpers.parseEnum(Claim.InfoType.class, StringArgumentType.getString(context, (String)"type"), Claim.InfoType.ALL));
    }

    private static int claimInfo(CommandContext<CommandSourceStack> context, Claim.InfoType infoType) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Claim claim = ClaimStorage.get(player.m_284548_()).getClaimAt(player.m_20183_());
        PlayerClaimData data = PlayerClaimData.get(player);
        if (claim == null) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noClaim"), ChatFormatting.RED), false);
            return 0;
        }
        if (data.getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.m_20183_())) != null) {
            List<Component> info = sub.infoString(player, infoType);
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("claimSubHeader"), ChatFormatting.AQUA), false);
            for (Component text : info) {
                player.m_5661_(text, false);
            }
            return 1;
        }
        List<Component> info = claim.infoString(player, infoType);
        for (Component text : info) {
            player.m_5661_(text, false);
        }
        return 1;
    }

    private static int deleteClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(player.m_20183_());
        boolean check = PermHelper.check(player, player.m_20183_(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (!b.isPresent()) {
                PermHelper.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteClaimError"), ChatFormatting.DARK_RED), false);
            }
        });
        if (!check) {
            return 0;
        }
        if (!storage.deleteClaim(claim, true, PlayerClaimData.get(player).getEditMode(), player.m_284548_())) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteSubClaimError"), ChatFormatting.DARK_RED), false);
        } else {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteClaim"), ChatFormatting.RED), false);
        }
        return 1;
    }

    private static int deleteAllClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.confirmedDeleteAll()) {
            for (ServerLevel world : player.m_20194_().m_129785_()) {
                ClaimStorage storage = ClaimStorage.get(world);
                storage.allClaimsFromPlayer(player.m_20148_()).forEach(claim -> storage.deleteClaim((Claim)claim, true, PlayerClaimData.get(player).getEditMode(), player.m_284548_()));
            }
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteAllClaim"), ChatFormatting.GOLD), false);
            data.setConfirmDeleteAll(false);
        } else {
            data.setConfirmDeleteAll(true);
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteAllClaimConfirm"), ChatFormatting.DARK_RED), false);
        }
        return 1;
    }

    private static int deleteSubClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(player.m_20183_());
        if (claim == null) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noClaim"), ChatFormatting.RED), false);
            return 0;
        }
        Claim sub = claim.getSubClaim(player.m_20183_());
        if (sub == null) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noClaim"), ChatFormatting.RED), false);
            return 0;
        }
        boolean check = PermHelper.check(player, player.m_20183_(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (!b.isPresent()) {
                PermHelper.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteClaimError"), ChatFormatting.DARK_RED), false);
            } else {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteSubClaim"), ChatFormatting.DARK_RED), false);
            }
        });
        if (!check) {
            return 0;
        }
        claim.deleteSubClaim(sub);
        return 1;
    }

    private static int deleteAllSubClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITCLAIM, PermHelper.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        List<Claim> subs = claim.getAllSubclaims();
        subs.forEach(claim::deleteSubClaim);
        player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteSubClaimAll"), ChatFormatting.DARK_RED), false);
        return 1;
    }

    private static int listClaims(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.listClaimsFromUUID(context, null);
    }

    private static int listClaims(CommandContext<CommandSourceStack> context, Collection<GameProfile> profs) throws CommandSyntaxException {
        if (profs.size() != 1) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("onlyOnePlayer"), ChatFormatting.RED), false);
            return 0;
        }
        GameProfile prof = profs.iterator().next();
        if (prof == null || prof.getId() == null) {
            return 0;
        }
        return CommandClaim.listClaimsFromUUID(context, prof.getId());
    }

    private static int listClaimsFromUUID(CommandContext<CommandSourceStack> context, UUID of) throws CommandSyntaxException {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        ServerPlayer player = of == null ? ((CommandSourceStack)context.getSource()).m_81375_() : server.m_6846_().m_11259_(of);
        HashMap<ServerLevel, Collection<Claim>> claims = new HashMap<ServerLevel, Collection<Claim>>();
        for (ServerLevel serverLevel : server.m_129785_()) {
            ClaimStorage storage = ClaimStorage.get(serverLevel);
            claims.put(serverLevel, storage.allClaimsFromPlayer(player != null ? player.m_20148_() : of));
        }
        if (ConfigHandler.CONFIG.maxClaimBlocks != -1) {
            if (player != null) {
                data = PlayerClaimData.get(player);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandClaim.lambda$listClaimsFromUUID$93((PlayerClaimData)data), false);
            } else {
                data = new OfflinePlayerData(server, of);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandClaim.lambda$listClaimsFromUUID$94((OfflinePlayerData)data), false);
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("listClaims"), ChatFormatting.GOLD), false);
        for (Map.Entry entry : claims.entrySet()) {
            for (Claim claim : (Collection)entry.getValue()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(((Level)entry.getKey()).m_46472_().m_135782_().toString() + " # " + claim.formattedClaim(), ChatFormatting.YELLOW), false);
            }
        }
        return 1;
    }

    private static int switchClaimMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerClaimData data;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        data.setEditMode((data = PlayerClaimData.get(player)).getEditMode() == EnumEditMode.DEFAULT ? EnumEditMode.SUBCLAIM : EnumEditMode.DEFAULT);
        player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("editMode"), new Object[]{data.getEditMode()}), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int switchAdminMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerClaimData data;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        data.setAdminIgnoreClaim(!(data = PlayerClaimData.get(player)).isAdminIgnoreClaim());
        player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("adminMode"), data.isAdminIgnoreClaim()), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int adminDelete(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        ClaimStorage storage = ClaimStorage.get(src.m_81372_());
        Claim claim = storage.getClaimAt(BlockPos.m_274446_((Position)src.m_81371_()));
        if (claim == null) {
            src.m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noClaim"), ChatFormatting.RED), false);
            return 0;
        }
        storage.deleteClaim(claim, true, EnumEditMode.DEFAULT, src.m_81372_());
        src.m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteClaim"), ChatFormatting.RED), true);
        return 1;
    }

    private static int adminDeleteAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        PlayerClaimData data;
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        Entity entity = src.m_81373_();
        if (entity instanceof ServerPlayer && !(data = PlayerClaimData.get(player = (ServerPlayer)entity)).confirmedDeleteAll()) {
            data.setConfirmDeleteAll(true);
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("deleteAllClaimConfirm"), ChatFormatting.DARK_RED), false);
            return 1;
        }
        ArrayList<String> players = new ArrayList<String>();
        for (GameProfile prof : GameProfileArgument.m_94590_(context, (String)"players")) {
            for (ServerLevel world : src.m_81372_().m_7654_().m_129785_()) {
                ClaimStorage storage = ClaimStorage.get(world);
                storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, EnumEditMode.DEFAULT, world));
            }
            players.add(prof.getName());
        }
        src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("adminDeleteAll"), players), ChatFormatting.GOLD), true);
        return 1;
    }

    private static int toggleAdminClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(player.m_20183_());
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noClaim"), ChatFormatting.RED), false);
            return 0;
        }
        storage.toggleAdminClaim(player, claim, BoolArgumentType.getBool(context, (String)"toggle"));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("setAdminClaim"), claim.isAdminClaim()), ChatFormatting.GOLD), true);
        return 1;
    }

    private static int listAdminClaims(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        Collection<Claim> claims = ClaimStorage.get(src.m_81372_()).getAdminClaims();
        src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("listAdminClaims"), src.m_81372_().m_46472_().m_135782_()), ChatFormatting.GOLD), false);
        for (Claim claim : claims) {
            src.m_288197_(() -> PermHelper.simpleColoredText(claim.formattedClaim(), ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int readGriefPreventionData(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        src.m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("readGriefpreventionData"), ChatFormatting.GOLD), true);
        if (ClaimStorage.readGriefPreventionData(src.m_81377_(), src)) {
            src.m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("readGriefpreventionClaimDataSuccess"), ChatFormatting.GOLD), true);
        }
        if (PlayerClaimData.readGriefPreventionPlayerData(src.m_81377_(), src)) {
            src.m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("readGriefpreventionPlayerDataSuccess"), ChatFormatting.GOLD), true);
        }
        return 1;
    }

    private static int giveClaimBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.giveClaimBlocks(context, false);
    }

    private static int giveClaimBlocks(CommandContext<CommandSourceStack> context, boolean base) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        ArrayList<String> players = new ArrayList<String>();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (GameProfile prof : GameProfileArgument.m_94590_(context, (String)"players")) {
            ServerPlayer player = src.m_81377_().m_6846_().m_11259_(prof.getId());
            if (player != null) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (base) {
                    data.addClaimBlocksDirect(amount);
                } else {
                    data.setAdditionalClaims(data.getAdditionalClaims() + amount);
                }
            } else {
                PlayerClaimData.editForOfflinePlayer(src.m_81377_(), prof.getId(), amount, base);
            }
            players.add(prof.getName());
        }
        src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get(base ? "giveClaimBlocks" : "giveClaimBlocksBonus"), players, amount), ChatFormatting.GOLD), true);
        return 1;
    }

    private static int addGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyGroup(context, false);
    }

    private static int removeGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyGroup(context, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int modifyGroup(CommandContext<CommandSourceStack> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String group = StringArgumentType.getString(context, (String)"group");
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(player.m_20183_());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.m_20183_())) != null) {
            claim = sub;
        }
        if (remove) {
            if (claim.removePermGroup(player, group)) {
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("groupRemove"), group), ChatFormatting.GOLD), false);
                return 1;
            }
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermission"), ChatFormatting.DARK_RED), false);
            return 0;
        }
        if (claim.groups().contains(group)) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("groupExist"), group), ChatFormatting.RED), false);
            return 0;
        }
        if (claim.editPerms(player, group, BuiltinPermission.EDITPERMS, -1)) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("groupAdd"), group), ChatFormatting.GOLD), false);
            return 1;
        }
        player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermission"), ChatFormatting.DARK_RED), false);
        return 0;
    }

    private static int forceAddPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return CommandClaim.modifyPlayer(context, group, true);
    }

    private static int addPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return CommandClaim.modifyPlayer(context, group, false);
    }

    private static int removePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyPlayer(context, null, false);
    }

    private static int modifyPlayer(CommandContext<CommandSourceStack> context, String group, boolean force) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(player.m_20183_());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.m_20183_())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_())) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermission"), ChatFormatting.DARK_RED), false);
            return 0;
        }
        ArrayList<String> modified = new ArrayList<String>();
        for (GameProfile prof : GameProfileArgument.m_94590_(context, (String)"players")) {
            if (!claim.setPlayerGroup(prof.getId(), group, force)) continue;
            modified.add(prof.getName());
        }
        if (!modified.isEmpty()) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("playerModify"), group, modified), ChatFormatting.GOLD), false);
        } else {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("playerModifyNo"), group), ChatFormatting.RED), false);
        }
        return modified.size();
    }

    private static int toggleFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerClaimData data;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        data.setFakePlayerNotif(!(data = PlayerClaimData.get(player)).hasFakePlayerNotificationOn());
        player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("fakePlayerNotification"), data.hasFakePlayerNotificationOn()), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int addFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyFakePlayer(context, false);
    }

    private static int removeFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyFakePlayer(context, true);
    }

    private static int modifyFakePlayer(CommandContext<CommandSourceStack> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(player.m_20183_());
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.m_20183_())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_())) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermission"), ChatFormatting.DARK_RED), false);
            return 0;
        }
        UUID uuid = UuidArgument.m_113853_(context, (String)"uuid");
        if (claim.modifyFakePlayerUUID(uuid, remove)) {
            if (!remove) {
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("uuidFakeAdd"), uuid), ChatFormatting.GOLD), false);
            } else {
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("uuidFakeRemove"), uuid), ChatFormatting.GOLD), false);
            }
            return 1;
        }
        player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("uuidFakeModifyNo"), ChatFormatting.RED), false);
        return 0;
    }

    private static int editGlobalPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return CommandClaim.editPerms(context, null, mode);
    }

    private static int editGroupPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return CommandClaim.editPerms(context, StringArgumentType.getString(context, (String)"group"), mode);
    }

    private static int editPerms(CommandContext<CommandSourceStack> context, String group, int mode) throws CommandSyntaxException {
        String setPerm;
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Claim claim = ClaimStorage.get(player.m_284548_()).getClaimAt(player.m_20183_());
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.m_20183_())) != null) {
            claim = sub;
        }
        if (claim == null) {
            PermHelper.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get(player).getEditMode() == EnumEditMode.SUBCLAIM && (sub = claim.getSubClaim(player.m_20183_())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_())) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermission"), ChatFormatting.DARK_RED), false);
            return 0;
        }
        ResourceLocation perm = ResourceLocationArgument.m_107011_(context, (String)"permission");
        if (group != null && PermissionManager.INSTANCE.isGlobalPermission(perm)) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("nonGlobalOnly"), perm), ChatFormatting.DARK_RED), false);
            return 0;
        }
        if (PermissionManager.INSTANCE.get(perm) == null) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("noSuchPerm"), perm), ChatFormatting.DARK_RED), false);
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (group == null) {
            claim.editGlobalPerms(player, perm, mode);
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("editPerm"), perm, setPerm), ChatFormatting.GOLD), false);
        } else {
            claim.editPerms(player, group, perm, mode);
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("editPermGroup"), perm, group, setPerm), ChatFormatting.GOLD), false);
        }
        return 1;
    }

    private static int editPersonalPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String setPerm;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String group = StringArgumentType.getString(context, (String)"group");
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        ResourceLocation perm = ResourceLocationArgument.m_107011_(context, (String)"permission");
        if (PermissionManager.INSTANCE.isGlobalPermission(perm)) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("nonGlobalOnly"), perm), ChatFormatting.DARK_RED), false);
            return 0;
        }
        if (PermissionManager.INSTANCE.get(perm) == null) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("noSuchPerm"), perm), ChatFormatting.DARK_RED), false);
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (PlayerClaimData.get(player).editDefaultPerms(group, perm, mode)) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("editPersonalGroup"), group, perm, setPerm), ChatFormatting.GOLD), false);
        }
        return 1;
    }

    public static int setClaimHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITCLAIM, PermHelper.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        claim.setHomePos(player.m_20183_());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("setHome"), player.m_20183_().m_123341_(), player.m_20183_().m_123342_(), player.m_20183_().m_123343_()), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int expandClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Claim claim = PermHelper.checkReturn(player, BuiltinPermission.EDITCLAIM, PermHelper.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        int amount = IntegerArgumentType.getInteger(context, (String)"distance");
        int[] dims = claim.getDimensions();
        int x = dims[0];
        int X = dims[1];
        int z = dims[2];
        int Z = dims[3];
        int y = dims[4];
        Direction facing = player.m_6350_();
        Tuple cornerPair = switch (facing) {
            case Direction.SOUTH -> new Tuple((Object)new BlockPos(X, y, Z), (Object)new BlockPos(X, y, Z + amount));
            case Direction.EAST -> new Tuple((Object)new BlockPos(X, y, Z), (Object)new BlockPos(X + amount, y, Z));
            case Direction.NORTH -> new Tuple((Object)new BlockPos(x, y, z), (Object)new BlockPos(x, y, z - amount));
            case Direction.WEST -> new Tuple((Object)new BlockPos(x, y, z), (Object)new BlockPos(x - amount, y, z));
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
        };
        return storage.resizeClaim(claim, (BlockPos)cornerPair.m_14418_(), (BlockPos)cornerPair.m_14419_(), player) ? 1 : 0;
    }

    public static int teleport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.teleport(context, ((CommandSourceStack)context.getSource()).m_81375_().m_20148_());
    }

    public static int teleportAdminClaims(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.teleport(context, null);
    }

    public static int teleport(CommandContext<CommandSourceStack> context, UUID owner) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String name = StringArgumentType.getString(context, (String)"claim");
        Optional<Claim> claims = ClaimStorage.get(player.m_284548_()).allClaimsFromPlayer(owner).stream().filter(claim -> {
            if (claim.getClaimName().isEmpty()) {
                return claim.getClaimID().toString().equals(name);
            }
            return claim.getClaimName().equals(name);
        }).findFirst();
        if (claims.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("teleportNoClaim"), ChatFormatting.RED), false);
            return 0;
        }
        return claims.map(claim -> {
            BlockPos pos = claim.getHomePos();
            if (claim.canInteract(player, BuiltinPermission.TELEPORT, pos, false)) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (data.setTeleportTo(pos)) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("teleportHome"), ChatFormatting.GOLD), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("teleportHomeFail"), ChatFormatting.RED), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionSimple"), ChatFormatting.DARK_RED), false);
            }
            return 0;
        }).orElse(0);
    }

    public static int editClaimMessages(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.editClaimMessages(context, (Component)Component.m_237113_((String)StringArgumentType.getString(context, (String)"message")));
    }

    public static int editClaimMessages(CommandContext<CommandSourceStack> context, Component text) throws CommandSyntaxException {
        String feedback;
        Claim claim;
        if (text instanceof MutableComponent) {
            Style style = text.m_7383_();
            if (style.m_131179_()) {
                style = style.m_131157_(ChatFormatting.WHITE);
            }
            if (!style.m_131161_()) {
                style = style.m_131155_(Boolean.valueOf(false));
            }
            ((MutableComponent)text).m_6270_(style);
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = PermHelper.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, PermHelper.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getEditMode() == EnumEditMode.SUBCLAIM ? rootClaim.getSubClaim(player.m_20183_()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        boolean sub = StringArgumentType.getString(context, (String)"title").equals("subtitle");
        boolean enter = StringArgumentType.getString(context, (String)"type").equals("enter");
        if (enter) {
            if (sub) {
                claim.setEnterTitle(claim.enterTitle, text);
                feedback = ConfigHandler.LANG_MANAGER.get("setEnterSubMessage");
            } else {
                claim.setEnterTitle(text, claim.enterSubtitle);
                feedback = ConfigHandler.LANG_MANAGER.get("setEnterMessage");
            }
        } else if (sub) {
            claim.setLeaveTitle(claim.leaveTitle, text);
            feedback = ConfigHandler.LANG_MANAGER.get("setLeaveSubMessage");
        } else {
            claim.setLeaveTitle(text, claim.leaveSubtitle);
            feedback = ConfigHandler.LANG_MANAGER.get("setLeaveMessage");
        }
        MutableComponent cmdFeed = Component.m_237110_((String)feedback, (Object[])new Object[]{text}).m_130940_(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> cmdFeed, false);
        return 1;
    }

    public static int addClaimListEntries(CommandContext<CommandSourceStack> context, CustomInteractListScreenHandler.Type type) throws CommandSyntaxException {
        Claim claim;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = PermHelper.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, PermHelper.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getEditMode() == EnumEditMode.SUBCLAIM ? rootClaim.getSubClaim(player.m_20183_()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        String result = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CustomInteractListScreenHandler.Type.ITEM -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.f_257033_, claim.allowedItems);
            case CustomInteractListScreenHandler.Type.BLOCKBREAK -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.f_256975_, claim.allowedBreakBlocks);
            case CustomInteractListScreenHandler.Type.BLOCKUSE -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.f_256975_, claim.allowedUseBlocks);
            case CustomInteractListScreenHandler.Type.ENTITYATTACK -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.f_256780_, claim.allowedEntityAttack);
            case CustomInteractListScreenHandler.Type.ENTITYUSE -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.f_256780_, claim.allowedEntityUse);
        };
        MutableComponent cmdFeed = Component.m_237110_((String)ConfigHandler.LANG_MANAGER.get("addIgnoreEntry"), (Object[])new Object[]{result, type.commandKey}).m_130940_(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> cmdFeed, false);
        return 1;
    }

    public static int removeClaimListEntries(CommandContext<CommandSourceStack> context, CustomInteractListScreenHandler.Type type) throws CommandSyntaxException {
        Claim claim;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = PermHelper.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, PermHelper.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getEditMode() == EnumEditMode.SUBCLAIM ? rootClaim.getSubClaim(player.m_20183_()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        String value = ((ResourceOrTagKeyArgument.Result)context.getArgument("entry", ResourceOrTagKeyArgument.Result.class)).m_245390_();
        switch (type) {
            case ITEM: {
                claim.allowedItems.removeAllowedItem(value);
                break;
            }
            case BLOCKBREAK: {
                claim.allowedBreakBlocks.removeAllowedItem(value);
                break;
            }
            case BLOCKUSE: {
                claim.allowedUseBlocks.removeAllowedItem(value);
                break;
            }
            case ENTITYATTACK: {
                claim.allowedEntityAttack.removeAllowedItem(value);
                break;
            }
            case ENTITYUSE: {
                claim.allowedEntityUse.removeAllowedItem(value);
            }
        }
        MutableComponent cmdFeed = Component.m_237110_((String)ConfigHandler.LANG_MANAGER.get("removeIgnoreEntry"), (Object[])new Object[]{value, type.commandKey}).m_130940_(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> cmdFeed, false);
        return 1;
    }

    private static int sellClaimBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean b = ConfigHandler.CONFIG.buySellHandler.sell(((CommandSourceStack)context.getSource()).m_81375_(), Math.max(0, IntegerArgumentType.getInteger(context, (String)"amount")), m -> ((CommandSourceStack)context.getSource()).m_288197_(() -> m, false));
        return b ? 1 : 0;
    }

    private static int buyClaimBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean b = ConfigHandler.CONFIG.buySellHandler.buy(((CommandSourceStack)context.getSource()).m_81375_(), Math.max(0, IntegerArgumentType.getInteger(context, (String)"amount")), m -> ((CommandSourceStack)context.getSource()).m_288197_(() -> m, false));
        return b ? 1 : 0;
    }

    private static <T> String addClaimListEntry(CommandContext<CommandSourceStack> context, Registry<T> registry, AllowedRegistryList<T> list) throws CommandSyntaxException {
        ResourceOrTagKeyArgument.Result value = CommandHelpers.getRegistryType(context, "entry", registry.m_123023_());
        value.m_245276_().ifRight(tag -> list.addAllowedItem(Either.right((Object)tag))).ifLeft(id -> {
            Object entry = registry.m_6246_(id);
            if (entry != Items.f_41852_) {
                list.addAllowedItem(Either.left((Object)entry));
            }
        });
        return value.m_245390_();
    }

    private static /* synthetic */ Component lambda$listClaimsFromUUID$94(OfflinePlayerData data) {
        return PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBlocksFormat"), data.claimBlocks, data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks()), ChatFormatting.GOLD);
    }

    private static /* synthetic */ Component lambda$listClaimsFromUUID$93(PlayerClaimData data) {
        return PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBlocksFormat"), data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks()), ChatFormatting.GOLD);
    }
}

