/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.EnumEditMode;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemInteractEvents {
    private static final Set<Item> blackListedItems = Sets.newHashSet((Object[])new Item[]{Items.f_42522_, Items.f_42573_, Items.f_42688_});

    public static InteractionResultHolder<ItemStack> useItem(Player p, Level world, InteractionHand hand) {
        Claim real;
        IPermissionContainer claim;
        ServerPlayer player;
        block15: {
            block14: {
                if (!(p instanceof ServerPlayer)) break block14;
                player = (ServerPlayer)p;
                if (!p.m_5833_()) break block15;
            }
            return InteractionResultHolder.m_19098_((Object)p.m_21120_(hand));
        }
        ItemStack stack = player.m_21120_(hand);
        if (ConfigHandler.isClaimingTool(stack)) {
            HitResult ray = player.m_19907_(64.0, 0.0f, false);
            if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
                ItemInteractEvents.claimLandHandling(player, ((BlockHitResult)ray).m_82425_());
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (ConfigHandler.isInspectionTool(stack)) {
            HitResult ray = player.m_19907_(32.0, 0.0f, false);
            if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
                ItemInteractEvents.inspect(player, ((BlockHitResult)ray).m_82425_());
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        BlockPos pos = player.m_20183_();
        BlockHitResult hitResult = ItemInteractEvents.getPlayerHitResult(world, (Player)player, ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            pos = new BlockPlaceContext((Player)player, hand, stack, hitResult).m_8083_();
        }
        if ((claim = storage.getForPermissionCheck(pos)) == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (claim instanceof Claim && (real = (Claim)claim).canUseItem(stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ResourceLocation perm = ObjectToPermissionMap.getFromItem(stack.m_41720_());
        if (perm != null) {
            boolean success = claim.canInteract(player, perm, pos, true);
            if (success) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (perm.equals((Object)BuiltinPermission.PLACE)) {
                BlockPos update = pos;
                if (stack.m_41720_() == Items.f_42094_) {
                    BlockHitResult upResult = hitResult.m_82430_(hitResult.m_82425_().m_7494_());
                    update = new BlockPlaceContext(new UseOnContext((Player)player, hand, upResult)).m_8083_();
                }
                player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(update, world.m_8055_(update)));
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
                ItemInteractEvents.updateHeldItem(player);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static InteractionResult onItemUseBlock(UseOnContext context) {
        ServerPlayer player;
        block5: {
            block4: {
                Player player2 = context.m_43723_();
                if (!(player2 instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)player2;
                if (!context.m_43722_().m_41619_()) break block5;
            }
            return InteractionResult.PASS;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)context.m_43725_());
        BlockPos interactPos = context.m_8083_();
        InteractionResult interact = ItemInteractEvents.itemUseOn(context.m_43725_(), player, storage, interactPos, context.m_43722_());
        if (interact != InteractionResult.PASS) {
            return interact;
        }
        BlockPos placePos = new BlockPlaceContext(context).m_8083_();
        return ItemInteractEvents.itemUseOn(context.m_43725_(), player, storage, placePos, context.m_43722_());
    }

    private static InteractionResult itemUseOn(Level level, ServerPlayer player, ClaimStorage storage, BlockPos placePos, ItemStack stack) {
        Claim real;
        boolean actualInClaim;
        IPermissionContainer claim = storage.getForPermissionCheck(placePos.m_7918_(0, 255, 0));
        if (claim == null) {
            return InteractionResult.PASS;
        }
        if (blackListedItems.contains(stack.m_41720_())) {
            return InteractionResult.PASS;
        }
        boolean bl = actualInClaim = !(claim instanceof Claim) || placePos.m_123342_() >= ((Claim)claim).getDimensions()[4];
        if (actualInClaim && claim instanceof Claim && (real = (Claim)claim).canUseItem(stack)) {
            return InteractionResult.PASS;
        }
        ResourceLocation perm = ObjectToPermissionMap.getFromItem(stack.m_41720_());
        if (perm != null) {
            if (claim.canInteract(player, perm, placePos, false)) {
                return InteractionResult.PASS;
            }
            if (actualInClaim) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionSimple"), ChatFormatting.DARK_RED), true);
                return InteractionResult.FAIL;
            }
        }
        if (claim.canInteract(player, BuiltinPermission.PLACE, placePos, false)) {
            if (!actualInClaim && stack.m_41720_() instanceof BlockItem) {
                ((Claim)claim).extendDownwards(placePos);
            }
            return InteractionResult.PASS;
        }
        if (actualInClaim) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermissionSimple"), ChatFormatting.DARK_RED), true);
            BlockState other = level.m_8055_(placePos.m_7494_());
            player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(placePos.m_7494_(), other));
            PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
            ItemInteractEvents.updateHeldItem(player);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private static void updateHeldItem(ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, player.m_150109_().f_35977_, player.m_150109_().m_36056_()));
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, 40, player.m_150109_().m_8020_(40)));
    }

    private static boolean cantClaimInWorld(ServerLevel world) {
        for (String s : ConfigHandler.CONFIG.blacklistedWorlds) {
            if (!s.equals(world.m_46472_().m_135782_().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean canClaimWorld(ServerLevel world, ServerPlayer player) {
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.isAdminIgnoreClaim()) {
            return true;
        }
        if (ConfigHandler.CONFIG.worldWhitelist) {
            if (!ItemInteractEvents.cantClaimInWorld(player.m_284548_())) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("landClaimDisabledWorld"), ChatFormatting.DARK_RED), false);
                return false;
            }
        } else if (ItemInteractEvents.cantClaimInWorld(player.m_284548_())) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("landClaimDisabledWorld"), ChatFormatting.DARK_RED), false);
            return false;
        }
        return true;
    }

    public static void claimLandHandling(ServerPlayer player, BlockPos target) {
        if (!PermissionNodeHandler.INSTANCE.perm(player, "flan.claim.create", false)) {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("noPermission"), ChatFormatting.DARK_RED), true);
            return;
        }
        if (!ItemInteractEvents.canClaimWorld(player.m_284548_(), player)) {
            return;
        }
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim claim = storage.getClaimAt(target.m_7918_(0, 255, 0));
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.claimCooldown()) {
            return;
        }
        data.setClaimActionCooldown();
        if (claim != null) {
            if (claim.canInteract(player, BuiltinPermission.EDITCLAIM, target)) {
                if (data.getEditMode() == EnumEditMode.SUBCLAIM) {
                    Claim subClaim = claim.getSubClaim(target);
                    if (subClaim != null && data.currentEdit() == null) {
                        if (subClaim.isCorner(target)) {
                            data.setEditClaim(subClaim, player.m_20183_().m_123342_());
                            data.setEditingCorner(target);
                            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("resizeClaim"), ChatFormatting.GOLD), false);
                        } else {
                            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("cantClaimHere"), ChatFormatting.RED), false);
                        }
                        data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
                    } else if (data.currentEdit() != null) {
                        if (!data.editingCorner().equals((Object)target)) {
                            Set<Claim> fl = claim.resizeSubclaim(data.currentEdit(), data.editingCorner(), target);
                            if (!fl.isEmpty()) {
                                fl.forEach(confl -> data.addDisplayClaim((IPermissionContainer)confl, EnumDisplayType.MAIN, player.m_20183_().m_123342_()));
                                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("conflictOther"), ChatFormatting.RED), false);
                            }
                            data.setEditClaim(null, 0);
                            data.setEditingCorner(null);
                        }
                    } else if (data.editingCorner() != null) {
                        if (!data.editingCorner().equals((Object)target)) {
                            Set<Claim> fl = claim.tryCreateSubClaim(data.editingCorner(), target);
                            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
                            if (!fl.isEmpty()) {
                                fl.forEach(confl -> data.addDisplayClaim((IPermissionContainer)confl, EnumDisplayType.CONFLICT, player.m_20183_().m_123342_()));
                                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("conflictOther"), ChatFormatting.RED), false);
                            } else {
                                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("subClaimCreateSuccess"), ChatFormatting.GOLD), false);
                            }
                            data.setEditingCorner(null);
                        }
                    } else {
                        data.setEditingCorner(target);
                    }
                } else if (claim.isCorner(target)) {
                    data.setEditClaim(claim, player.m_20183_().m_123342_());
                    data.setEditingCorner(target);
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("resizeClaim"), ChatFormatting.GOLD), false);
                } else if (data.currentEdit() != null) {
                    storage.resizeClaim(data.currentEdit(), data.editingCorner(), target, player);
                    data.setEditClaim(null, 0);
                    data.setEditingCorner(null);
                } else {
                    data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("cantClaimHere"), ChatFormatting.RED), false);
                }
            } else {
                data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("cantClaimHere"), ChatFormatting.RED), false);
            }
        } else if (data.getEditMode() == EnumEditMode.SUBCLAIM) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("wrongMode"), new Object[]{data.getEditMode()}), ChatFormatting.RED), false);
        } else if (data.currentEdit() != null) {
            storage.resizeClaim(data.currentEdit(), data.editingCorner(), target, player);
            data.setEditClaim(null, 0);
            data.setEditingCorner(null);
        } else if (data.editingCorner() != null) {
            storage.createClaim(data.editingCorner(), target, player);
            data.setEditingCorner(null);
        } else {
            data.setEditingCorner(target);
        }
    }

    public static void inspect(ServerPlayer player, BlockPos target) {
        Claim claim = ClaimStorage.get(player.m_284548_()).getClaimAt(target);
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.claimCooldown()) {
            return;
        }
        data.setClaimActionCooldown();
        if (claim != null) {
            String owner = claim.isAdminClaim() ? "<Admin>" : player.m_20194_().m_129927_().m_11002_(claim.getOwner()).map(GameProfile::getName).orElse("<UNKOWN>");
            MutableComponent text = PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("inspectBlockOwner"), owner, target.m_123341_(), target.m_123342_(), target.m_123343_()), ChatFormatting.GREEN);
            player.m_5661_((Component)text, false);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
        } else {
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("inspectNoClaim"), ChatFormatting.RED), false);
        }
    }

    protected static BlockHitResult getPlayerHitResult(Level level, Player player, ClipContext.Fluid fluidMode) {
        float xRot = player.m_146909_();
        float yRot = player.m_146908_();
        Vec3 eye = player.m_146892_();
        float h = Mth.m_14089_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.m_14031_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.m_14089_((float)(-xRot * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)(-xRot * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        Vec3 vec32 = eye.m_82520_((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return level.m_45547_(new ClipContext(eye, vec32, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }
}

