/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.LogoutTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class PlayerEvents {
    public static void saveClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).save(player.m_20194_());
        }
    }

    public static void readClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).read(player.m_20194_());
        }
    }

    public static void onLogout(Player player) {
        if (player.m_20194_() != null) {
            LogoutTracker.getInstance(player.m_20194_()).track(player.m_20148_());
        }
    }

    public static boolean growBonemeal(UseOnContext context) {
        Player player = context.m_43723_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockState state = serverPlayer.m_9236_().m_8055_(context.m_8083_());
            BlockPos.MutableBlockPos pos = context.m_8083_().m_122032_();
            ResourceLocation perm = ObjectToPermissionMap.getFromItem(context.m_43722_().m_41720_());
            if (perm != null && !ClaimStorage.get(serverPlayer.m_284548_()).getForPermissionCheck((BlockPos)pos).canInteract(serverPlayer, perm, (BlockPos)pos, false)) {
                return false;
            }
            int range = 0;
            Registry registry = serverPlayer.m_9236_().m_9598_().m_175515_(Registries.f_256911_);
            if (state.m_60734_() instanceof MossBlock) {
                VegetationPatchConfiguration cfg = PlayerEvents.featureRange(registry, CaveFeatures.f_194951_, VegetationPatchConfiguration.class);
                if (cfg != null) {
                    range = cfg.f_161289_.m_142737_() + 1;
                    pos.m_122178_(pos.m_123341_(), pos.m_123342_() + cfg.f_161287_ + 1, pos.m_123343_());
                }
            } else if (state.m_60734_() instanceof GrassBlock) {
                range = 4;
            } else if (state.m_60713_(Blocks.f_50699_)) {
                NetherForestVegetationConfig cfg = PlayerEvents.featureRange(registry, NetherFeatures.f_195037_, NetherForestVegetationConfig.class);
                if (cfg != null) {
                    range = cfg.f_191259_;
                    pos.m_122178_(pos.m_123341_(), pos.m_123342_() + cfg.f_191260_ + 1, pos.m_123343_());
                }
            } else if (state.m_60713_(Blocks.f_50690_)) {
                NetherForestVegetationConfig cfg = PlayerEvents.featureRange(registry, NetherFeatures.f_195040_, NetherForestVegetationConfig.class);
                NetherForestVegetationConfig cfg2 = PlayerEvents.featureRange(registry, NetherFeatures.f_195042_, NetherForestVegetationConfig.class);
                TwistingVinesConfig cfg3 = PlayerEvents.featureRange(registry, NetherFeatures.f_195044_, TwistingVinesConfig.class);
                int w1 = cfg == null ? 0 : cfg.f_191259_;
                int w2 = cfg2 == null ? 0 : cfg2.f_191259_;
                int w3 = cfg3 == null ? 0 : cfg3.f_191365_();
                int h1 = cfg == null ? 0 : cfg.f_191260_;
                int h2 = cfg2 == null ? 0 : cfg2.f_191260_;
                int h3 = cfg3 == null ? 0 : cfg3.f_191366_();
                range = Math.max(Math.max(w1, w2), w3);
                int y = Math.max(Math.max(h1, h2), h3);
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + y + 1, pos.m_123343_());
            }
            if (range > 0 && perm != null && !ClaimStorage.get(serverPlayer.m_284548_()).canInteract((BlockPos)pos, range, serverPlayer, perm, false)) {
                serverPlayer.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("tooCloseClaim"), ChatFormatting.DARK_RED), true);
                return true;
            }
        }
        return false;
    }

    public static float canSpawnFromPlayer(Entity entity, float old) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BlockPos pos = player.m_20183_();
            if (!ClaimStorage.get(player.m_284548_()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.PLAYERMOBSPAWN, pos, false)) {
                return -1.0f;
            }
        }
        return old;
    }

    public static boolean canWardenSpawnTrigger(BlockPos pos, ServerPlayer player) {
        return ClaimStorage.get(player.m_284548_()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.PLAYERMOBSPAWN, pos, false);
    }

    public static boolean canSculkTrigger(BlockPos pos, ServerPlayer player) {
        return ClaimStorage.get(player.m_284548_()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.SCULK, pos, false);
    }

    public static <T extends FeatureConfiguration> T featureRange(Registry<ConfiguredFeature<?, ?>> registry, ResourceKey<ConfiguredFeature<?, ?>> key, Class<T> clss) {
        return (T)((FeatureConfiguration)registry.m_203636_(key).map(r -> {
            if (clss.isInstance(((ConfiguredFeature)r.m_203334_()).f_65378_())) {
                return ((ConfiguredFeature)r.m_203334_()).f_65378_();
            }
            return null;
        }).orElse(null));
    }
}

