/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.forge.platform.integration.claiming;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.claiming.FTBChunks;
import io.github.flemmli97.flan.platform.integration.claiming.OtherClaimingModCheck;
import io.github.flemmli97.flan.player.display.DisplayBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class OtherClaimingModCheckImpl
implements OtherClaimingModCheck {
    @Override
    public void findConflicts(Claim claim, Set<DisplayBox> set) {
        FTBChunks.findConflicts(claim, set);
        if (Flan.mineColonies && ConfigHandler.CONFIG.mineColoniesCheck) {
            ServerLevel level = claim.getWorld();
            int[] chunks = ClaimStorage.getChunkPos(claim);
            HashMap<IColony, List> map = new HashMap<IColony, List>();
            for (int x = chunks[0]; x <= chunks[1]; ++x) {
                for (int z = chunks[2]; z <= chunks[3]; ++z) {
                    IColony colony2 = IColonyManager.getInstance().getColonyByPosFromWorld((Level)level, new BlockPos(x << 4, 0, z << 4));
                    if (colony2 == null || colony2.getPermissions().hasPermission(colony2.getPermissions().getRank(claim.getOwner()), Action.EDIT_PERMISSIONS)) continue;
                    map.computeIfAbsent(colony2, c -> new ArrayList()).add(new ChunkPos(x, z));
                }
            }
            map.forEach((colony, poss) -> poss.forEach(pos -> {
                int blockX = pos.f_45578_ << 4;
                int blockZ = pos.f_45579_ << 4;
                set.add(new DisplayBox(blockX, level.m_141937_(), blockZ, blockX + 15, level.m_151558_(), blockZ + 15, () -> false, OtherClaimingModCheckImpl.neighbors(pos, poss)));
            }));
        }
    }

    private static Direction[] neighbors(ChunkPos pos, List<ChunkPos> others) {
        ArrayList<Direction> dirs = new ArrayList<Direction>();
        if (others.contains(new ChunkPos(pos.f_45578_, pos.f_45579_ - 1))) {
            dirs.add(Direction.NORTH);
        }
        if (others.contains(new ChunkPos(pos.f_45578_, pos.f_45579_ + 1))) {
            dirs.add(Direction.SOUTH);
        }
        if (others.contains(new ChunkPos(pos.f_45578_ + 1, pos.f_45579_))) {
            dirs.add(Direction.EAST);
        }
        if (others.contains(new ChunkPos(pos.f_45578_ - 1, pos.f_45579_))) {
            dirs.add(Direction.WEST);
        }
        return dirs.toArray(new Direction[0]);
    }
}

