/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.GroupPlayerScreenHandler;
import io.github.flemmli97.flan.gui.PermissionScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GroupScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private final Claim claim;
    private boolean removeMode;

    private GroupScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
        this.claim = claim;
    }

    public static void openGroupMenu(Player player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new GroupScreenHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("screenGroups"), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, Claim claim) {
        for (int i = 0; i < 54; ++i) {
            ItemStack stack;
            if (i == 0) {
                stack = new ItemStack((ItemLike)Items.f_41996_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenBack"), ChatFormatting.DARK_RED));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 3) {
                stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenAdd"), ChatFormatting.DARK_GREEN));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenRemoveMode"), this.removeMode ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse")), ChatFormatting.DARK_RED));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            List<String> groups = claim.groups();
            if (id >= groups.size()) continue;
            ItemStack group = new ItemStack((ItemLike)Items.f_42516_);
            group.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenGroupName"), groups.get(id)), ChatFormatting.DARK_BLUE));
            inv.updateStack(i, group);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                this.claim.editPerms(player, (String)s, BuiltinPermission.EDITPERMS, -1);
                player.m_6915_();
                player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenRemoveMode"), this.removeMode ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse")), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            String name = stack.m_41786_().getString();
            if (this.removeMode) {
                this.claim.removePermGroup(player, name);
                slot.m_5852_(ItemStack.f_41583_);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
            } else {
                if (clickType == 1) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> PermissionScreenHandler.openClaimMenu((Player)player, this.claim, name));
                } else {
                    player.m_6915_();
                    player.m_20194_().execute(() -> GroupPlayerScreenHandler.openPlayerGroupMenu((Player)player, this.claim, name));
                }
                ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            }
        }
        return false;
    }
}

