/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ServerScreenHelper {
    public static final String PERMISSION_KEY = "flan.permission";

    public static ItemStack emptyFiller() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42183_);
        stack.m_41714_((Component)PermHelper.simpleColoredText("", new ChatFormatting[0]));
        return stack;
    }

    public static ItemStack fromPermission(Claim claim, ClaimPermission perm, String group) {
        ItemStack stack = perm.getItem();
        stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get(perm.translationKey()), ChatFormatting.GOLD));
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String pdesc : ConfigHandler.LANG_MANAGER.getArray(perm.translationKeyDescription())) {
            Component trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add(trans);
        }
        Config.GlobalType global = ConfigHandler.CONFIG.getGlobal(claim.getWorld(), perm.getId());
        if (!claim.isAdminClaim() && !global.canModify()) {
            Component text = ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenUneditable"), ChatFormatting.DARK_RED);
            lore.add(text);
            String permFlag = global.getValue() ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse");
            Component text2 = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenEnableText"), permFlag), permFlag.equals(ConfigHandler.LANG_MANAGER.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add(text2);
        } else {
            Object permFlag;
            if (group == null) {
                if (claim.parentClaim() == null) {
                    permFlag = "" + (claim.permEnabled(perm.getId()) == 1);
                } else {
                    permFlag = switch (claim.permEnabled(perm.getId())) {
                        case -1 -> ConfigHandler.LANG_MANAGER.get("screenDefault");
                        case 1 -> ConfigHandler.LANG_MANAGER.get("screenTrue");
                        default -> ConfigHandler.LANG_MANAGER.get("screenFalse");
                    };
                }
            } else {
                permFlag = switch (claim.groupHasPerm(group, perm.getId())) {
                    case -1 -> ConfigHandler.LANG_MANAGER.get("screenDefault");
                    case 1 -> ConfigHandler.LANG_MANAGER.get("screenTrue");
                    default -> ConfigHandler.LANG_MANAGER.get("screenFalse");
                };
            }
            Component text = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenEnableText"), permFlag), ((String)permFlag).equals(ConfigHandler.LANG_MANAGER.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add(text);
        }
        ServerScreenHelper.addLore(stack, lore);
        CompoundTag tag = stack.m_41783_();
        tag.m_128359_(PERMISSION_KEY, perm.getId().toString());
        return stack;
    }

    public static ItemStack getFromPersonal(ServerPlayer player, ClaimPermission perm, String group) {
        ItemStack stack = perm.getItem();
        stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get(perm.translationKey()), ChatFormatting.GOLD));
        ListTag lore = new ListTag();
        for (String pdesc : ConfigHandler.LANG_MANAGER.getArray(perm.translationKeyDescription())) {
            Component trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)trans)));
        }
        Config.GlobalType global = ConfigHandler.CONFIG.getGlobal(player.m_284548_(), perm.getId());
        if (!global.canModify()) {
            Component text = ServerScreenHelper.coloredGuiText(ConfigHandler.LANG_MANAGER.get("screenUneditable"), ChatFormatting.DARK_RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
            String permFlag = String.valueOf(global.getValue());
            Component text2 = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenEnableText"), permFlag), permFlag.equals(ConfigHandler.LANG_MANAGER.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text2)));
        } else {
            Map map = PlayerClaimData.get(player).playerDefaultGroups().getOrDefault(group, new HashMap());
            String permFlag = map.containsKey(perm.getId()) ? ((Boolean)map.get(perm.getId()) != false ? ConfigHandler.LANG_MANAGER.get("screenTrue") : ConfigHandler.LANG_MANAGER.get("screenFalse")) : ConfigHandler.LANG_MANAGER.get("screenDefault");
            Component text = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.LANG_MANAGER.get("screenEnableText"), permFlag), permFlag.equals(ConfigHandler.LANG_MANAGER.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(PERMISSION_KEY, perm.getId().toString());
        CompoundTag display = tag.m_128441_("display") ? tag.m_128469_("display") : new CompoundTag();
        display.m_128365_("Lore", (Tag)lore);
        return stack;
    }

    public static void playSongToPlayer(ServerPlayer player, SoundEvent event, float vol, float pitch) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)event), SoundSource.PLAYERS, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, vol, pitch, player.m_9236_().m_213780_().m_188505_()));
    }

    public static void playSongToPlayer(ServerPlayer player, Holder<SoundEvent> event, float vol, float pitch) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(event, SoundSource.PLAYERS, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, vol, pitch, player.m_9236_().m_213780_().m_188505_()));
    }

    public static Component coloredGuiText(String text, ChatFormatting ... formattings) {
        return Component.m_237113_((String)text).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131152_(formattings));
    }

    public static void addLore(ItemStack stack, Component text) {
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
    }

    public static void addLore(ItemStack stack, List<Component> texts) {
        ListTag lore = new ListTag();
        texts.forEach(text -> lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text))));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
    }
}

