/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ParticleIndicators;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.EntityInteractEvents;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.EnumEditMode;
import io.github.flemmli97.flan.player.display.ClaimDisplay;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import io.github.flemmli97.flan.scoreboard.ClaimCriterias;
import io.github.flemmli97.flan.utils.IPlayerClaimImpl;
import io.github.flemmli97.flan.utils.TeleportUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class PlayerClaimData
implements IPlayerData {
    private int claimBlocks;
    private int additionalClaimBlocks;
    private int confirmTick;
    private int actionCooldown;
    private int usedBlocks;
    private int lastBlockTick;
    private int trappedTick = -1;
    private int deathPickupTick;
    private Vec3 trappedPos;
    private BlockPos tpPos;
    private EnumEditMode mode = EnumEditMode.DEFAULT;
    private Claim editingClaim;
    private ClaimDisplay displayEditing;
    private BlockPos firstCorner;
    private int[] cornerRenderPos;
    private final Set<ClaimDisplay> claimDisplayList = new HashSet<ClaimDisplay>();
    private final Set<ClaimDisplay> displayToAdd = new HashSet<ClaimDisplay>();
    private final ServerPlayer player;
    private boolean confirmDeleteAll;
    private boolean adminIgnoreClaim;
    private boolean claimBlockMessage;
    private final Map<String, Map<ResourceLocation, Boolean>> defaultGroups = new HashMap<String, Map<ResourceLocation, Boolean>>();
    private boolean shouldProtectDrop;
    private boolean calculateShouldDrop = true;
    private final Map<UUID, Map<UUID, Long>> fakePlayerNotif = new HashMap<UUID, Map<UUID, Long>>();
    private boolean fakePlayerNotification = true;
    private long lastClaimTime;

    public PlayerClaimData(ServerPlayer player) {
        this.player = player;
        this.claimBlocks = ConfigHandler.CONFIG.startingBlocks;
    }

    public static PlayerClaimData get(ServerPlayer player) {
        return ((IPlayerClaimImpl)player).get();
    }

    @Override
    public int getClaimBlocks() {
        return Math.min(this.claimBlocks, PermissionNodeHandler.INSTANCE.permVal(this.player, "flan.claim.blocks.cap", this.claimBlocks)) + PermissionNodeHandler.INSTANCE.permVal(this.player, "flan.claim.blocks.bonus", 0);
    }

    public void setClaimBlocks(int amount) {
        this.claimBlocks = amount;
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.AMOUNT, this.claimBlocks + this.additionalClaimBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.FREE, this.claimBlocks + this.additionalClaimBlocks - this.usedBlocks);
    }

    public void addClaimBlocksDirect(int amount) {
        this.setClaimBlocks(this.claimBlocks + amount);
    }

    public boolean addClaimBlocks(int amount) {
        if (this.canIncrease(this.claimBlocks + amount)) {
            this.setClaimBlocks(this.claimBlocks + amount);
            return true;
        }
        return false;
    }

    private boolean canIncrease(int blocks) {
        return PermissionNodeHandler.INSTANCE.permBelowEqVal(this.player, "flan.claim.blocks.max", blocks, ConfigHandler.CONFIG.maxClaimBlocks);
    }

    @Override
    public int getAdditionalClaims() {
        return this.additionalClaimBlocks;
    }

    @Override
    public void setAdditionalClaims(int amount) {
        this.additionalClaimBlocks = Math.max(0, amount);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.AMOUNT, this.claimBlocks + this.additionalClaimBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.FREE, this.claimBlocks + this.additionalClaimBlocks - this.usedBlocks);
    }

    @Override
    public boolean canUseClaimBlocks(int amount) {
        if (ConfigHandler.CONFIG.maxClaimBlocks == -1) {
            return true;
        }
        return amount <= this.remainingClaimBlocks();
    }

    @Override
    public int usedClaimBlocks() {
        return this.calculateUsedClaimBlocks();
    }

    @Override
    public int remainingClaimBlocks() {
        return this.getClaimBlocks() + this.getAdditionalClaims() - this.usedClaimBlocks();
    }

    public long nextClaimCooldown() {
        return ConfigHandler.CONFIG.nextClaimCooldown <= 0 ? 0L : Math.max(0L, this.player.m_9236_().m_46467_() - this.lastClaimTime - (long)ConfigHandler.CONFIG.nextClaimCooldown);
    }

    public void updateLastClaim() {
        this.lastClaimTime = this.player.m_9236_().m_46467_();
    }

    public void setClaimActionCooldown() {
        this.actionCooldown = 10;
    }

    public boolean claimCooldown() {
        return this.actionCooldown > 0;
    }

    public Claim currentEdit() {
        return this.editingClaim;
    }

    public void setEditClaim(Claim claim, int height) {
        if (claim != null) {
            this.displayEditing = new ClaimDisplay(claim, EnumDisplayType.EDIT, height);
        } else if (this.displayEditing != null) {
            this.displayEditing.onRemoved(this.player);
            this.displayEditing = null;
        }
        this.editingClaim = claim;
    }

    public void addDisplayClaim(IPermissionContainer cont, EnumDisplayType type, int height) {
        if (cont instanceof Claim) {
            Claim claim = (Claim)cont;
            this.displayToAdd.add(new ClaimDisplay(claim, type, height));
            if (type == EnumDisplayType.MAIN) {
                for (Claim sub : claim.getAllSubclaims()) {
                    this.displayToAdd.add(new ClaimDisplay(sub, EnumDisplayType.SUB, height));
                }
            }
        }
    }

    public void addDisplayClaim(DisplayBox display, EnumDisplayType type, int height) {
        if (!display.isRemoved()) {
            this.displayToAdd.add(new ClaimDisplay(display, (Level)this.player.m_284548_(), type, height));
        }
    }

    public EnumEditMode getEditMode() {
        return this.mode;
    }

    public void setEditMode(EnumEditMode mode) {
        this.mode = mode;
        this.setEditClaim(null, 0);
        this.setEditingCorner(null);
    }

    public BlockPos editingCorner() {
        return this.firstCorner;
    }

    public void setEditingCorner(BlockPos pos) {
        if (pos != null) {
            BlockState state = this.player.m_9236_().m_8055_(pos);
            while (state.m_60795_() || state.m_247087_()) {
                pos = pos.m_7495_();
                state = this.player.m_9236_().m_8055_(pos);
            }
            this.cornerRenderPos = ClaimDisplay.getPosFrom(this.player.m_284548_(), pos.m_123341_(), pos.m_123343_(), pos.m_123342_(), new HashMap<ChunkPos, LevelChunk>());
        } else {
            this.cornerRenderPos = null;
        }
        this.firstCorner = pos;
    }

    public boolean confirmedDeleteAll() {
        return this.confirmDeleteAll;
    }

    public void setConfirmDeleteAll(boolean flag) {
        this.confirmDeleteAll = flag;
        this.confirmTick = 400;
    }

    public void setAdminIgnoreClaim(boolean flag) {
        this.adminIgnoreClaim = flag;
    }

    public boolean isAdminIgnoreClaim() {
        return this.adminIgnoreClaim;
    }

    public Map<String, Map<ResourceLocation, Boolean>> playerDefaultGroups() {
        return this.defaultGroups;
    }

    public boolean editDefaultPerms(String group, ResourceLocation perm, int mode) {
        boolean has;
        HashMap<ResourceLocation, Boolean> perms;
        if (PermissionManager.INSTANCE.isGlobalPermission(perm) || ConfigHandler.CONFIG.globallyDefined(this.player.m_284548_(), perm)) {
            return false;
        }
        if (mode > 1) {
            mode = -1;
        }
        Map<ResourceLocation, Boolean> map = perms = (has = this.defaultGroups.containsKey(group)) ? this.defaultGroups.get(group) : new HashMap<ResourceLocation, Boolean>();
        if (mode == -1) {
            perms.remove(perm);
        } else {
            perms.put(perm, mode == 1);
        }
        if (!has) {
            this.defaultGroups.put(group, perms);
        }
        return true;
    }

    public boolean setTrappedRescue() {
        Claim claim = ((IPlayerClaimImpl)this.player).getCurrentClaim();
        if (this.trappedTick < 0 && claim != null && !this.player.m_20148_().equals(claim.getOwner())) {
            this.trappedTick = 101;
            this.trappedPos = this.player.m_20182_();
            return true;
        }
        return false;
    }

    public boolean setTeleportTo(BlockPos tp) {
        if (this.trappedTick < 0) {
            this.trappedTick = 101;
            this.trappedPos = this.player.m_20182_();
            this.tpPos = tp;
            return true;
        }
        return false;
    }

    public void tick(Claim currentClaim, Consumer<Claim> cons) {
        EntityInteractEvents.updateClaim(this.player, currentClaim, cons);
        boolean tool = ConfigHandler.isClaimingTool(this.player.m_21205_()) || ConfigHandler.isClaimingTool(this.player.m_21206_());
        boolean stick = ConfigHandler.isInspectionTool(this.player.m_21205_()) || ConfigHandler.isInspectionTool(this.player.m_21206_());
        this.displayToAdd.forEach(add -> {
            if (!this.claimDisplayList.add((ClaimDisplay)add)) {
                this.claimDisplayList.removeIf(c -> c.equals(add) && c.type != add.type);
                this.claimDisplayList.add((ClaimDisplay)add);
            }
        });
        this.displayToAdd.clear();
        this.claimDisplayList.removeIf(d -> {
            boolean remove = d.display(this.player, !tool && !stick);
            if (remove) {
                d.onRemoved(this.player);
            }
            return remove;
        });
        if (++this.lastBlockTick > ConfigHandler.CONFIG.ticksForNextBlock) {
            this.addClaimBlocks(1);
            this.lastBlockTick = 0;
        }
        if (this.cornerRenderPos != null) {
            if (this.cornerRenderPos[1] != this.cornerRenderPos[2]) {
                this.player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleIndicators.SETCORNER, true, (double)this.cornerRenderPos[0] + 0.5, (double)this.cornerRenderPos[2] + 0.25, (double)this.cornerRenderPos[3] + 0.5, 0.0f, 0.25f, 0.0f, 0.0f, 2));
            }
            this.player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleIndicators.SETCORNER, true, (double)this.cornerRenderPos[0] + 0.5, (double)this.cornerRenderPos[1] + 0.25, (double)this.cornerRenderPos[3] + 0.5, 0.0f, 0.25f, 0.0f, 0.0f, 2));
        }
        if (--this.confirmTick < 0) {
            this.confirmDeleteAll = false;
        }
        if (this.displayEditing != null) {
            this.displayEditing.display(this.player, !tool && !stick);
        }
        if (!tool) {
            this.setEditingCorner(null);
            this.setEditClaim(null, 0);
            this.claimBlockMessage = false;
        } else if (!this.claimBlockMessage) {
            this.claimBlockMessage = true;
            if (this.shouldDisplayClaimToolMessage()) {
                this.player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("claimBlocksFormat"), this.getClaimBlocks(), this.getAdditionalClaims(), this.usedClaimBlocks(), this.remainingClaimBlocks()), ChatFormatting.GOLD), false);
                this.addDisplayClaim(currentClaim, EnumDisplayType.MAIN, this.player.m_20183_().m_123342_());
            }
        }
        --this.actionCooldown;
        if (--this.trappedTick >= 0) {
            if (this.trappedTick == 0) {
                if (this.tpPos != null) {
                    BlockPos.MutableBlockPos tpTo = this.tpPos.m_122032_();
                    Vec3 offset = new Vec3((double)this.tpPos.m_123341_() + 0.5, (double)this.tpPos.m_123342_() + 0.01, (double)this.tpPos.m_123343_() + 0.5).m_82546_(this.player.m_20182_());
                    int yHighest = this.player.m_9236_().m_6325_(this.tpPos.m_123341_() >> 4, this.tpPos.m_123343_() >> 4).m_5885_(Heightmap.Types.MOTION_BLOCKING, this.tpPos.m_123341_() & 0xF, this.tpPos.m_123343_() & 0xF);
                    AABB box = this.player.m_20191_().m_82383_(offset);
                    if (tpTo.m_123342_() < yHighest) {
                        while (tpTo.m_123342_() < yHighest && !this.player.m_9236_().m_45756_((Entity)this.player, box)) {
                            tpTo.m_122178_(tpTo.m_123341_(), tpTo.m_123342_() + 1, tpTo.m_123343_());
                            box = box.m_82386_(0.0, 1.0, 0.0);
                        }
                        tpTo.m_122178_(tpTo.m_123341_(), tpTo.m_123342_() + 1, tpTo.m_123343_());
                    } else {
                        tpTo.m_122178_(tpTo.m_123341_(), yHighest, tpTo.m_123343_());
                    }
                    if (this.player.m_20159_()) {
                        this.player.m_8127_();
                    }
                    this.player.m_20324_((double)tpTo.m_123341_() + 0.5, (double)tpTo.m_123342_(), (double)tpTo.m_123343_() + 0.5);
                    this.tpPos = null;
                } else {
                    Vec3 tp = TeleportUtils.getTeleportPos(this.player, this.player.m_20182_(), ClaimStorage.get(this.player.m_284548_()), ((IPlayerClaimImpl)this.player).getCurrentClaim().getDimensions(), TeleportUtils.roundedBlockPos(this.player.m_20182_()).m_122032_(), (claim, nPos) -> false);
                    if (this.player.m_20159_()) {
                        this.player.m_8127_();
                    }
                    this.player.m_20324_(tp.m_7096_(), tp.m_7098_(), tp.m_7094_());
                }
            } else if (this.player.m_20182_().m_82557_(this.trappedPos) > 0.15) {
                this.trappedTick = -1;
                this.trappedPos = null;
                this.player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.LANG_MANAGER.get("trappedMove"), ChatFormatting.RED), false);
            }
        }
        --this.deathPickupTick;
        if (!this.player.m_21224_()) {
            this.calculateShouldDrop = true;
        }
    }

    private boolean shouldDisplayClaimToolMessage() {
        return ItemInteractEvents.canClaimWorld(this.player.m_284548_(), this.player) && ConfigHandler.CONFIG.maxClaimBlocks > 0;
    }

    public void unlockDeathItems() {
        this.deathPickupTick = 1200;
    }

    public boolean deathItemsUnlocked() {
        return this.deathPickupTick > 0;
    }

    public void clone(PlayerClaimData data) {
        String msg;
        this.claimBlocks = data.claimBlocks;
        this.additionalClaimBlocks = data.additionalClaimBlocks;
        this.defaultGroups.clear();
        this.defaultGroups.putAll(data.defaultGroups);
        if (data.setDeathItemOwner() && !(msg = ConfigHandler.LANG_MANAGER.get("unlockDropsCmd")).isEmpty()) {
            this.player.m_5661_((Component)PermHelper.simpleColoredText(String.format(msg, "/flan unlockDrops"), ChatFormatting.GOLD), false);
        }
    }

    public void updateScoreboard() {
        int claims = this.updateClaimScores();
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.USED, this.usedBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.FREE, this.claimBlocks + this.additionalClaimBlocks - this.usedBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.CLAIMS, claims);
    }

    private int updateClaimScores() {
        int usedClaimsBlocks = 0;
        int claimsAmount = 0;
        for (ServerLevel world : this.player.m_20194_().m_129785_()) {
            Collection<Claim> claims = ClaimStorage.get(world).allClaimsFromPlayer(this.player.m_20148_());
            if (claims == null) continue;
            usedClaimsBlocks += claims.stream().filter(claim -> !claim.isAdminClaim()).mapToInt(Claim::getPlane).sum();
            claimsAmount += claims.size();
        }
        this.usedBlocks = usedClaimsBlocks;
        return claimsAmount;
    }

    private int calculateUsedClaimBlocks() {
        int usedClaimsBlocks = 0;
        for (ServerLevel world : this.player.m_20194_().m_129785_()) {
            Collection<Claim> claims = ClaimStorage.get(world).allClaimsFromPlayer(this.player.m_20148_());
            if (claims == null) continue;
            usedClaimsBlocks += claims.stream().filter(claim -> !claim.isAdminClaim()).mapToInt(Claim::getPlane).sum();
        }
        return usedClaimsBlocks;
    }

    public boolean setDeathItemOwner() {
        if (!this.player.m_21224_()) {
            return false;
        }
        if (this.calculateShouldDrop) {
            BlockPos rounded = TeleportUtils.roundedBlockPos(this.player.m_20182_().m_82520_(0.0, (double)this.player.m_6431_(this.player.m_20089_(), this.player.m_6972_(this.player.m_20089_())), 0.0));
            this.shouldProtectDrop = ClaimStorage.get(this.player.m_284548_()).getForPermissionCheck(rounded).canInteract(this.player, BuiltinPermission.LOCKITEMS, rounded) && !this.player.m_20194_().m_129900_().m_46207_(GameRules.f_46133_);
            this.calculateShouldDrop = false;
        }
        return this.shouldProtectDrop;
    }

    public void setFakePlayerNotif(boolean on) {
        this.fakePlayerNotification = on;
    }

    public boolean hasFakePlayerNotificationOn() {
        return this.fakePlayerNotification;
    }

    public void notifyFakePlayerInteraction(ServerPlayer fakePlayer, BlockPos pos, Claim claim) {
        if (!this.fakePlayerNotification) {
            return;
        }
        Map map = this.fakePlayerNotif.computeIfAbsent(claim.getClaimID(), o -> new HashMap());
        Long last = (Long)map.get(fakePlayer.m_20148_());
        if (last == null || this.player.m_284548_().m_46467_() - 1200L > last) {
            MutableComponent claimMsg = Component.m_237113_((String)String.format(ConfigHandler.LANG_MANAGER.get("fakePlayerNotification1"), claim.getWorld().m_46472_().m_135782_().toString(), pos)).m_130940_(ChatFormatting.DARK_RED);
            this.player.m_213846_((Component)claimMsg);
            String cmdStr = String.format("/flan fakePlayer add %s", fakePlayer.m_20148_().toString());
            MutableComponent cmd = Component.m_237113_((String)ConfigHandler.LANG_MANAGER.get("clickableComponent")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdStr)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)cmdStr))));
            MutableComponent msg = Component.m_237110_((String)ConfigHandler.LANG_MANAGER.get("fakePlayerNotification2"), (Object[])new Object[]{cmd});
            this.player.m_213846_((Component)msg);
            cmdStr = "/flan fakePlayer";
            cmd = Component.m_237113_((String)ConfigHandler.LANG_MANAGER.get("clickableComponent")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdStr)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)cmdStr))));
            msg = Component.m_237110_((String)ConfigHandler.LANG_MANAGER.get("fakePlayerNotification3"), (Object[])new Object[]{cmd});
            this.player.m_213846_((Component)msg);
            map.put(fakePlayer.m_20148_(), this.player.m_284548_().m_46467_());
        }
    }

    public void save(MinecraftServer server) {
        Flan.log("Saving player data for player {} with uuid {}", this.player.m_7755_(), this.player.m_20148_());
        Path dir = ConfigHandler.getPlayerSavePath(server);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(String.valueOf(this.player.m_20148_()) + ".json");
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("ClaimBlocks", (Number)this.claimBlocks);
            obj.addProperty("AdditionalBlocks", (Number)this.additionalClaimBlocks);
            obj.addProperty("LastSeen", LocalDateTime.now().format(Flan.ONLINE_TIME_FORMATTER));
            JsonObject defPerm = new JsonObject();
            this.defaultGroups.forEach((key, value) -> {
                JsonObject perm = new JsonObject();
                value.forEach((key1, value1) -> perm.addProperty(key1.toString(), value1));
                defPerm.add(key, (JsonElement)perm);
            });
            obj.add("DefaultGroups", (JsonElement)defPerm);
            obj.addProperty("FakePlayerNotification", Boolean.valueOf(this.fakePlayerNotification));
            JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
            ConfigHandler.GSON.toJson((JsonElement)obj, jsonWriter);
            jsonWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(MinecraftServer server) {
        Flan.log("Reading player data for player {} with uuid {}", this.player.m_7755_(), this.player.m_20148_());
        try {
            Path file = ConfigHandler.getPlayerSavePath(server).resolve(String.valueOf(this.player.m_20148_()) + ".json");
            if (!Files.exists(file, new LinkOption[0])) {
                Flan.log("No player data found for player {} with uuid {}", this.player.m_7755_(), this.player.m_20148_());
                return;
            }
            JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8));
            JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson(reader, JsonObject.class);
            reader.close();
            Flan.debug("Read following json data {} from file {}", obj, file.getFileName());
            JsonElement claimBlockEl = obj.get("ClaimBlocks");
            if (claimBlockEl.isJsonPrimitive()) {
                this.claimBlocks = claimBlockEl.getAsInt();
            }
            this.additionalClaimBlocks = obj.get("AdditionalBlocks").getAsInt();
            JsonObject defP = ConfigHandler.fromJson(obj, "DefaultGroups");
            defP.entrySet().forEach(e -> {
                if (((JsonElement)e.getValue()).isJsonObject()) {
                    ((JsonElement)e.getValue()).getAsJsonObject().entrySet().forEach(p -> this.editDefaultPerms((String)e.getKey(), BuiltinPermission.tryLegacy((String)p.getKey()), ((JsonElement)p.getValue()).getAsBoolean() ? 1 : 0));
                }
            });
            this.fakePlayerNotification = ConfigHandler.fromJson(obj, "FakePlayerNotification", true);
            PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.AMOUNT, this.claimBlocks + this.additionalClaimBlocks);
            this.updateClaimScores();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void updateScoreFor(ServerPlayer player, ObjectiveCriteria criterion, int val) {
        player.m_36329_().m_83427_(criterion, player.m_6302_(), scoreboardPlayerScore -> scoreboardPlayerScore.m_83402_(val));
    }

    public static void editForOfflinePlayer(MinecraftServer server, UUID uuid, int additionalClaimBlocks, boolean base) {
        Flan.log("Adding {} addional claimblocks for offline player with uuid {}", additionalClaimBlocks, uuid);
        Path dir = ConfigHandler.getPlayerSavePath(server);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(uuid.toString() + ".json");
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8));
            JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson(reader, JsonObject.class);
            reader.close();
            if (obj == null) {
                obj = new JsonObject();
            }
            if (base) {
                int blocks = ConfigHandler.fromJson(obj, "ClaimBlocks", 0);
                obj.addProperty("ClaimBlocks", (Number)(blocks + additionalClaimBlocks));
            } else {
                int additionalBlocks = ConfigHandler.fromJson(obj, "AdditionalBlocks", 0);
                obj.addProperty("AdditionalBlocks", (Number)(additionalBlocks + additionalClaimBlocks));
            }
            Flan.debug("Attempting to write following json data {} to file {}", obj, file.getFileName());
            JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
            ConfigHandler.GSON.toJson((JsonElement)obj, jsonWriter);
            jsonWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean readGriefPreventionPlayerData(MinecraftServer server, CommandSourceStack src) {
        Flan.log("Reading grief prevention data", new Object[0]);
        File griefPrevention = server.m_129843_(LevelResource.f_78182_).resolve("plugins/GriefPreventionData/PlayerData").toFile();
        if (!griefPrevention.exists()) {
            src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("cantFindData"), griefPrevention.getAbsolutePath()), ChatFormatting.DARK_RED), false);
            return false;
        }
        for (File f : griefPrevention.listFiles()) {
            try {
                if (f.getName().contains(".") || f.getName().startsWith("$")) continue;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                ServerPlayer player = server.m_6846_().m_11259_(UUID.fromString(f.getName()));
                if (player != null) {
                    PlayerClaimData data = PlayerClaimData.get(player);
                    reader.readLine();
                    data.claimBlocks = Integer.parseInt(reader.readLine());
                    data.additionalClaimBlocks = Integer.parseInt(reader.readLine());
                } else {
                    File file;
                    File dir = new File(server.m_129843_(LevelResource.f_78176_).toFile(), "/claimData/");
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    if (!(file = new File(dir, f.getName() + ".json")).exists()) {
                        file.createNewFile();
                    }
                    reader.readLine();
                    FileWriter writer = new FileWriter(file);
                    JsonObject obj = new JsonObject();
                    obj.addProperty("ClaimBlocks", reader.readLine());
                    obj.addProperty("AdditionalBlocks", reader.readLine());
                    ConfigHandler.GSON.toJson((JsonElement)obj, (Appendable)writer);
                    writer.close();
                }
                reader.close();
            }
            catch (Exception e) {
                src.m_288197_(() -> PermHelper.simpleColoredText(String.format(ConfigHandler.LANG_MANAGER.get("errorFile"), f.getName(), ChatFormatting.RED), new ChatFormatting[0]), false);
            }
        }
        return true;
    }
}

