/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

class PlanarQuadRenderer {
    PlanarQuadRenderer() {
    }

    static Vec3 getOffsetFor(Direction facing, double x, double y, double z, int layer) {
        return PlanarQuadRenderer.getOffsetFor(facing, (float)x, (float)y, (float)z, layer);
    }

    private static Vec3 getOffsetFor(Direction facing, float x, float y, float z, int layer) {
        return PlanarQuadRenderer.getOffsetFor(facing, new Vec3((double)x, (double)y, (double)z), layer);
    }

    public static Vec3 getOffsetFor(Direction facing, Vec3 vector, int layer) {
        if (layer == 0) {
            return vector;
        }
        switch (facing) {
            case UP: {
                vector.m_82520_(0.0, (double)PlanarQuadRenderer.offsetLayer(layer), 0.0);
                break;
            }
            case DOWN: {
                vector.m_82520_(0.0, (double)PlanarQuadRenderer.offsetLayer(-layer), 0.0);
                break;
            }
            case NORTH: {
                vector.m_82520_(0.0, 0.0, (double)PlanarQuadRenderer.offsetLayer(-layer));
                break;
            }
            case SOUTH: {
                vector.m_82520_(0.0, 0.0, (double)PlanarQuadRenderer.offsetLayer(layer));
                break;
            }
            case EAST: {
                vector.m_82520_((double)PlanarQuadRenderer.offsetLayer(layer), 0.0, 0.0);
                break;
            }
            case WEST: {
                vector.m_82520_((double)PlanarQuadRenderer.offsetLayer(-layer), 0.0, 0.0);
            }
        }
        return vector;
    }

    private static float offsetLayer(int layer) {
        return 0.001f * (float)layer;
    }

    static Vec3[] getQuadsFor(Direction facing) {
        if (facing != null) {
            switch (facing) {
                case DOWN: {
                    return new Vec3[]{new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 0.0, 1.0)};
                }
                case NORTH: {
                    return new Vec3[]{new Vec3(1.0, 1.0, 0.0), new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0)};
                }
                case SOUTH: {
                    return new Vec3[]{new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 1.0, 1.0)};
                }
                case EAST: {
                    return new Vec3[]{new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 1.0, 0.0)};
                }
                case WEST: {
                    return new Vec3[]{new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 1.0)};
                }
            }
            return new Vec3[]{new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0)};
        }
        return new Vec3[]{new Vec3(1.0, 1.0, 1.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0)};
    }
}

