/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataUtils {
    public static boolean isValidUUID(String uuid) {
        try {
            UUID.fromString(uuid);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void saveItemsToNBT(CompoundTag nbt, NonNullList<ItemStack> items) {
        ListTag nbtItems = new ListTag();
        for (ItemStack stack : items) {
            nbtItems.add((Object)stack.m_41739_(new CompoundTag()));
        }
        nbt.m_128365_("Inventory", (Tag)nbtItems);
    }

    public static NonNullList<ItemStack> readItemsFromNBT(CompoundTag nbt) {
        NonNullList items = NonNullList.m_122779_();
        for (Tag tag : nbt.m_128437_("Inventory", 10)) {
            if (!(tag instanceof CompoundTag)) continue;
            items.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)tag)));
        }
        return items;
    }

    public static void copyFileFromMod(String path, String modid) {
        Logger logger = LogManager.getLogger((String)modid);
        try {
            ModFile mod = FMLLoader.getLoadingModList().getModFileById(modid).getFile();
            File directory = FMLPaths.CONFIGDIR.get().resolve(modid).toFile();
            File output = new File(directory, path);
            File dir = output.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            FileUtils.copyInputStreamToFile((InputStream)Files.newInputStream(mod.findResource(new String[]{"config_defaults/" + path}), StandardOpenOption.READ), (File)new File(directory, path));
            logger.info("Copied file " + path);
        }
        catch (Exception e) {
            logger.error("Failed to copy file " + path, (Throwable)e);
        }
    }
}

