/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DirectionUtils {
    public static HitResult getEntityRayTrace(Level level, Entity entity, float reach) {
        Vec3 eyepos = entity.m_146892_();
        Vec3 lookangle = entity.m_20154_();
        Vec3 lastVec = eyepos.m_82549_(lookangle);
        Vec3 rayend = eyepos.m_82520_(lookangle.f_82479_ * (double)reach, lookangle.f_82480_ * (double)reach, lookangle.f_82481_ * (double)reach);
        ClipContext context = new ClipContext(eyepos, rayend, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult blockRay = level.m_45547_(context);
        int x = 0;
        while ((float)x < 16.0f * reach) {
            float reachpart = (float)x / 16.0f;
            Vec3 vec = eyepos.m_82520_(lookangle.f_82479_ * (double)reachpart, lookangle.f_82480_ * (double)reachpart, lookangle.f_82481_ * (double)reachpart);
            if (blockRay == null || blockRay.m_82450_() == null) {
                return new BlockHitResult(lookangle, DirectionUtils.getFacing(lookangle), null, false);
            }
            if (blockRay.m_82450_().m_82554_(eyepos) < vec.m_82554_(eyepos)) break;
            AABB aabb = new AABB(lastVec.f_82479_, lastVec.f_82480_, lastVec.f_82481_, vec.f_82479_, vec.f_82480_, vec.f_82481_);
            List entities = level.m_45933_(entity, aabb);
            if (!entities.isEmpty()) {
                return new EntityHitResult((Entity)entities.get(0), lookangle);
            }
            lastVec = vec;
            ++x;
        }
        return blockRay;
    }

    public static Direction getFacing(Vec3 vec) {
        return Direction.m_122366_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_);
    }

    public static Direction getRandomDirectionXZ(RandomSource rand) {
        return DirectionUtils.getXZDirection(rand.m_188503_(4));
    }

    public static Direction getXZDirection(int direction) {
        switch (direction) {
            case 1: {
                return Direction.SOUTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static int getXZMeta(Direction facing) {
        if (facing == Direction.UP || facing == Direction.DOWN) {
            return facing.ordinal() + 4;
        }
        return facing.ordinal() - 2;
    }

    public static Vec3 getDirectionVecXZ(Vec3i startpos, Vec3i endpos) {
        return DirectionUtils.getDirectionVecXZ(new Vec3((double)startpos.m_123341_(), (double)startpos.m_123342_(), (double)startpos.m_123343_()), new Vec3((double)endpos.m_123341_(), (double)endpos.m_123342_(), (double)endpos.m_123343_()));
    }

    public static Vec3 getDirectionVecXZ(Vec3 startpos, Vec3 endpos) {
        double dx = endpos.f_82479_ - startpos.f_82479_;
        double dz = endpos.f_82481_ - startpos.f_82481_;
        double angle = Math.atan2(dz, dx);
        return DirectionUtils.getDirectionVecXZ(angle);
    }

    public static Vec3 getDirectionVecXZ(Entity entity1, Entity entity2) {
        Vec3 startpos = entity1.m_20182_();
        Vec3 endpos = entity2.m_20182_();
        return DirectionUtils.getDirectionVecXZ(startpos, endpos);
    }

    public static Vec3 getDirectionVecXZDegrees(double angle) {
        double rad = Math.toRadians(angle);
        return DirectionUtils.getDirectionVecXZ(rad);
    }

    public static Vec3 getDirectionVecXZ(double angle) {
        double x = Math.cos(angle);
        double z = Math.sin(angle);
        return new Vec3(x, 0.0, z);
    }

    public static Vec3 getRandomDirectionVecXZ(RandomSource rand) {
        int angle = rand.m_188503_(360);
        return DirectionUtils.getDirectionVecXZDegrees(angle);
    }

    public static Vec3 getDirectionVec(Entity entity1, Entity entity2) {
        Vec3 startpos = entity1.m_20182_();
        Vec3 endpos = entity2.m_20182_();
        return DirectionUtils.getDirectionVec(startpos, endpos);
    }

    public static Vec3 getDirectionVec(Vec3i startpos, Vec3i endpos) {
        return DirectionUtils.getDirectionVec(new Vec3((double)startpos.m_123341_(), (double)startpos.m_123342_(), (double)startpos.m_123343_()), new Vec3((double)endpos.m_123341_(), (double)endpos.m_123342_(), (double)endpos.m_123343_()));
    }

    public static Vec3 getDirectionVec(Vec3 startpos, Vec3 endpos) {
        if (startpos.equals((Object)endpos)) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        double dx = endpos.f_82479_ - startpos.f_82479_;
        double dy = endpos.f_82480_ - startpos.f_82480_;
        double dz = endpos.f_82481_ - startpos.f_82481_;
        double magnitude = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0));
        double mx = (endpos.f_82479_ - startpos.f_82479_) / magnitude;
        double my = (endpos.f_82480_ - startpos.f_82480_) / magnitude;
        double mz = (endpos.f_82481_ - startpos.f_82481_) / magnitude;
        return new Vec3(mx, my, mz);
    }

    public static BlockPos getClosestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius) {
        return DirectionUtils.getClosestLoadedPos(level, basepos, direction, radius, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static BlockPos getClosestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius, Heightmap.Types type) {
        BlockPos pos = level.m_5452_(type, basepos.m_7918_((int)(direction.f_82479_ * radius), 0, (int)(direction.f_82481_ * radius)));
        while (!level.m_7232_(pos.m_123341_() / 16, pos.m_123343_() / 16)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = level.m_5452_(type, basepos.m_7918_((int)(direction.f_82479_ * (radius -= 1.0)), 0, (int)(direction.f_82481_ * radius)));
        }
        return pos;
    }

    public static BlockPos getClosestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius, int maxlight, int minlight) {
        return DirectionUtils.getClosestLoadedPos(level, basepos, direction, radius, maxlight, minlight, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static BlockPos getClosestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius, int maxlight, int minlight, Heightmap.Types type) {
        BlockPos pos = level.m_5452_(type, basepos.m_7918_((int)(direction.f_82479_ * radius), 0, (int)(direction.f_82481_ * radius)));
        while (!level.m_7232_(pos.m_123341_() / 16, pos.m_123343_() / 16) || !DirectionUtils.isBrightnessAllowed(level, pos, maxlight, minlight)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = level.m_5452_(type, basepos.m_7918_((int)(direction.f_82479_ * (radius -= 1.0)), 0, (int)(direction.f_82481_ * radius)));
        }
        return pos;
    }

    public static Vec3 getClosestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius) {
        return DirectionUtils.getClosestLoadedPos(level, basepos, direction, radius, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static Vec3 getClosestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius, Heightmap.Types type) {
        Vec3 pos = basepos.m_82520_(direction.f_82479_ * radius, 0.0, direction.f_82481_ * radius);
        pos = pos.m_82520_(0.0, (double)level.m_6924_(type, (int)pos.f_82479_, (int)pos.f_82481_) - pos.f_82480_, 0.0);
        while (!level.m_7232_((int)pos.f_82479_ / 16, (int)pos.f_82481_ / 16)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = basepos.m_82520_(direction.f_82479_ * (radius -= 1.0), 0.0, direction.f_82481_ * radius);
            pos = pos.m_82520_(0.0, (double)level.m_6924_(type, (int)pos.f_82479_, (int)pos.f_82481_) - pos.f_82480_, 0.0);
        }
        return pos;
    }

    public static Vec3 getClosestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius, int maxlight, int minlight) {
        return DirectionUtils.getClosestLoadedPos(level, basepos, direction, radius, maxlight, minlight, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static Vec3 getClosestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius, int maxlight, int minlight, Heightmap.Types type) {
        Vec3 pos = basepos.m_82520_(direction.f_82479_ * radius, 0.0, direction.f_82481_ * radius);
        pos = pos.m_82520_(0.0, (double)level.m_6924_(type, (int)pos.f_82479_, (int)pos.f_82481_) - pos.f_82480_, 0.0);
        while (!level.m_7232_((int)pos.f_82479_ / 16, (int)pos.f_82481_ / 16) || !DirectionUtils.isBrightnessAllowed(level, BlockPos.m_274446_((Position)pos), maxlight, minlight)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = basepos.m_82520_(direction.f_82479_ * (radius -= 1.0), 0.0, direction.f_82481_ * radius);
            pos = pos.m_82520_(0.0, (double)level.m_6924_(type, (int)pos.f_82479_, (int)pos.f_82481_) - pos.f_82480_, 0.0);
        }
        return pos;
    }

    public static boolean isBrightnessAllowed(Level level, BlockPos pos, int maxlight, int minlight) {
        int blocklight = level.m_45517_(LightLayer.BLOCK, pos);
        if (blocklight > maxlight) {
            return false;
        }
        return blocklight >= minlight;
    }
}

