/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.net.lenni0451.reflect.accessor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import unilib.external.net.lenni0451.reflect.Constructors;
import unilib.external.net.lenni0451.reflect.Methods;
import unilib.external.net.lenni0451.reflect.accessor.AccessorUtils;
import unilib.external.net.lenni0451.reflect.bytecode.BytecodeUtils;
import unilib.external.net.lenni0451.reflect.bytecode.builder.BytecodeBuilder;
import unilib.external.net.lenni0451.reflect.bytecode.builder.MethodBuilder;
import unilib.external.net.lenni0451.reflect.bytecode.wrapper.BuiltClass;

public class MethodAccessor {
    private static final BytecodeBuilder BUILDER = BytecodeBuilder.get();

    public static <I> I makeInvoker(@Nonnull Class<I> invokerClass, Object instance, @Nonnull Method method) {
        String newClassName = BytecodeUtils.slash(method.getDeclaringClass()) + "$MethodInvoker";
        boolean staticMethod = Modifier.isStatic(method.getModifiers());
        Method invokerMethod = MethodAccessor.findInvokerMethod(invokerClass, method, false);
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, () -> instance.getClass(), staticMethod);
            String methodClass = BytecodeUtils.slash(method.getDeclaringClass());
            String methodDesc = BytecodeUtils.desc(method);
            boolean interfaceMethod = Modifier.isInterface(method.getDeclaringClass().getModifiers());
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                if (staticMethod) {
                    MethodAccessor.pushArgs(mb, invokerMethod.getParameterTypes(), method.getParameterTypes());
                    mb.method(BUILDER.opcode("INVOKESTATIC"), methodClass, method.getName(), methodDesc, interfaceMethod);
                } else {
                    mb.var(BUILDER.opcode("ALOAD"), 0);
                    mb.field(BUILDER.opcode("GETFIELD"), newClassName, "instance", BytecodeUtils.desc(instance.getClass()));
                    MethodAccessor.pushArgs(mb, invokerMethod.getParameterTypes(), method.getParameterTypes());
                    if (interfaceMethod) {
                        mb.method(BUILDER.opcode("INVOKEINTERFACE"), methodClass, method.getName(), methodDesc, true);
                    } else {
                        mb.method(BUILDER.opcode("INVOKEVIRTUAL"), methodClass, method.getName(), methodDesc, false);
                    }
                }
                if (!method.getReturnType().equals(invokerMethod.getReturnType())) {
                    mb.type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(invokerMethod.getReturnType()));
                }
                mb.insn(BUILDER.opcode(BytecodeUtils.getReturnOpcode(invokerMethod.getReturnType())));
                mb.maxs(invokerMethod.getParameterCount() + 1, invokerMethod.getParameterCount() + 1);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        if (staticMethod) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (I)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (I)Constructors.invoke(constructor, instance);
    }

    public static <R> Function<Object[], R> makeArrayInvoker(Object instance, @Nonnull Method method) {
        boolean staticMethod = Modifier.isStatic(method.getModifiers());
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), BytecodeUtils.slash(method.getDeclaringClass()) + "$ArrayMethodInvoker", null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(Function.class)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, () -> instance.getClass(), staticMethod);
            String methodClass = BytecodeUtils.slash(method.getDeclaringClass());
            String methodDesc = BytecodeUtils.desc(method);
            boolean interfaceMethod = Modifier.isInterface(method.getDeclaringClass().getModifiers());
            cb.method(BUILDER.opcode("ACC_PUBLIC"), "apply", BytecodeUtils.mdesc(Object.class, Object.class), null, null, mb -> {
                if (!staticMethod) {
                    mb.var(BUILDER.opcode("ALOAD"), 0).field(BUILDER.opcode("GETFIELD"), cb.getName(), "instance", BytecodeUtils.desc(instance.getClass()));
                }
                MethodAccessor.pushArrayArgs(mb, method, 1);
                if (staticMethod) {
                    mb.method(BUILDER.opcode("INVOKESTATIC"), methodClass, method.getName(), methodDesc, interfaceMethod);
                } else if (interfaceMethod) {
                    mb.method(BUILDER.opcode("INVOKEINTERFACE"), methodClass, method.getName(), methodDesc, true);
                } else {
                    mb.method(BUILDER.opcode("INVOKEVIRTUAL"), methodClass, method.getName(), methodDesc, false);
                }
                if (method.getReturnType() == Void.TYPE) {
                    mb.insn(BUILDER.opcode("ACONST_NULL"));
                } else {
                    mb.box(BUILDER, method.getReturnType());
                }
                mb.insn(BUILDER.opcode("ARETURN")).maxs(method.getParameterCount() + 2, 2);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        if (staticMethod) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (Function)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (Function)Constructors.invoke(constructor, instance);
    }

    public static <I> I makeDynamicInvoker(@Nonnull Class<I> invokerClass, @Nonnull Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Dynamic invoker can only be used for non-static methods");
        }
        String newClassName = BytecodeUtils.slash(method.getDeclaringClass()) + "$DynamicMethodInvoker";
        Method invokerMethod = MethodAccessor.findInvokerMethod(invokerClass, method, true);
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), newClassName, null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(invokerClass)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, null, false);
            cb.method(BUILDER.opcode("ACC_PUBLIC"), invokerMethod.getName(), BytecodeUtils.desc(invokerMethod), null, null, mb -> {
                MethodAccessor.pushArgs(mb, invokerMethod.getParameterTypes(), MethodAccessor.prepend(method.getParameterTypes(), method.getDeclaringClass()));
                if (Modifier.isInterface(method.getDeclaringClass().getModifiers())) {
                    mb.method(BUILDER.opcode("INVOKEINTERFACE"), BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method), true);
                } else {
                    mb.method(BUILDER.opcode("INVOKEVIRTUAL"), BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method), false);
                }
                if (!method.getReturnType().equals(invokerMethod.getReturnType())) {
                    mb.type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(invokerMethod.getReturnType()));
                }
                mb.insn(BUILDER.opcode(BytecodeUtils.getReturnOpcode(invokerMethod.getReturnType())));
                mb.maxs(invokerMethod.getParameterCount() + 1, invokerMethod.getParameterCount() + 1);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (I)Constructors.invoke(constructor, new Object[0]);
    }

    public static <I, R> BiFunction<I, Object[], R> makeDynamicArrayInvoker(@Nonnull Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Dynamic invoker can only be used for non-static methods");
        }
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_SUPER", "ACC_FINAL", "ACC_SYNTHETIC"), BytecodeUtils.slash(method.getDeclaringClass()) + "$DynamicArrayMethodInvoker", null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(BiFunction.class)}, cb -> {
            AccessorUtils.addConstructor(BUILDER, cb, null, false);
            cb.method(BUILDER.opcode("ACC_PUBLIC"), "apply", BytecodeUtils.mdesc(Object.class, Object.class, Object.class), null, null, mb -> {
                mb.var(BUILDER.opcode("ALOAD"), 1).type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(method.getDeclaringClass()));
                MethodAccessor.pushArrayArgs(mb, method, 2);
                if (Modifier.isInterface(method.getDeclaringClass().getModifiers())) {
                    mb.method(BUILDER.opcode("INVOKEINTERFACE"), BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method), true);
                } else {
                    mb.method(BUILDER.opcode("INVOKEVIRTUAL"), BytecodeUtils.slash(method.getDeclaringClass()), method.getName(), BytecodeUtils.desc(method), false);
                }
                if (method.getReturnType() == Void.TYPE) {
                    mb.insn(BUILDER.opcode("ACONST_NULL"));
                } else {
                    mb.box(BUILDER, method.getReturnType());
                }
                mb.insn(BUILDER.opcode("ARETURN")).maxs(method.getParameterCount() + 2, 3);
            });
        });
        Class<?> clazz = builtClass.defineMetafactory(method.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (BiFunction)Constructors.invoke(constructor, new Object[0]);
    }

    private static Method findInvokerMethod(Class<?> invokerClass, Method method, boolean requireInstance) {
        if (!Modifier.isInterface(invokerClass.getModifiers())) {
            throw new IllegalArgumentException("The invoker class must be an interface");
        }
        int abstractMethods = 0;
        Method matched = null;
        for (Method invokerMethod : Methods.getDeclaredMethods(invokerClass)) {
            if (!Modifier.isAbstract(invokerMethod.getModifiers())) continue;
            if (++abstractMethods > 1) {
                throw new IllegalArgumentException("The invoker class must only have one abstract method");
            }
            if (invokerMethod.getParameterCount() != method.getParameterCount() + (requireInstance ? 1 : 0)) {
                throw new IllegalArgumentException("The invoker method must have " + (method.getParameterCount() + (requireInstance ? 1 : 0)) + " parameters");
            }
            if (!invokerMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("The invoker method return type must be of type " + method.getReturnType().getName());
            }
            Class<?>[] invokerParameterTypes = invokerMethod.getParameterTypes();
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            for (int i = 0; i < invokerParameterTypes.length; ++i) {
                Class<?> methodParameterType;
                Class<?> invokerParameterType = invokerParameterTypes[i];
                Class<?> clazz = requireInstance && i == 0 ? method.getDeclaringClass() : (methodParameterType = methodParameterTypes[i - (requireInstance ? 1 : 0)]);
                if (invokerParameterType.isAssignableFrom(methodParameterType)) continue;
                throw new IllegalArgumentException("The invoker method parameter " + i + " must be of type " + methodParameterType);
            }
            matched = invokerMethod;
        }
        if (matched == null) {
            throw new IllegalArgumentException("Could not find a valid invoker method for: " + method);
        }
        return matched;
    }

    private static void pushArgs(MethodBuilder mb, Class<?>[] supplied, Class<?>[] target) {
        int stack = 1;
        for (int i = 0; i < supplied.length; ++i) {
            Class<?> suppliedType = supplied[i];
            Class<?> targetType = target[i];
            mb.var(BUILDER.opcode(BytecodeUtils.getLoadOpcode(suppliedType)), stack);
            if (!suppliedType.equals(targetType)) {
                mb.type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(targetType));
            }
            stack += BytecodeUtils.getStackSize(suppliedType);
        }
    }

    private static void pushArrayArgs(MethodBuilder mb, Method method, int arrayIndex) {
        mb.var(BUILDER.opcode("ALOAD"), arrayIndex).type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.desc(Object[].class)).var(BUILDER.opcode("ASTORE"), arrayIndex);
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class<?> parameter = method.getParameterTypes()[i];
            mb.var(BUILDER.opcode("ALOAD"), arrayIndex).intPush(BUILDER, i).insn(BUILDER.opcode("AALOAD")).type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(BytecodeUtils.boxed(parameter))).unbox(BUILDER, parameter);
        }
    }

    private static Class<?>[] prepend(Class<?>[] classes, Class<?> other) {
        Class[] newClasses = new Class[classes.length + 1];
        newClasses[0] = other;
        System.arraycopy(classes, 0, newClasses, 1, classes.length);
        return newClasses;
    }
}

