/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.LoaderUtil;
import com.github.talrey.createdeco.blocks.ShippingContainerBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.logistics.vault.ItemVaultItem;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;

public class ShippingContainerBlockItem
extends ItemVaultItem {
    @ApiStatus.Internal
    public static boolean IS_PLACING_NBT = false;

    public ShippingContainerBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        IS_PLACING_NBT = LoaderUtil.checkPlacingNbt(ctx);
        InteractionResult initialResult = super.m_40576_(ctx);
        IS_PLACING_NBT = false;
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState other;
        BlockPos offset;
        int zOffset;
        int xOffset;
        BlockPos start;
        BlockPos pos;
        BlockPos placedOn;
        Player player = ctx.m_43723_();
        if (player == null || player.m_20161_()) {
            return;
        }
        ShippingContainerBlock myBlock = (ShippingContainerBlock)this.m_40614_();
        Direction face = ctx.m_43719_();
        ItemStack stack = ctx.m_43722_();
        Level level = ctx.m_43725_();
        BlockState placedOnState = level.m_8055_(placedOn = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        if (!myBlock.isSameType(placedOnState)) {
            return;
        }
        ShippingContainerBlock.Entity beAt = (ShippingContainerBlock.Entity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)BlockRegistry.CONTAINER_ENTITIES.get(myBlock.COLOR).get()), (BlockGetter)level, (BlockPos)placedOn);
        if (beAt == null) {
            return;
        }
        ShippingContainerBlock.Entity controller = beAt.getControllerBE();
        if (controller == null) {
            return;
        }
        int width = controller.getWidth();
        if (width == 1) {
            return;
        }
        int blocksToPlace = 0;
        Direction.Axis axis = ShippingContainerBlock.getVaultBlockAxis(placedOnState);
        if (axis == null || axis != face.m_122434_()) {
            return;
        }
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = start = face == facing.m_122424_() ? controller.m_58899_().m_121945_(facing.m_122424_()) : controller.m_58899_().m_5484_(facing, controller.getHeight());
        if (VecHelper.getCoordinate((Vec3i)start, (Direction.Axis)axis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)axis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offset = axis == Direction.Axis.X ? start.m_7918_(0, xOffset, zOffset) : start.m_7918_(xOffset, zOffset, 0);
                other = level.m_8055_(offset);
                if (ShippingContainerBlock.isVault(other)) continue;
                if (!other.m_247087_()) {
                    return;
                }
                ++blocksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < blocksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offset = axis == Direction.Axis.X ? start.m_7918_(0, xOffset, zOffset) : start.m_7918_(xOffset, zOffset, 0);
                other = level.m_8055_(offset);
                if (myBlock.isSameType(other)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offset, (Direction)face);
                IS_PLACING_NBT = LoaderUtil.checkPlacingNbt(context);
                super.m_40576_(context);
                IS_PLACING_NBT = false;
            }
        }
    }
}

