/*
 * Decompiled with CFR 0.152.
 */
package com.forgivingworld.config;

import com.cupboard.config.ICommonConfig;
import com.forgivingworld.config.DimensionData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CommonConfiguration
implements ICommonConfig {
    private static final String DIMENSIONCON = "dimensionconnections";
    public Map<ResourceLocation, List<DimensionData>> dimensionConnections = new HashMap<ResourceLocation, List<DimensionData>>();
    private List<DimensionData> dimensionDataList = new ArrayList<DimensionData>();
    public boolean disableVanillaPortals = false;
    public boolean instantTeleport = false;
    public boolean teleportLeashed = true;
    public boolean teleportedRidden = true;
    public boolean debuglogging = false;
    public boolean placeStone = false;
    public int teleportCooldown = 15;

    public CommonConfiguration() {
        DimensionData owToNether = new DimensionData(Level.f_46428_.m_135782_(), Level.f_46429_.m_135782_(), DimensionData.SPAWNTYPE.AIR);
        owToNether.belowY = -60;
        owToNether.xMult = 0.125;
        owToNether.zMult = 0.125;
        owToNether.slowFallDuration = 400;
        owToNether.teleportToYlevel = 125;
        this.dimensionDataList.add(owToNether);
        DimensionData endToOw = new DimensionData(Level.f_46430_.m_135782_(), Level.f_46428_.m_135782_(), DimensionData.SPAWNTYPE.AIR);
        endToOw.belowY = 0;
        endToOw.slowFallDuration = 400;
        endToOw.teleportToYlevel = 300;
        this.dimensionDataList.add(endToOw);
        DimensionData netherToNether = new DimensionData(Level.f_46429_.m_135782_(), Level.f_46429_.m_135782_(), DimensionData.SPAWNTYPE.CAVE);
        netherToNether.belowY = 0;
        netherToNether.teleportToYlevel = 4;
        this.dimensionDataList.add(netherToNether);
        DimensionData netherToOw = new DimensionData(Level.f_46429_.m_135782_(), Level.f_46428_.m_135782_(), DimensionData.SPAWNTYPE.CAVE);
        netherToOw.aboveY = 121;
        netherToOw.xMult = 8.0;
        netherToOw.zMult = 8.0;
        netherToOw.teleportToYlevel = -60;
        this.dimensionDataList.add(netherToOw);
        DimensionData owToOw = new DimensionData(Level.f_46428_.m_135782_(), Level.f_46428_.m_135782_(), DimensionData.SPAWNTYPE.AIR);
        owToOw.aboveY = 364;
        owToOw.teleportToYlevel = 360;
        owToNether.slowFallDuration = 400;
        this.dimensionDataList.add(owToOw);
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Disables vanilla portals, default:false");
        entry2.addProperty("disableVanillaPortals", Boolean.valueOf(this.disableVanillaPortals));
        root.add("disableVanillaPortals", (JsonElement)entry2);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "Sets a delay before you can teleport again, default:15 seconds");
        entry8.addProperty("teleportCooldown", (Number)this.teleportCooldown);
        root.add("teleportCooldown", (JsonElement)entry8);
        JsonObject entry9 = new JsonObject();
        entry9.addProperty("desc:", "Instantly teleports instead of notifying the user over time,(Note this causes some lag, due to loading chunks directly) default:false");
        entry9.addProperty("instantTeleport", Boolean.valueOf(this.instantTeleport));
        root.add("instantTeleport", (JsonElement)entry9);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Teleport ridden entities too, default:true");
        entry4.addProperty("teleportedRidden", Boolean.valueOf(this.teleportedRidden));
        root.add("teleportedRidden", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Teleport leashed entities too, default:true");
        entry5.addProperty("teleportLeashed", Boolean.valueOf(this.teleportLeashed));
        root.add("teleportLeashed", (JsonElement)entry5);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Enable debug logging, default:false");
        entry3.addProperty("debuglogging", Boolean.valueOf(this.debuglogging));
        root.add("debuglogging", (JsonElement)entry3);
        JsonArray list1 = new JsonArray();
        for (DimensionData data : this.dimensionDataList) {
            list1.add((JsonElement)data.serialize());
        }
        root.add(DIMENSIONCON, (JsonElement)list1);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.debuglogging = data.get("debuglogging").getAsJsonObject().get("debuglogging").getAsBoolean();
        this.disableVanillaPortals = data.get("disableVanillaPortals").getAsJsonObject().get("disableVanillaPortals").getAsBoolean();
        this.teleportCooldown = data.get("teleportCooldown").getAsJsonObject().get("teleportCooldown").getAsInt();
        this.teleportedRidden = data.get("teleportedRidden").getAsJsonObject().get("teleportedRidden").getAsBoolean();
        this.teleportLeashed = data.get("teleportLeashed").getAsJsonObject().get("teleportLeashed").getAsBoolean();
        this.instantTeleport = data.get("instantTeleport").getAsJsonObject().get("instantTeleport").getAsBoolean();
        JsonArray dimensionData = data.get(DIMENSIONCON).getAsJsonArray();
        this.dimensionDataList.clear();
        this.dimensionConnections.clear();
        for (JsonElement element : dimensionData) {
            DimensionData newData = new DimensionData((JsonObject)element);
            this.dimensionDataList.add(newData);
            this.dimensionConnections.computeIfAbsent(newData.from, n -> new ArrayList()).add(newData);
        }
    }
}

