/*
 * Decompiled with CFR 0.152.
 */
package com.forgivingworld.config;

import com.cupboard.util.BlockSearch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class DimensionData {
    private static final String FROM_DIM = "from";
    private static final String TO_DIM = "to";
    private static final String X_MULT = "xcoordmultiplier";
    private static final String Z_MULT = "zcoordmultiplier";
    private static final String TP_TYPE = "teleporttype";
    private static final String TP_TYPE_YLEVEL = "teleport_to_y";
    private static final String BELOWY = "belowy";
    private static final String ABOVEY = "abovey";
    private static final String SLOW_FALL = "slowfallticks";
    public final ResourceLocation from;
    public final ResourceLocation to;
    public double xMult = 1.0;
    public double zMult = 1.0;
    public int aboveY = Integer.MAX_VALUE;
    public int belowY = Integer.MIN_VALUE;
    public int slowFallDuration = 0;
    public int teleportToYlevel = 0;
    public final SPAWNTYPE yspawn;
    final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR = (world, pos) -> world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_();
    final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR_GROUND = this.DOUBLE_AIR.and((world, pos) -> world.m_8055_(pos.m_7495_()).m_280296_());
    final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR_GROUND_FIVE = (world, pos) -> {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos checkPos = pos.m_7918_(x, 0, z);
                if (world.m_8055_(checkPos).m_60795_() && world.m_8055_(checkPos.m_7494_()).m_60795_() && world.m_8055_(checkPos.m_7495_()).m_280296_()) continue;
                return false;
            }
        }
        return true;
    };

    public DimensionData(ResourceLocation from, ResourceLocation to, SPAWNTYPE yspawn) {
        this.from = from;
        this.to = to;
        this.yspawn = yspawn;
    }

    public DimensionData(JsonObject data) {
        this.from = ResourceLocation.m_135820_((String)data.get(FROM_DIM).getAsString());
        this.to = ResourceLocation.m_135820_((String)data.get(TO_DIM).getAsString());
        if (data.has(X_MULT)) {
            this.xMult = data.get(X_MULT).getAsDouble();
        }
        if (data.has(Z_MULT)) {
            this.zMult = data.get(Z_MULT).getAsDouble();
        }
        this.yspawn = SPAWNTYPE.fromString(data.get(TP_TYPE).getAsJsonObject().get(TP_TYPE).getAsString());
        this.teleportToYlevel = data.get(TP_TYPE).getAsJsonObject().get(TP_TYPE_YLEVEL).getAsInt();
        if (data.has(BELOWY)) {
            this.belowY = data.get(BELOWY).getAsInt();
        }
        if (data.has(ABOVEY)) {
            this.aboveY = data.get(ABOVEY).getAsInt();
        }
        if (data.has(SLOW_FALL)) {
            this.slowFallDuration = data.get(SLOW_FALL).getAsInt();
        }
    }

    public JsonObject serialize() {
        JsonObject data = new JsonObject();
        data.addProperty(FROM_DIM, this.from.toString());
        data.addProperty(TO_DIM, this.to.toString());
        if (this.xMult != 1.0 || this.zMult != 1.0) {
            data.addProperty(X_MULT, (Number)this.xMult);
            data.addProperty(Z_MULT, (Number)this.zMult);
        }
        JsonObject spawndata = new JsonObject();
        spawndata.addProperty(TP_TYPE, this.yspawn.toString());
        spawndata.addProperty(TP_TYPE_YLEVEL, (Number)this.teleportToYlevel);
        data.add(TP_TYPE, (JsonElement)spawndata);
        if (this.belowY != Integer.MIN_VALUE) {
            data.addProperty(BELOWY, (Number)this.belowY);
        }
        if (this.aboveY != Integer.MAX_VALUE) {
            data.addProperty(ABOVEY, (Number)this.aboveY);
        }
        if (this.slowFallDuration != 0) {
            data.addProperty(SLOW_FALL, (Number)this.slowFallDuration);
        }
        return data;
    }

    public boolean shouldTP(double y) {
        return y < (double)this.belowY || y > (double)this.aboveY;
    }

    public BlockPos translatePosition(BlockPos original) {
        return new BlockPos((int)((double)original.m_123341_() * this.xMult), original.m_123342_(), (int)((double)original.m_123343_() * this.zMult));
    }

    public BlockPos getSpawnPos(ServerLevel world, double xOriginal, double zOriginal) {
        xOriginal *= this.xMult;
        zOriginal *= this.zMult;
        switch (this.yspawn) {
            case AIR: {
                BlockPos solidAir = BlockSearch.findAround((BlockGetter)world, (BlockPos)new BlockPos((int)xOriginal, this.teleportToYlevel, (int)zOriginal), (int)10, (int)20, (int)-2, this.DOUBLE_AIR_GROUND_FIVE);
                if (solidAir != null) {
                    return solidAir;
                }
                return BlockSearch.findAround((BlockGetter)world, (BlockPos)new BlockPos((int)xOriginal, this.teleportToYlevel, (int)zOriginal), (int)20, (int)50, (int)-2, this.DOUBLE_AIR);
            }
            case GROUND: {
                LevelChunk targetChunk = world.m_6325_((int)Math.floor(xOriginal) >> 4, (int)Math.floor(zOriginal) >> 4);
                BlockPos result = BlockSearch.findAround((BlockGetter)world, (BlockPos)new BlockPos((int)xOriginal, targetChunk.m_5885_(Heightmap.Types.WORLD_SURFACE, (int)Math.floor(xOriginal), (int)Math.floor(zOriginal)), (int)zOriginal), (int)20, (int)50, (int)2, this.DOUBLE_AIR_GROUND_FIVE);
                if (result == null) {
                    result = BlockSearch.findAround((BlockGetter)world, (BlockPos)new BlockPos((int)xOriginal, targetChunk.m_5885_(Heightmap.Types.WORLD_SURFACE, (int)Math.floor(xOriginal), (int)Math.floor(zOriginal)), (int)zOriginal), (int)20, (int)50, (int)2, this.DOUBLE_AIR_GROUND);
                }
                return result;
            }
            case CAVE: {
                BlockPos cresult = BlockSearch.findAround((BlockGetter)world, (BlockPos)new BlockPos((int)xOriginal, this.teleportToYlevel, (int)zOriginal), (int)50, (int)50, (int)2, this.DOUBLE_AIR_GROUND_FIVE);
                if (cresult == null) {
                    cresult = BlockSearch.findAround((BlockGetter)world, (BlockPos)new BlockPos((int)xOriginal, this.teleportToYlevel, (int)zOriginal), (int)20, (int)50, (int)2, this.DOUBLE_AIR_GROUND);
                }
                return cresult;
            }
        }
        return null;
    }

    public static enum SPAWNTYPE {
        AIR,
        GROUND,
        CAVE;


        public static SPAWNTYPE fromString(String data) {
            if (data.toLowerCase().trim().equals("air")) {
                return AIR;
            }
            if (data.toLowerCase().trim().equals("ground")) {
                return GROUND;
            }
            if (data.toLowerCase().trim().equals("cave")) {
                return CAVE;
            }
            throw new IllegalArgumentException("Unkown TP type: " + data + " expected one of air,ground,cave");
        }
    }
}

