/*
 * Decompiled with CFR 0.152.
 */
package com.forgivingworld.event;

import com.forgivingworld.ForgivingWorldMod;
import com.forgivingworld.config.CommonConfiguration;
import com.forgivingworld.config.DimensionData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public static final TicketType<ChunkPos> TELEPORT_TICKET = TicketType.m_9465_((String)"forgivingworldTP", Comparator.comparingLong(ChunkPos::m_45588_), (int)1200);
    private static final Integer TP_TIME = 10;
    private static final Map<UUID, Integer> playerTpTime = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastTpTime = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().m_5776_() || player.m_9236_().m_46467_() % 80L != 0L || player.m_213877_() || event.phase == TickEvent.Phase.START) {
            return;
        }
        Long lastTime = lastTpTime.get(player.m_20148_());
        if (lastTime != null && System.currentTimeMillis() - lastTime < 1000L * (long)((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).teleportCooldown) {
            return;
        }
        List<DimensionData> dimensionTPs = ((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).dimensionConnections.get(player.m_9236_().m_46472_().m_135782_());
        if (dimensionTPs == null || dimensionTPs.isEmpty()) {
            return;
        }
        DimensionData tp = null;
        for (DimensionData data : dimensionTPs) {
            if (!data.shouldTP(player.m_20186_())) continue;
            tp = data;
            break;
        }
        if (tp == null) {
            playerTpTime.remove(player.m_20148_());
            return;
        }
        if (((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).instantTeleport || player.m_20186_() < (double)tp.belowY && Math.abs(player.m_20186_() - (double)tp.belowY) > 15.0 || player.m_20186_() > (double)tp.aboveY && Math.abs(player.m_20186_() - (double)tp.aboveY) > 15.0) {
            EventHandler.tryTpPlayer((ServerPlayer)player, tp);
            for (ResourceKey key : player.m_9236_().m_7654_().m_129784_()) {
                if (!key.m_135782_().equals((Object)tp.to)) continue;
                ChunkPos dimensionPos = new ChunkPos(tp.translatePosition(player.m_20183_()));
                player.m_9236_().m_7654_().m_129880_(key).m_7726_().m_8387_(TELEPORT_TICKET, dimensionPos, 3, (Object)dimensionPos);
                return;
            }
            return;
        }
        int time = playerTpTime.computeIfAbsent(player.m_20148_(), player2 -> 0);
        playerTpTime.put(player.m_20148_(), ++time);
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123745_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.05);
        if (time == 1) {
            player.m_213846_((Component)Component.m_237115_((String)(player.m_20186_() > (double)tp.aboveY ? "forgivingworld.pullup" : "forgivingworld.pulldown")).m_130940_(ChatFormatting.DARK_AQUA));
        }
        if (time == 6) {
            player.m_213846_((Component)Component.m_237115_((String)"forgivingworld.teleportsoon").m_130940_(ChatFormatting.DARK_PURPLE));
            ServerLevel gotoWorld = null;
            for (ResourceKey key : player.m_9236_().m_7654_().m_129784_()) {
                if (!key.m_135782_().equals((Object)tp.to)) continue;
                gotoWorld = player.m_9236_().m_7654_().m_129880_(key);
                break;
            }
            if (gotoWorld != null) {
                ChunkPos dimensionPos = new ChunkPos(tp.translatePosition(player.m_20183_()));
                gotoWorld.m_7726_().m_8387_(TELEPORT_TICKET, dimensionPos, 3, (Object)dimensionPos);
            }
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12286_, player.m_5720_(), 0.5f, 2.0f + (ForgivingWorldMod.rand.nextFloat() - ForgivingWorldMod.rand.nextFloat()) * 0.2f);
        if (time > TP_TIME && EventHandler.tryTpPlayer((ServerPlayer)player, tp)) {
            playerTpTime.remove(player.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onVoidDamageRecv(LivingHurtEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268724_)) {
            if (!(event.getEntity() instanceof ServerPlayer) || event.getEntity().m_9236_().f_46443_) {
                return;
            }
            ServerPlayer playerEntity = (ServerPlayer)event.getEntity();
            List<DimensionData> dimensions = ((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).dimensionConnections.get(playerEntity.m_9236_().m_46472_().m_135782_());
            if (dimensions == null || dimensions.isEmpty()) {
                return;
            }
            for (DimensionData data : dimensions) {
                if (!(playerEntity.m_20186_() < (double)data.belowY)) continue;
                for (ResourceKey key : playerEntity.m_20194_().m_129784_()) {
                    if (!key.m_135782_().equals((Object)data.to)) continue;
                    playerEntity.m_20194_().m_129880_(key).m_6325_(data.translatePosition(playerEntity.m_20183_()).m_123341_() >> 4, data.translatePosition(playerEntity.m_20183_()).m_123343_() >> 4);
                    break;
                }
                if (!EventHandler.tryTpPlayer(playerEntity, data)) continue;
                event.setAmount(0.0f);
                break;
            }
        }
    }

    private static boolean tryTpPlayer(ServerPlayer playerEntity, DimensionData gotoDim) {
        if (playerEntity.m_7500_() || playerEntity.m_5833_()) {
            return false;
        }
        ServerLevel world = (ServerLevel)playerEntity.m_9236_();
        if (gotoDim == null || !gotoDim.shouldTP(playerEntity.m_20186_())) {
            return false;
        }
        ServerLevel gotoWorld = null;
        for (ResourceKey key : world.m_7654_().m_129784_()) {
            if (!key.m_135782_().equals((Object)gotoDim.to)) continue;
            gotoWorld = world.m_7654_().m_129880_(key);
            break;
        }
        if (gotoWorld == null) {
            return false;
        }
        Long lastTime = lastTpTime.get(playerEntity.m_20148_());
        if (lastTime != null && System.currentTimeMillis() - lastTime < (long)(((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).teleportCooldown * 1000)) {
            return false;
        }
        BlockPos tpPos = gotoDim.getSpawnPos(gotoWorld, playerEntity.m_20185_(), playerEntity.m_20189_());
        if (tpPos == null) {
            if (((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).debuglogging) {
                ForgivingWorldMod.LOGGER.info("Cannot find spawn pos in target dimension for player " + playerEntity.m_5446_().getString() + "(" + playerEntity.m_19879_() + ") from " + playerEntity.m_20183_().m_123344_() + " in " + playerEntity.m_9236_().m_46472_().m_135782_() + " around: " + gotoDim.translatePosition(playerEntity.m_20183_()) + " in " + gotoWorld.m_46472_().m_135782_() + " with TP type:" + gotoDim.yspawn);
            }
            lastTpTime.put(playerEntity.m_20148_(), System.currentTimeMillis() - (long)((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).teleportCooldown * 1000L + 5000L);
            return false;
        }
        lastTpTime.put(playerEntity.m_20148_(), System.currentTimeMillis());
        if (((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).debuglogging) {
            ForgivingWorldMod.LOGGER.info("Teleporting player " + playerEntity.m_5446_().getString() + "(" + playerEntity.m_19879_() + ") from " + playerEntity.m_20183_().m_123344_() + " in " + playerEntity.m_9236_().m_46472_().m_135782_() + " to: " + tpPos.m_123344_() + " in " + gotoWorld.m_46472_().m_135782_() + " with TP type:" + gotoDim.yspawn);
        }
        ChunkPos chunkpos = new ChunkPos(tpPos);
        gotoWorld.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)playerEntity.m_19879_());
        Entity vehicle = playerEntity.m_20202_();
        if (vehicle != null && ((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).teleportedRidden) {
            playerEntity.m_8127_();
            vehicle = EventHandler.dimensionTPEntity(vehicle, gotoWorld, (double)tpPos.m_123341_() + 0.5, tpPos.m_123342_() + 1, (double)tpPos.m_123343_() + 0.5, gotoDim.slowFallDuration);
        }
        ArrayList<Mob> leashedMobs = new ArrayList<Mob>();
        if (((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).teleportLeashed) {
            for (Mob mob : world.m_45976_(Mob.class, new AABB(playerEntity.m_20185_() - 7.0, playerEntity.m_20186_() - 7.0, playerEntity.m_20189_() - 7.0, playerEntity.m_20185_() + 7.0, playerEntity.m_20186_() + 7.0, playerEntity.m_20189_() + 7.0))) {
                Entity entity;
                if (mob.m_21524_() != playerEntity || !((entity = EventHandler.dimensionTPEntity((Entity)mob, gotoWorld, (double)tpPos.m_123341_() + 0.5, tpPos.m_123342_() + 1, (double)tpPos.m_123343_() + 0.5, gotoDim.slowFallDuration)) instanceof Mob)) continue;
                leashedMobs.add((Mob)entity);
            }
        }
        if (playerEntity.m_5803_()) {
            playerEntity.m_6145_(true, true);
        }
        boolean prev = ((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).disableVanillaPortals;
        ((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).disableVanillaPortals = false;
        playerEntity.m_8999_(gotoWorld, (double)tpPos.m_123341_() + 0.5, (double)tpPos.m_123342_(), (double)tpPos.m_123343_() + 0.5, playerEntity.m_146908_(), playerEntity.m_146909_());
        ((CommonConfiguration)ForgivingWorldMod.config.getCommonConfig()).disableVanillaPortals = prev;
        if (gotoDim.slowFallDuration > 0) {
            playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, gotoDim.slowFallDuration));
        }
        playerEntity.f_19789_ = 0.0f;
        if (vehicle != null) {
            playerEntity.m_20329_(vehicle);
        }
        for (Mob mob : leashedMobs) {
            mob.m_21463_((Entity)playerEntity, true);
        }
        playerEntity.m_9236_().m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_12287_, playerEntity.m_5720_(), 1.0f, 2.0f + (ForgivingWorldMod.rand.nextFloat() - ForgivingWorldMod.rand.nextFloat()) * 0.2f);
        return true;
    }

    private static Entity dimensionTPEntity(Entity original, ServerLevel gotoWorld, double x, double y, double z, int slowFallDuration) {
        Entity entity = original.m_6095_().m_20615_((Level)gotoWorld);
        if (entity != null) {
            entity.m_20361_(original);
            original.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            if (slowFallDuration > 0 && entity instanceof Mob) {
                ((Mob)entity).m_7292_(new MobEffectInstance(MobEffects.f_19591_, slowFallDuration));
            }
            entity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
            entity.m_20256_(Vec3.f_82478_);
            gotoWorld.m_6325_((int)x >> 4, (int)z >> 4);
            gotoWorld.m_143334_(entity);
            return entity;
        }
        return null;
    }
}

