/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.button.custombutton;

import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ExecutableElement;
import de.keksuccino.fancymenu.customization.element.elements.button.custombutton.ButtonEditorElement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonElement
extends AbstractElement
implements ExecutableElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private AbstractWidget widget;
    public ResourceSupplier<IAudio> clickSound;
    public ResourceSupplier<IAudio> hoverSound;
    @Nullable
    public String label;
    @Nullable
    public String hoverLabel;
    public String tooltip;
    public ResourceSupplier<ITexture> backgroundTextureNormal;
    public ResourceSupplier<ITexture> backgroundTextureHover;
    public ResourceSupplier<ITexture> backgroundTextureInactive;
    public String backgroundAnimationNormal;
    public String backgroundAnimationHover;
    public String backgroundAnimationInactive;
    public boolean loopBackgroundAnimations = true;
    public boolean restartBackgroundAnimationsOnHover = true;
    public boolean nineSliceCustomBackground = false;
    public int nineSliceBorderX = 5;
    public int nineSliceBorderY = 5;
    public boolean navigatable = true;
    @NotNull
    public GenericExecutableBlock actionExecutor = new GenericExecutableBlock();
    @NotNull
    public LoadingRequirementContainer activeStateSupplier = new LoadingRequirementContainer();

    public ButtonElement(ElementBuilder<ButtonElement, ButtonEditorElement> builder) {
        super(builder);
    }

    @Override
    public void tick() {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
        if (!this.shouldRender()) {
            return;
        }
        if (ButtonElement.isEditor()) {
            Tooltip cachedVanillaTooltip = this.getWidget().m_278622_();
            boolean cachedVisible = this.getWidget().f_93624_;
            boolean cachedActive = this.getWidget().f_93623_;
            this.getWidget().f_93624_ = true;
            this.getWidget().f_93623_ = true;
            this.getWidget().m_257544_(null);
            MainThreadTaskExecutor.executeInMainThread(() -> {
                this.getWidget().f_93624_ = cachedVisible;
                this.getWidget().f_93623_ = cachedActive;
                this.getWidget().m_257544_(cachedVanillaTooltip);
            }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        }
        this.renderElementWidget(graphics, mouseX, mouseY, partial);
        RenderingUtils.resetShaderColor(graphics);
    }

    @Override
    public void tickVisibleInvisible() {
        super.tickVisibleInvisible();
        if (this.getWidget() != null) {
            this.updateWidget();
        }
    }

    protected void renderElementWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() != null) {
            if (this.getWidget().m_93694_() <= 0) {
                return;
            }
            if (this.getWidget().m_5711_() <= 0) {
                return;
            }
            this.getWidget().m_88315_(graphics, mouseX, mouseY, partial);
        }
    }

    @Override
    @Nullable
    public List<GuiEventListener> getWidgetsToRegister() {
        if (this.getWidget() == null) {
            return null;
        }
        return List.of(this.getWidget());
    }

    public void updateWidget() {
        this.updateWidgetActiveState();
        this.updateWidgetVisibility();
        this.updateWidgetAlpha();
        this.updateWidgetTooltip();
        this.updateWidgetLabels();
        this.updateWidgetHoverSound();
        this.updateWidgetClickSound();
        this.updateWidgetTexture();
        this.updateWidgetSize();
        this.updateWidgetPosition();
        this.updateWidgetNavigatable();
    }

    public void updateWidgetActiveState() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().f_93623_ = this.activeStateSupplier.requirementsMet();
    }

    public void updateWidgetNavigatable() {
        AbstractWidget abstractWidget = this.getWidget();
        if (abstractWidget instanceof NavigatableWidget) {
            NavigatableWidget w = (NavigatableWidget)abstractWidget;
            w.setNavigatable(this.navigatable);
        }
    }

    public void updateWidgetVisibility() {
        AbstractWidget abstractWidget = this.getWidget();
        if (abstractWidget instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            w.setHiddenFancyMenu(!this.shouldRender());
        }
    }

    public void updateWidgetAlpha() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().m_93650_(this.opacity);
    }

    public void updateWidgetPosition() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().m_252865_(this.getAbsoluteX());
        this.getWidget().m_253211_(this.getAbsoluteY());
    }

    public void updateWidgetSize() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().m_93674_(this.getAbsoluteWidth());
        ((IMixinAbstractWidget)this.getWidget()).setHeightFancyMenu(this.getAbsoluteHeight());
    }

    public void updateWidgetTooltip() {
        if (this.tooltip != null && this.getWidget() != null && this.getWidget().m_274382_() && this.getWidget().f_93624_ && this.shouldRender() && !ButtonElement.isEditor()) {
            String tooltip = this.tooltip.replace("%n%", "\n");
            TooltipHandler.INSTANCE.addWidgetTooltip(this.getWidget(), de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip.of(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(tooltip), (String)"\n")), false, true);
        }
    }

    public void updateWidgetLabels() {
        if (this.getWidget() == null) {
            return;
        }
        if (this.label != null) {
            this.getWidget().m_93666_(ButtonElement.buildComponent(this.label));
        } else {
            this.getWidget().m_93666_((Component)Component.m_237119_());
        }
        if (this.hoverLabel != null && this.getWidget().m_198029_() && this.getWidget().f_93623_) {
            this.getWidget().m_93666_(ButtonElement.buildComponent(this.hoverLabel));
        }
    }

    public void updateWidgetHoverSound() {
        AbstractWidget abstractWidget = this.getWidget();
        if (abstractWidget instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            w.setHoverSoundFancyMenu(this.hoverSound != null ? this.hoverSound.get() : null);
        }
    }

    public void updateWidgetClickSound() {
        AbstractWidget abstractWidget = this.getWidget();
        if (abstractWidget instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            w.setCustomClickSoundFancyMenu(this.clickSound != null ? this.clickSound.get() : null);
        }
    }

    public void updateWidgetTexture() {
        AbstractWidget abstractWidget;
        RenderableResource backNormal = null;
        RenderableResource backHover = null;
        RenderableResource backInactive = null;
        if (this.backgroundTextureNormal != null) {
            backNormal = this.backgroundTextureNormal.get();
        }
        if (this.backgroundTextureHover != null) {
            backHover = this.backgroundTextureHover.get();
        }
        if (this.backgroundTextureInactive != null) {
            backInactive = this.backgroundTextureInactive.get();
        }
        if ((abstractWidget = this.getWidget()) instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)abstractWidget;
            AbstractWidget abstractWidget2 = this.getWidget();
            if (abstractWidget2 instanceof CustomizableSlider) {
                CustomizableSlider s = (CustomizableSlider)abstractWidget2;
                s.setNineSliceCustomSliderBackground_FancyMenu(this.nineSliceCustomBackground);
                s.setNineSliceSliderBackgroundBorderX_FancyMenu(this.nineSliceBorderX);
                s.setNineSliceSliderBackgroundBorderY_FancyMenu(this.nineSliceBorderY);
            } else {
                w.setNineSliceCustomBackground_FancyMenu(this.nineSliceCustomBackground);
                w.setNineSliceBorderX_FancyMenu(this.nineSliceBorderX);
                w.setNineSliceBorderY_FancyMenu(this.nineSliceBorderY);
            }
            w.setCustomBackgroundNormalFancyMenu(backNormal);
            w.setCustomBackgroundHoverFancyMenu(backHover);
            w.setCustomBackgroundInactiveFancyMenu(backInactive);
            w.setCustomBackgroundResetBehaviorFancyMenu(this.restartBackgroundAnimationsOnHover ? CustomizableWidget.CustomBackgroundResetBehavior.RESET_ON_HOVER : CustomizableWidget.CustomBackgroundResetBehavior.RESET_NEVER);
        }
    }

    @Nullable
    public AbstractWidget getWidget() {
        return this.widget;
    }

    public void setWidget(@Nullable AbstractWidget widget) {
        this.widget = widget;
    }

    @Override
    @NotNull
    public GenericExecutableBlock getExecutableBlock() {
        return this.actionExecutor;
    }
}

