/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.window;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsWindowHeightRequirement
extends LoadingRequirement {
    public IsWindowHeightRequirement() {
        super("fancymenu_loading_requirement_is_window_height");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        List<Integer> l;
        if (value != null && !(l = this.parseIntegers(value)).isEmpty()) {
            return l.contains(Minecraft.m_91087_().m_91268_().m_85442_());
        }
        return false;
    }

    protected List<Integer> parseIntegers(String value) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (value != null) {
            if (value.contains(",")) {
                for (String s : value.replace(" ", "").split("[,]")) {
                    if (!MathUtils.isDouble((String)s)) continue;
                    l.add((int)Double.parseDouble(s));
                }
            } else if (MathUtils.isInteger((String)value.replace(" ", ""))) {
                l.add((int)Double.parseDouble(value.replace(" ", "")));
            }
        }
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.helper.editor.items.visibilityrequirements.windowheight", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.items.visibilityrequirements.windowheight.desc", "" + Minecraft.m_91087_().m_91268_().m_85441_(), "" + Minecraft.m_91087_().m_91268_().m_85442_()));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.editor.loading_requirement.category.window", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return I18n.m_118938_((String)"fancymenu.helper.editor.items.visibilityrequirements.windowheight.valuename", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "1080";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

