/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.resources.audio.wav;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.melody.resources.audio.openal.ALAudioBuffer;
import de.keksuccino.melody.resources.audio.openal.ALAudioClip;
import de.keksuccino.melody.resources.audio.openal.ALUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WavAudio
implements IAudio {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    protected volatile ALAudioClip clip;
    @Nullable
    protected volatile ALAudioBuffer audioBuffer;
    protected ResourceLocation sourceLocation;
    protected File sourceFile;
    protected String sourceURL;
    protected volatile boolean decoded = false;
    protected volatile boolean loadingCompleted = false;
    protected volatile boolean loadingFailed = false;
    protected volatile boolean closed = false;

    @NotNull
    public static WavAudio location(@NotNull ResourceLocation location) {
        return WavAudio.location(location, null);
    }

    @NotNull
    public static WavAudio location(@NotNull ResourceLocation location, @Nullable WavAudio writeTo) {
        ALAudioClip clip;
        Objects.requireNonNull(location);
        WavAudio audio = writeTo != null ? writeTo : new WavAudio();
        audio.sourceLocation = location;
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! OpenAL not ready! Returning empty audio for: " + String.valueOf(location));
            return audio;
        }
        try {
            clip = ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Failed to create clip: " + String.valueOf(location), (Throwable)ex);
            return audio;
        }
        if (clip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Clip was NULL: " + String.valueOf(location));
            return audio;
        }
        try {
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(location);
            if (resource.isPresent()) {
                InputStream in = ((Resource)resource.get()).m_215507_();
                WavAudio.of(in, location.toString(), audio, clip);
            }
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio from ResourceLocation: " + String.valueOf(location), (Throwable)ex);
        }
        return audio;
    }

    @NotNull
    public static WavAudio local(@NotNull File wavAudioFile) {
        return WavAudio.local(wavAudioFile, null);
    }

    @NotNull
    public static WavAudio local(@NotNull File wavAudioFile, @Nullable WavAudio writeTo) {
        ALAudioClip clip;
        Objects.requireNonNull(wavAudioFile);
        WavAudio audio = writeTo != null ? writeTo : new WavAudio();
        audio.sourceFile = wavAudioFile;
        if (!wavAudioFile.isFile()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio from file! File not found: " + wavAudioFile.getPath());
            return audio;
        }
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! OpenAL not ready! Returning empty audio for: " + wavAudioFile.getPath());
            return audio;
        }
        try {
            clip = ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Failed to create clip: " + wavAudioFile.getPath(), (Throwable)ex);
            return audio;
        }
        if (clip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Clip was NULL: " + wavAudioFile.getPath());
            return audio;
        }
        try {
            FileInputStream in = new FileInputStream(wavAudioFile);
            WavAudio.of(in, wavAudioFile.getPath(), audio, clip);
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio from file: " + wavAudioFile.getPath(), (Throwable)ex);
        }
        return audio;
    }

    @NotNull
    public static WavAudio web(@NotNull String wavAudioURL) {
        return WavAudio.web(wavAudioURL, null);
    }

    @NotNull
    public static WavAudio web(@NotNull String wavAudioURL, @Nullable WavAudio writeTo) {
        ALAudioClip clip;
        Objects.requireNonNull(wavAudioURL);
        WavAudio audio = writeTo != null ? writeTo : new WavAudio();
        audio.sourceURL = wavAudioURL;
        if (!TextValidators.BASIC_URL_TEXT_VALIDATOR.get(wavAudioURL).booleanValue()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio from URL! Invalid URL: " + wavAudioURL);
            return audio;
        }
        RenderSystem.assertOnRenderThread();
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! OpenAL not ready! Returning empty audio for: " + wavAudioURL);
            return audio;
        }
        try {
            clip = ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Failed to create clip: " + wavAudioURL, (Throwable)ex);
            return audio;
        }
        if (clip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Clip was NULL: " + wavAudioURL);
            return audio;
        }
        new Thread(() -> {
            try {
                InputStream in = WebUtils.openResourceStream(wavAudioURL);
                if (in == null) {
                    throw new NullPointerException("Web resource input stream was NULL!");
                }
                WavAudio.of(in, wavAudioURL, audio, clip);
            }
            catch (Exception ex) {
                audio.loadingFailed = true;
                LOGGER.error("[FANCYMENU] Failed to read WAV audio from URL: " + wavAudioURL, (Throwable)ex);
            }
        }).start();
        return audio;
    }

    @NotNull
    public static WavAudio of(@NotNull InputStream in, @Nullable String wavAudioName, @Nullable WavAudio writeTo, @Nullable ALAudioClip clip) {
        WavAudio audio;
        String name = wavAudioName != null ? wavAudioName : "[Generic InputStream Source]";
        WavAudio wavAudio = audio = writeTo != null ? writeTo : new WavAudio();
        if (clip == null) {
            RenderSystem.assertOnRenderThread();
        }
        if (!ALUtils.isOpenAlReady()) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! OpenAL not ready! Returning empty audio for: " + name);
            return audio;
        }
        try {
            audio.clip = clip != null ? clip : ALAudioClip.create();
        }
        catch (Exception ex) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Failed to create clip: " + name, (Throwable)ex);
            return audio;
        }
        ALAudioClip cachedClip = audio.clip;
        if (cachedClip == null) {
            audio.loadingFailed = true;
            LOGGER.error("[FANCYMENU] Failed to read WAV audio! Clip was NULL: " + name);
            return audio;
        }
        new Thread(() -> {
            AudioInputStream stream = null;
            ByteArrayInputStream byteIn = null;
            try {
                ALAudioBuffer audioBuffer;
                byteIn = new ByteArrayInputStream(in.readAllBytes());
                stream = AudioSystem.getAudioInputStream(byteIn);
                ByteBuffer byteBuffer = ALUtils.readStreamIntoBuffer((InputStream)stream);
                audio.audioBuffer = audioBuffer = new ALAudioBuffer(byteBuffer, stream.getFormat());
                cachedClip.setStaticBuffer(audioBuffer);
                audio.decoded = true;
                audio.loadingCompleted = true;
            }
            catch (Exception ex) {
                audio.loadingFailed = true;
                LOGGER.error("[FANCYMENU] Failed to read WAV audio: " + name, (Throwable)ex);
            }
            CloseableUtils.closeQuietly(stream);
            CloseableUtils.closeQuietly(in);
            CloseableUtils.closeQuietly(byteIn);
        }).start();
        return audio;
    }

    @NotNull
    public static WavAudio of(@NotNull InputStream in) {
        return WavAudio.of(in, null, null, null);
    }

    protected WavAudio() {
    }

    @Nullable
    public ALAudioClip getClip() {
        return this.clip;
    }

    @Override
    public void play() {
        this.forClip(alAudioClip -> {
            try {
                alAudioClip.play();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public boolean isPlaying() {
        try {
            ALAudioClip cached = this.clip;
            if (cached != null) {
                return cached.isPlaying();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void pause() {
        this.forClip(alAudioClip -> {
            try {
                alAudioClip.pause();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public boolean isPaused() {
        try {
            ALAudioClip cached = this.clip;
            if (cached != null) {
                return cached.isPaused();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void stop() {
        this.forClip(alAudioClip -> {
            try {
                alAudioClip.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void setVolume(float volume) {
        this.forClip(alAudioClip -> {
            try {
                alAudioClip.setVolume(volume);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public float getVolume() {
        ALAudioClip cached = this.clip;
        return cached != null ? cached.getVolume() : 0.0f;
    }

    @Override
    public void setSoundChannel(@NotNull SoundSource channel) {
        this.forClip(oggAudioClip -> oggAudioClip.setSoundChannel(channel));
    }

    @Override
    @NotNull
    public SoundSource getSoundChannel() {
        ALAudioClip cached = this.clip;
        return cached != null ? cached.getSoundChannel() : SoundSource.MASTER;
    }

    protected void forClip(@NotNull Consumer<ALAudioClip> clip) {
        ALAudioClip cached = this.clip;
        if (cached != null) {
            clip.accept(cached);
        }
    }

    @Override
    @Nullable
    public InputStream open() throws IOException {
        if (this.sourceURL != null) {
            return WebUtils.openResourceStream(this.sourceURL);
        }
        if (this.sourceFile != null) {
            return new FileInputStream(this.sourceFile);
        }
        if (this.sourceLocation != null) {
            return Minecraft.m_91087_().m_91098_().m_215595_(this.sourceLocation);
        }
        return null;
    }

    @Override
    public boolean isReady() {
        if (this.closed || !this.decoded) {
            return false;
        }
        ALAudioClip cachedClip = this.clip;
        if (cachedClip != null) {
            if (cachedClip.isClosed()) {
                return false;
            }
            if (cachedClip.isValidOpenAlSource()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLoadingCompleted() {
        return !this.closed && !this.loadingFailed && this.loadingCompleted;
    }

    @Override
    public boolean isLoadingFailed() {
        return this.loadingFailed;
    }

    public boolean isValidOpenAlSource() {
        ALAudioClip cached = this.clip;
        return cached != null && cached.isValidOpenAlSource();
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            ALAudioClip cachedClip = this.clip;
            if (cachedClip != null) {
                cachedClip.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to close OGG audio clip!", (Throwable)ex);
        }
        this.clip = null;
        try {
            ALAudioBuffer cachedBuffer = this.audioBuffer;
            if (cachedBuffer != null) {
                cachedBuffer.delete();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to delete OGG audio buffer!", (Throwable)ex);
        }
        this.audioBuffer = null;
        this.decoded = false;
    }

    @Override
    public boolean isClosed() {
        ALAudioClip cachedClip;
        if (!this.closed && (cachedClip = this.clip) != null && !cachedClip.isValidOpenAlSource()) {
            this.close();
        }
        return this.closed;
    }
}

