/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering;

import com.ordana.immersive_weathering.ImmersiveWeatheringClient;
import com.ordana.immersive_weathering.configs.ClientConfigs;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.BlockGrowthHandler;
import com.ordana.immersive_weathering.data.fluid_generators.FluidGeneratorsHandler;
import com.ordana.immersive_weathering.data.fluid_generators.ModFluidGenerators;
import com.ordana.immersive_weathering.data.position_tests.ModPositionRuleTests;
import com.ordana.immersive_weathering.dynamicpack.ServerDynamicResourcesHandler;
import com.ordana.immersive_weathering.events.ModEvents;
import com.ordana.immersive_weathering.events.ModLootInjects;
import com.ordana.immersive_weathering.network.NetworkHandler;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModCompostable;
import com.ordana.immersive_weathering.reg.ModCreativeTab;
import com.ordana.immersive_weathering.reg.ModEntities;
import com.ordana.immersive_weathering.reg.ModFeatures;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModRuleTests;
import com.ordana.immersive_weathering.reg.ModSoundEvents;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.ILightningStruckBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImmersiveWeathering {
    public static final String MOD_ID = "immersive_weathering";
    public static final Logger LOGGER = LogManager.getLogger();

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        CommonConfigs.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientConfigs.init();
            ImmersiveWeatheringClient.init();
        }
        PlatHelper.addCommonSetup(ImmersiveWeathering::setup);
        ServerDynamicResourcesHandler.INSTANCE.register();
        MoonlightEventsHelper.addListener(ModEvents::onFireConsume, IFireConsumeBlockEvent.class);
        MoonlightEventsHelper.addListener(ModEvents::onLightningHit, ILightningStruckBlockEvent.class);
        RegHelper.addLootTableInjects(ModLootInjects::onLootInject);
        ModCreativeTab.init();
        NetworkHandler.init();
        ModBlocks.init();
        ModItems.init();
        ModEntities.init();
        ModParticles.init();
        ModRuleTests.init();
        ModFeatures.init();
        ModSoundEvents.init();
        PlatHelper.addServerReloadListener((PreparableReloadListener)BlockGrowthHandler.RELOAD_INSTANCE, (ResourceLocation)ImmersiveWeathering.res("block_growths"));
        PlatHelper.addServerReloadListener((PreparableReloadListener)FluidGeneratorsHandler.RELOAD_INSTANCE, (ResourceLocation)ImmersiveWeathering.res("fluid_generators"));
    }

    public static void setup() {
        ModPositionRuleTests.register();
        ModFluidGenerators.register();
        ModCompostable.register();
    }
}

