/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.blocks.LayerBlock;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.entities.FallingLayerEntity;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LeafPileBlock
extends LayerBlock
implements BonemealableBlock {
    private static final int FIRE_SPREAD = 30;
    private static final int FLAMMABILITY = 60;
    public static final IntegerProperty LAYERS = ModBlockProperties.LEAF_LAYERS;
    public static final IntegerProperty AGE = ModBlockProperties.AGE;
    private static final VoxelShape[] SHAPE_BY_LAYER_L = new VoxelShape[9];
    private static final float[] COLLISIONS;
    private final boolean canBeBonemealed;
    private final boolean hasThorns;
    private final LeavesType leafType;

    public LeafPileBlock(BlockBehaviour.Properties settings, LeavesType leafType) {
        super(settings);
        this.leafType = leafType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        String name = leafType.id.m_135815_();
        this.canBeBonemealed = name.contains("flower");
        this.hasThorns = name.equals("spruce");
        RegHelper.registerBlockFlammability((Block)this, (int)30, (int)60);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    public LeavesType getLeafType() {
        return this.leafType;
    }

    @PlatformOnly(value={"forge"})
    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    @Override
    public int getLayers(BlockState state) {
        return (Integer)state.m_61143_((Property)LAYERS);
    }

    @Override
    public IntegerProperty layerProperty() {
        return LAYERS;
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    @Override
    public VoxelShape getDefaultShape(BlockState state) {
        return SHAPE_BY_LAYER_L[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        int layers = this.getLayers(state);
        if (layers > 3 && CommonConfigs.LEAF_PILES_SLOW.get().booleanValue() && entity instanceof LivingEntity && !(entity instanceof Fox) && !(entity instanceof Bee) && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44973_, (LivingEntity)((LivingEntity)entity)) <= 0) {
            Player player;
            float stuck = COLLISIONS[Math.max(0, layers - 1)];
            entity.m_7601_(state, new Vec3((double)stuck, 1.0, (double)stuck));
            if (!(layers < 6 || !this.hasThorns || level.f_46443_ || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_() || entity instanceof Player && !(player = (Player)entity).m_6844_(EquipmentSlot.LEGS).m_41619_())) {
                double d = Math.abs(entity.m_20185_() - entity.f_19790_);
                double e = Math.abs(entity.m_20189_() - entity.f_19792_);
                if (d >= (double)0.003f || e >= (double)0.003f) {
                    entity.m_6469_(level.m_269111_().m_269555_(), 0.5f * (float)(layers - 5));
                }
            }
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext c;
        Entity e;
        if (context instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)context).m_193113_()) instanceof FallingLayerEntity) {
            return SHAPE_BY_LAYER_L[(Integer)state.m_61143_((Property)LAYERS)];
        }
        return Shapes.m_83040_();
    }

    @Override
    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER_L[this.getLayers(state)];
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState bottomState = level.m_8055_(pos.m_7495_());
        if (bottomState.m_60734_() instanceof LeavesBlock) {
            return true;
        }
        if ((Integer)state.m_61143_((Property)LAYERS) != 0 && !bottomState.m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) {
            return false;
        }
        return !this.shouldFall(state, level.m_8055_(pos.m_7495_()));
    }

    @Override
    public boolean shouldFall(BlockState state, BlockState belowState) {
        if ((Integer)state.m_61143_((Property)LAYERS) == 0 && belowState.m_60713_(Blocks.f_49990_) || belowState.m_204336_(ModTags.LEAF_PILES)) {
            return false;
        }
        return super.shouldFall(state, belowState);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && (Integer)state.m_61143_((Property)LAYERS) <= 1) {
            state = (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(neighborState.m_60713_(Blocks.f_49990_) ? 0 : 1));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Override
    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        int i = (Integer)state.m_61143_((Property)LAYERS);
        if (context.m_43722_().m_150930_(this.m_5456_()) && i < 8 && i > 0) {
            return true;
        }
        return i < 3;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            int i = (Integer)blockState.m_61143_((Property)LAYERS);
            return (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        if (blockState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            return null;
        }
        BlockState below = ctx.m_43725_().m_8055_(ctx.m_8083_().m_7495_());
        if (below.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            if (!blockState.m_60795_()) {
                return null;
            }
            return (BlockState)this.m_49966_().m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(0));
        }
        return super.m_5573_(ctx);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return this.canBeBonemealed;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return this.canBeBonemealed;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            if (!(random.m_188501_() > 0.5f)) continue;
            BlockPos targetPos = pos.m_121945_(direction);
            BlockState targetBlock = level.m_8055_(targetPos);
            WeatheringHelper.getAzaleaGrowth(targetBlock).ifPresent(s -> level.m_46597_(targetPos, s));
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource r) {
        int age = (Integer)state.m_61143_((Property)AGE);
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        if (age == 10) {
            level.m_46961_(pos, true);
        } else if (age > 0 && level.f_46441_.m_188499_()) {
            if ((double)level.f_46441_.m_188501_() > 0.8 && level.m_8055_(pos.m_7495_()).m_204336_(ModTags.DIRT_BASE_BLOCKS)) {
                if (state.m_204336_(ModTags.LEAFY_LEAVES)) {
                    level.m_46597_(pos.m_7495_(), ModBlocks.LOAM.get().m_49966_());
                } else if (state.m_204336_(ModTags.PINE_LEAVES)) {
                    level.m_46597_(pos.m_7495_(), Blocks.f_50599_.m_49966_());
                }
            }
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1))).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers <= 1 ? layers : layers - 1)));
        }
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER_L, l -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(l * 2), (double)16.0));
        LeafPileBlock.SHAPE_BY_LAYER_L[0] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        COLLISIONS = new float[]{1.0f, 0.999f, 0.998f, 0.997f, 0.996f, 0.994f, 0.993f, 0.992f};
    }
}

