/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FireSootGrowth
extends BuiltinBlockGrowth {
    public FireSootGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Supplier<Holder<Biome>> biome) {
        if (this.growthChance != 1.0f && !(level.f_46441_.m_188501_() < this.growthChance)) {
            return;
        }
        if (level.m_46469_().m_46207_(GameRules.f_46131_)) {
            FireSootGrowth.spawnSootAboveFire(level, pos, 6);
        }
    }

    public static void spawnSootAboveFire(ServerLevel level, BlockPos pos, int smokeHeight) {
        BlockPos sootPos = pos;
        for (int i = 0; i < smokeHeight; ++i) {
            BlockState above = level.m_8055_((sootPos = sootPos.m_7494_()).m_7494_());
            if (!Block.m_49918_((VoxelShape)above.m_60812_((BlockGetter)level, sootPos.m_7494_()), (Direction)Direction.DOWN)) continue;
            if (level.m_8055_(sootPos).m_60795_()) {
                level.m_7731_(sootPos, (BlockState)ModBlocks.SOOT.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true)), 2);
            }
            return;
        }
    }
}

